/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.util;

import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class SerializationUtils {
    private SerializationUtils() {
    }

    public static byte[] serialize(Object obj) throws IOException {
        if (obj == null) {
            return null;
        }
        try (ByteArrayOutputStream b = new ByteArrayOutputStream();){
            try (ObjectOutputStream o = new ObjectOutputStream(b);){
                o.writeObject(obj);
            }
            byte[] byArray = b.toByteArray();
            return byArray;
        }
    }

    public static byte[] serialize(Object obj, String errorMessage) {
        try {
            return SerializationUtils.serialize(obj);
        }
        catch (IOException e) {
            throw new RuntimeException(errorMessage, e);
        }
    }

    public static Serializable deserialize(byte[] bytes) throws IOException, ClassNotFoundException {
        if (bytes == null) {
            return null;
        }
        try (ByteArrayInputStream b = new ByteArrayInputStream(bytes);){
            Serializable serializable;
            try (ObjectInputStream o = new ObjectInputStream(b);){
                serializable = (Serializable)o.readObject();
            }
            return serializable;
        }
    }

    public static Serializable deserialize(byte[] bytes, String errorMessage) {
        try {
            return SerializationUtils.deserialize(bytes);
        }
        catch (Exception e) {
            throw new RuntimeException(errorMessage, e);
        }
    }

    public static <S, T extends Serializable> Map<S, ArrayList<T>> makeValuesSerializable(Map<S, Collection<T>> map) {
        return Maps.transformValues(map, ArrayList::new);
    }

    public static String parseBenchmarkResult(String result) {
        String[] taskResults = result.split("\n");
        boolean isActualResultStart = false;
        StringBuilder actualResult = new StringBuilder();
        for (String taskResult : taskResults) {
            if (isActualResultStart) {
                actualResult.append(taskResult);
                continue;
            }
            if (!taskResult.trim().equals("{")) continue;
            isActualResultStart = true;
            actualResult.append(taskResult);
        }
        return actualResult.toString();
    }
}

