/*
 * Decompiled with CFR 0.152.
 */
package alluxio.scheduler.job;

import alluxio.client.block.stream.BlockWorkerClient;
import alluxio.scheduler.job.Job;
import alluxio.wire.WorkerInfo;
import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public abstract class Task<V>
implements Comparable<Task> {
    private ListenableFuture<V> mResponseFuture;
    private TaskStat mTaskStat = new TaskStat();
    private int mPriority = 1;
    private WorkerInfo mRunsOnWorker;
    protected Job mMyJob;

    protected abstract ListenableFuture<V> run(BlockWorkerClient var1);

    public WorkerInfo getMyRunningWorker() {
        return this.mRunsOnWorker;
    }

    public ListenableFuture<V> getResponseFuture() {
        return this.mResponseFuture;
    }

    public void execute(BlockWorkerClient client, WorkerInfo workerInfo) {
        this.mRunsOnWorker = workerInfo;
        this.mResponseFuture = this.run(client);
    }

    public Task withJob(Job job) {
        this.mMyJob = job;
        return this;
    }

    public TaskStat getTaskStat() {
        return this.mTaskStat;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Task other = (Task)obj;
        return this.getPriority() == other.getPriority() && this.getTaskStat() == other.getTaskStat() && Objects.equals(this.mRunsOnWorker, other.mRunsOnWorker) && Objects.equals(this.mMyJob, other.mMyJob) && Objects.equals(this.mResponseFuture, other.mResponseFuture);
    }

    public int hashCode() {
        return Objects.hash(this.mPriority, this.mTaskStat, this.mRunsOnWorker, this.mMyJob, this.mResponseFuture);
    }

    @Override
    public int compareTo(Task o) {
        if (this == o) {
            return 0;
        }
        if (o == null) {
            return 1;
        }
        return this.getPriority() - o.getPriority();
    }

    public void onComplete(Executor executor) {
    }

    public static class TaskStat {
        private final Stopwatch mStopwatch = Stopwatch.createStarted();
        private long mTimeInQ = -1L;
        private long mTotalTimeToComplete = -1L;

        public void recordTimeInQ() {
            this.mTimeInQ = this.mStopwatch.elapsed(TimeUnit.MILLISECONDS);
        }

        public void recordTimeToComplete() {
            this.mTotalTimeToComplete = this.mStopwatch.elapsed(TimeUnit.MILLISECONDS);
        }

        public String dumpStats() {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("TimeInQ:%s%n", this.mTimeInQ == -1L ? "N/A" : Long.valueOf(this.mTimeInQ))).append(String.format("TotalTimeToComplete:%s%n", this.mTotalTimeToComplete == -1L ? "N/A" : Long.valueOf(this.mTimeInQ)));
            return sb.toString();
        }
    }
}

