/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.wire;

import alluxio.RuntimeConstants;
import alluxio.grpc.BuildVersion;
import alluxio.grpc.JobWorkerHealth;
import alluxio.util.CommonUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.Collections;
import java.util.List;

public class JobWorkerHealth {
    private final long mWorkerId;
    private BuildVersion mVersion = RuntimeConstants.UNKNOWN_VERSION_INFO;
    private final List<Double> mLoadAverage;
    private final int mUnfinishedTasks;
    private final long mLastUpdated;
    private final int mTaskPoolSize;
    private final int mNumActiveTasks;
    private final String mHostname;

    public JobWorkerHealth(long workerId, List<Double> loadAverage, int taskPoolSize, int numActiveTasks, int unfinishedTasks, String hostname) {
        this(workerId, loadAverage, taskPoolSize, numActiveTasks, unfinishedTasks, hostname, RuntimeConstants.CURRENT_VERSION_INFO);
    }

    public JobWorkerHealth(long workerId, List<Double> loadAverage, int taskPoolSize, int numActiveTasks, int unfinishedTasks, String hostname, BuildVersion version) {
        this.mWorkerId = workerId;
        this.mLoadAverage = loadAverage;
        this.mUnfinishedTasks = unfinishedTasks;
        this.mLastUpdated = CommonUtils.getCurrentMs();
        this.mTaskPoolSize = taskPoolSize;
        this.mNumActiveTasks = numActiveTasks;
        this.mHostname = hostname;
        this.mVersion = version;
    }

    public JobWorkerHealth(alluxio.grpc.JobWorkerHealth jobWorkerHealth) {
        this.mWorkerId = jobWorkerHealth.getWorkerId();
        this.mLoadAverage = jobWorkerHealth.getLoadAverageList();
        this.mUnfinishedTasks = jobWorkerHealth.getUnfinishedTasks();
        this.mLastUpdated = jobWorkerHealth.getLastUpdated();
        this.mTaskPoolSize = jobWorkerHealth.getTaskPoolSize();
        this.mNumActiveTasks = jobWorkerHealth.getNumActiveTasks();
        this.mHostname = jobWorkerHealth.getHostname();
        if (jobWorkerHealth.hasVersion()) {
            this.mVersion = jobWorkerHealth.getVersion();
        }
    }

    public long getWorkerId() {
        return this.mWorkerId;
    }

    public List<Double> getLoadAverage() {
        return Collections.unmodifiableList(this.mLoadAverage);
    }

    public int getTaskPoolSize() {
        return this.mTaskPoolSize;
    }

    public int getNumActiveTasks() {
        return this.mNumActiveTasks;
    }

    public int getUnfinishedTasks() {
        return this.mUnfinishedTasks;
    }

    public String getHostname() {
        return this.mHostname;
    }

    public BuildVersion getVersion() {
        return this.mVersion;
    }

    public alluxio.grpc.JobWorkerHealth toProto() {
        JobWorkerHealth.Builder builder = alluxio.grpc.JobWorkerHealth.newBuilder().setWorkerId(this.mWorkerId).addAllLoadAverage(this.mLoadAverage).setUnfinishedTasks(this.mUnfinishedTasks).setTaskPoolSize(this.mTaskPoolSize).setNumActiveTasks(this.mNumActiveTasks).setLastUpdated(this.mLastUpdated).setHostname(this.mHostname).setVersion(this.mVersion);
        return builder.build();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mWorkerId, this.mLoadAverage, this.mLastUpdated, this.mHostname, this.mNumActiveTasks, this.mTaskPoolSize});
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof JobWorkerHealth)) {
            return false;
        }
        JobWorkerHealth that = (JobWorkerHealth)o;
        return Objects.equal((Object)this.mWorkerId, (Object)that.mWorkerId) && Objects.equal(this.mLoadAverage, that.mLoadAverage) && Objects.equal((Object)this.mLastUpdated, (Object)that.mLastUpdated) && Objects.equal((Object)this.mHostname, (Object)that.mHostname) && Objects.equal((Object)this.mTaskPoolSize, (Object)that.mTaskPoolSize) && Objects.equal((Object)this.mNumActiveTasks, (Object)that.mNumActiveTasks) && Objects.equal((Object)this.mVersion, (Object)that.mVersion);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("workerId", this.mWorkerId).add("loadAverage", this.mLoadAverage).add("lastUpdated", this.mLastUpdated).add("hostname", (Object)this.mHostname).add("taskPoolSize", this.mTaskPoolSize).add("numActiveTasks", this.mNumActiveTasks).add("version", (Object)this.mVersion.getVersion()).add("revision", (Object)this.mVersion.getRevision()).toString();
    }
}

