/*
 * Decompiled with CFR 0.152.
 */
package alluxio.scheduler.job;

import alluxio.client.block.stream.BlockWorkerClient;
import alluxio.scheduler.job.Job;
import alluxio.wire.WorkerInfo;
import com.google.common.base.MoreObjects;
import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public abstract class Task<V>
implements Comparable<Task> {
    private ListenableFuture<V> mResponseFuture;
    private TaskStat mTaskStat;
    private int mPriority = 1;
    private int mTaskId;
    private WorkerInfo mMyWorker;
    protected Job mMyJob;

    public Task(Job job, int taskId) {
        this.setJob(job);
        this.mTaskId = taskId;
        this.mTaskStat = new TaskStat();
    }

    protected abstract ListenableFuture<V> run(BlockWorkerClient var1);

    public WorkerInfo getMyRunningWorker() {
        return this.mMyWorker;
    }

    public void setMyRunningWorker(WorkerInfo workerInfo) {
        this.mMyWorker = workerInfo;
    }

    public int getTaskId() {
        return this.mTaskId;
    }

    public ListenableFuture<V> getResponseFuture() {
        return this.mResponseFuture;
    }

    public void execute(BlockWorkerClient client, WorkerInfo workerInfo) {
        this.mMyWorker = workerInfo;
        this.mResponseFuture = this.run(client);
    }

    public void setJob(Job job) {
        this.mMyJob = job;
    }

    public Job getJob() {
        return this.mMyJob;
    }

    public TaskStat getTaskStat() {
        return this.mTaskStat;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public void setPriority(int priority) {
        this.mPriority = priority;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Task other = (Task)obj;
        return this.getPriority() == other.getPriority() && Objects.equals(this.mMyJob, other.mMyJob);
    }

    public int hashCode() {
        return Objects.hash(this.mPriority, this.mMyJob);
    }

    @Override
    public int compareTo(Task o) {
        if (this == o) {
            return 0;
        }
        if (o == null) {
            return 1;
        }
        return this.getPriority() - o.getPriority();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("taskJobType", this.mMyJob.getClass()).add("taskJobId", (Object)this.mMyJob.getJobId()).add("taskId", this.mTaskId).toString();
    }

    public static class TaskStat {
        private final Stopwatch mStopwatch = Stopwatch.createStarted();
        private long mTimeInQ = -1L;
        private long mTotalTimeToComplete = -1L;

        public void recordTimeInQ() {
            this.mTimeInQ = this.mStopwatch.elapsed(TimeUnit.MILLISECONDS);
        }

        public void recordTimeToComplete() {
            this.mTotalTimeToComplete = this.mStopwatch.elapsed(TimeUnit.MILLISECONDS);
        }

        public String dumpStats() {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("TimeInQ:%s%n", this.mTimeInQ == -1L ? "N/A" : Long.valueOf(this.mTimeInQ))).append(String.format("TotalTimeToComplete:%s%n", this.mTotalTimeToComplete == -1L ? "N/A" : Long.valueOf(this.mTimeInQ)));
            return sb.toString();
        }
    }
}

