/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.workflow.composite;

import alluxio.job.JobConfig;
import alluxio.job.plan.persist.PersistConfig;
import alluxio.job.util.SerializationUtils;
import alluxio.job.workflow.composite.CompositeConfig;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;

public final class CompositeConfigTest {
    private static final CompositeConfig CONFIG;

    @Test
    public void jsonTest() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        CompositeConfig other = (CompositeConfig)mapper.readValue(mapper.writeValueAsString((Object)CONFIG), CompositeConfig.class);
        Assert.assertEquals((Object)CONFIG, (Object)other);
    }

    @Test
    public void javaSerializationTest() throws Exception {
        byte[] bytes = SerializationUtils.serialize((Object)CONFIG);
        TestCase.assertNotNull((Object)bytes);
        Serializable deserialized = SerializationUtils.deserialize((byte[])bytes);
        Assert.assertEquals(CompositeConfig.class, deserialized.getClass());
        Assert.assertEquals((Object)CONFIG, (Object)deserialized);
    }

    static {
        ArrayList<CompositeConfig> jobs = new ArrayList<CompositeConfig>();
        jobs.add(new CompositeConfig(new ArrayList(), Boolean.valueOf(true)));
        jobs.add(new CompositeConfig(new ArrayList(), Boolean.valueOf(false)));
        jobs.add(new CompositeConfig(Lists.newArrayList((Object[])new JobConfig[]{new PersistConfig("/", 1L, true, "")}), Boolean.valueOf(true)));
        CONFIG = new CompositeConfig(jobs, Boolean.valueOf(true));
    }
}

