/*
 * Decompiled with CFR 0.152.
 */
package alluxio.scheduler.job;

import alluxio.exception.runtime.AlluxioRuntimeException;
import alluxio.grpc.JobProgressReportFormat;
import alluxio.job.JobDescription;
import alluxio.proto.journal.Journal;
import alluxio.scheduler.job.JobState;
import alluxio.scheduler.job.Task;
import alluxio.wire.WorkerInfo;
import java.util.List;
import java.util.OptionalLong;
import java.util.Set;

public interface Job<T extends Task<?>> {
    public JobDescription getDescription();

    public OptionalLong getEndTime();

    public boolean needVerification();

    public JobState getJobState();

    public void setJobState(JobState var1, boolean var2);

    public String getJobId();

    public void failJob(AlluxioRuntimeException var1);

    public void setJobSuccess();

    public String getProgress(JobProgressReportFormat var1, boolean var2);

    public boolean isHealthy();

    public boolean isRunning();

    public boolean isDone();

    public boolean isCurrentPassDone();

    public void initiateVerification();

    public List<T> getNextTasks(Set<WorkerInfo> var1);

    public void onTaskSubmitFailure(Task<?> var1);

    public void onWorkerUnavailable(T var1);

    public Journal.JournalEntry toJournalEntry();

    public boolean processResponse(T var1);

    public boolean hasFailure();

    public void initializeJob();
}

