/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job;

import alluxio.grpc.JobStatusBlock;
import alluxio.job.wire.CmdStatusBlock;
import alluxio.job.wire.JobInfo;
import alluxio.job.wire.PlanInfo;
import alluxio.job.wire.SimpleJobStatusBlock;
import alluxio.job.wire.Status;
import alluxio.job.wire.TaskInfo;
import alluxio.job.wire.WorkflowInfo;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ProtoUtils {
    public static JobInfo fromProto(alluxio.grpc.JobInfo jobInfo) throws IOException {
        switch (jobInfo.getType()) {
            case PLAN: {
                return new PlanInfo(jobInfo);
            }
            case TASK: {
                return new TaskInfo(jobInfo);
            }
            case WORKFLOW: {
                return new WorkflowInfo(jobInfo);
            }
        }
        throw new IllegalStateException(String.format("Unexpected Type: %s", jobInfo.getType()));
    }

    public static Status fromProto(alluxio.grpc.Status status) throws IOException {
        switch (status) {
            case CREATED: {
                return Status.CREATED;
            }
            case CANCELED: {
                return Status.CANCELED;
            }
            case FAILED: {
                return Status.FAILED;
            }
            case RUNNING: {
                return Status.RUNNING;
            }
            case COMPLETED: {
                return Status.COMPLETED;
            }
        }
        throw new IllegalStateException(String.format("Unexpected Status type: %s", status));
    }

    public static CmdStatusBlock protoToCmdStatusBlock(alluxio.grpc.CmdStatusBlock cmdStatusBlock) throws IOException {
        ArrayList simpleJobStatusBlockList = Lists.newArrayList();
        List blocks = cmdStatusBlock.getJobStatusBlockList();
        for (JobStatusBlock block : blocks) {
            simpleJobStatusBlockList.add(new SimpleJobStatusBlock(block.getJobId(), ProtoUtils.fromProto(block.getJobStatus()), block.getFilePath(), block.getFilePathFailed()));
        }
        return new CmdStatusBlock(cmdStatusBlock.getJobControlId(), simpleJobStatusBlockList, cmdStatusBlock.getOperationType());
    }

    private ProtoUtils() {
    }
}

