/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.Configuration;
import alluxio.client.ClientContext;
import alluxio.client.file.FileSystem;
import alluxio.client.util.ClientTestUtils;
import alluxio.exception.ConnectionFailedException;
import alluxio.master.AbstractLocalAlluxioCluster;
import alluxio.master.LocalAlluxioMaster;
import alluxio.master.MasterContext;
import alluxio.underfs.UnderFileSystem;
import alluxio.worker.WorkerContext;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.curator.test.TestingServer;

@NotThreadSafe
public final class MultiMasterLocalAlluxioCluster
extends AbstractLocalAlluxioCluster {
    private TestingServer mCuratorServer = null;
    private int mNumOfMasters = 0;
    private final List<LocalAlluxioMaster> mMasters = new ArrayList<LocalAlluxioMaster>();

    public MultiMasterLocalAlluxioCluster(long workerCapacityBytes, int masters, int userBlockSize) {
        super(workerCapacityBytes, userBlockSize);
        this.mNumOfMasters = masters;
        try {
            this.mCuratorServer = new TestingServer();
            LOG.info("Started testing zookeeper: {}", (Object)this.mCuratorServer.getConnectString());
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public synchronized FileSystem getClient() throws IOException {
        return this.getMaster().getClient();
    }

    public String getUri() {
        return "alluxio-ft://" + this.mHostname + ":" + this.getMaster().getRPCLocalPort();
    }

    @Override
    public LocalAlluxioMaster getMaster() {
        for (LocalAlluxioMaster master : this.mMasters) {
            if (!master.isServing()) continue;
            return master;
        }
        return this.mMasters.get(0);
    }

    public int getLeaderIndex() {
        for (int i = 0; i < this.mNumOfMasters; ++i) {
            if (!this.mMasters.get(i).isServing()) continue;
            return i;
        }
        return -1;
    }

    public boolean killStandby() {
        for (int k = 0; k < this.mNumOfMasters; ++k) {
            if (this.mMasters.get(k).isServing()) continue;
            try {
                LOG.info("master {} is a standby. killing it...", (Object)k);
                this.mMasters.get(k).kill();
                LOG.info("master {} killed.", (Object)k);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean killLeader() {
        for (int k = 0; k < this.mNumOfMasters; ++k) {
            if (!this.mMasters.get(k).isServing()) continue;
            try {
                LOG.info("master {} is the leader. killing it...", (Object)k);
                this.mMasters.get(k).kill();
                LOG.info("master {} killed.", (Object)k);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                return false;
            }
            return true;
        }
        return false;
    }

    private void deleteDir(String path) throws IOException {
        UnderFileSystem ufs = UnderFileSystem.get((String)path, (Configuration)this.mMasterConf);
        if (ufs.exists(path) && !ufs.delete(path, true)) {
            throw new IOException("Folder " + path + " already exists but can not be deleted.");
        }
    }

    private void mkdir(String path) throws IOException {
        UnderFileSystem ufs = UnderFileSystem.get((String)path, (Configuration)this.mMasterConf);
        if (ufs.exists(path)) {
            ufs.delete(path, true);
        }
        if (!ufs.mkdirs(path, true)) {
            throw new IOException("Failed to make folder: " + path);
        }
    }

    @Override
    protected void startWorker(Configuration conf) throws IOException, ConnectionFailedException {
        this.mWorkerConf = WorkerContext.getConf();
        this.mWorkerConf.merge(conf);
        this.mWorkerConf.set("alluxio.worker.block.threads.max", "100");
        this.runWorker();
        ClientContext.getConf().merge(conf);
        ClientTestUtils.reinitializeClientContext();
    }

    @Override
    protected void startMaster(Configuration conf) throws IOException {
        this.mMasterConf = conf;
        this.mMasterConf.set("alluxio.zookeeper.enabled", "true");
        this.mMasterConf.set("alluxio.zookeeper.address", this.mCuratorServer.getConnectString());
        this.mMasterConf.set("alluxio.zookeeper.election.path", "/election");
        this.mMasterConf.set("alluxio.zookeeper.leader.path", "/leader");
        MasterContext.reset((Configuration)this.mMasterConf);
        for (int k = 0; k < this.mNumOfMasters; ++k) {
            LocalAlluxioMaster master = LocalAlluxioMaster.create(this.mHome);
            master.start();
            LOG.info("master NO.{} started, isServing: {}, address: {}", new Object[]{k, master.isServing(), master.getAddress()});
            this.mMasters.add(master);
            this.mMasterConf.set("alluxio.master.port", "0");
        }
        this.mkdir(this.mMasterConf.get("alluxio.underfs.address"));
        LOG.info("all {} masters started.", (Object)this.mNumOfMasters);
        LOG.info("waiting for a leader.");
        boolean hasLeader = false;
        block1: while (!hasLeader) {
            for (int i = 0; i < this.mMasters.size(); ++i) {
                if (!this.mMasters.get(i).isServing()) continue;
                LOG.info("master NO.{} is selected as leader. address: {}", (Object)i, (Object)this.mMasters.get(i).getAddress());
                hasLeader = true;
                continue block1;
            }
        }
        this.mMasterConf.set("alluxio.master.port", String.valueOf(this.getMaster().getRPCLocalPort()));
    }

    @Override
    public void stopTFS() throws Exception {
        this.mWorker.stop();
        for (int k = 0; k < this.mNumOfMasters; ++k) {
            this.mMasters.get(k).kill();
        }
        LOG.info("Stopping testing zookeeper: {}", (Object)this.mCuratorServer.getConnectString());
        this.mCuratorServer.stop();
    }
}

