/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.Configuration;
import alluxio.client.file.FileSystem;
import alluxio.exception.ConnectionFailedException;
import alluxio.master.AlluxioMaster;
import alluxio.master.LocalAlluxioMaster;
import alluxio.master.PrivateAccess;
import alluxio.master.block.BlockMaster;
import alluxio.master.block.BlockMasterPrivateAccess;
import alluxio.security.LoginUser;
import alluxio.underfs.UnderFileSystemCluster;
import alluxio.util.CommonUtils;
import alluxio.util.UnderFileSystemUtils;
import alluxio.util.io.PathUtils;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.worker.AlluxioWorker;
import alluxio.worker.WorkerIdRegistry;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import javax.annotation.concurrent.NotThreadSafe;
import org.powermock.reflect.Whitebox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class AbstractLocalAlluxioCluster {
    protected static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private static final long CLUSTER_READY_POLL_INTERVAL_MS = 10L;
    private static final long CLUSTER_READY_TIMEOUT_MS = 60000L;
    private static final String ELLIPSIS = "\u2026";
    private static final Random RANDOM_GENERATOR = new Random();
    protected long mWorkerCapacityBytes;
    protected int mUserBlockSize;
    protected Configuration mMasterConf;
    protected Configuration mWorkerConf;
    protected AlluxioWorker mWorker;
    protected UnderFileSystemCluster mUfsCluster;
    protected String mHome;
    protected String mHostname;
    protected Thread mWorkerThread;

    public AbstractLocalAlluxioCluster(long workerCapacityBytes, int userBlockSize) {
        this.mWorkerCapacityBytes = workerCapacityBytes;
        this.mUserBlockSize = userBlockSize;
    }

    public void start() throws IOException, ConnectionFailedException {
        this.start(this.newTestConf());
    }

    public void start(Configuration conf) throws IOException, ConnectionFailedException {
        System.setProperty("fs.hdfs.impl.disable.cache", "true");
        this.setupTest(conf);
        this.startMaster(conf);
        this.waitForMasterReady();
        this.startWorker(conf);
        this.waitForWorkerReady();
    }

    private void waitForMasterReady() {
        long startTime = System.currentTimeMillis();
        String actionMessage = "waiting for master to serve web";
        LOG.info(actionMessage + ELLIPSIS);
        while (!NetworkAddressUtils.isServing((String)this.getMaster().getWebBindHost(), (int)this.getMaster().getWebLocalPort()) || this.mMasterConf.getInt("alluxio.master.web.port") == 0) {
            this.waitAndCheckTimeout(startTime, actionMessage);
        }
        actionMessage = "waiting for master to serve rpc";
        LOG.info(actionMessage + ELLIPSIS);
        while (!NetworkAddressUtils.isServing((String)this.getMaster().getRPCBindHost(), (int)this.getMaster().getRPCLocalPort()) || this.mMasterConf.getInt("alluxio.master.port") == 0) {
            this.waitAndCheckTimeout(startTime, actionMessage);
        }
    }

    private void waitForWorkerReady() {
        long startTime = System.currentTimeMillis();
        String actionMessage = "waiting for worker to register with master";
        LOG.info(actionMessage + ELLIPSIS);
        while (!this.workerRegistered()) {
            this.waitAndCheckTimeout(startTime, actionMessage);
        }
        actionMessage = "waiting for worker to serve web";
        LOG.info(actionMessage + ELLIPSIS);
        while (!NetworkAddressUtils.isServing((String)this.mWorker.getWebBindHost(), (int)this.mWorker.getWebLocalPort()) || this.mWorkerConf.getInt("alluxio.worker.web.port") == 0) {
            this.waitAndCheckTimeout(startTime, actionMessage);
        }
        actionMessage = "waiting for worker to serve data";
        LOG.info(actionMessage + ELLIPSIS);
        while (!NetworkAddressUtils.isServing((String)this.mWorker.getDataBindHost(), (int)this.mWorker.getDataLocalPort()) || this.mWorkerConf.getInt("alluxio.worker.data.port") == 0) {
            this.waitAndCheckTimeout(startTime, actionMessage);
        }
        actionMessage = "waiting for worker to serve rpc";
        LOG.info(actionMessage + ELLIPSIS);
        while (!NetworkAddressUtils.isServing((String)this.mWorker.getRPCBindHost(), (int)this.mWorker.getRPCLocalPort()) || this.mWorkerConf.getInt("alluxio.worker.port") == 0) {
            this.waitAndCheckTimeout(startTime, actionMessage);
        }
    }

    private void waitAndCheckTimeout(long startTime, String actionMessage) {
        if (System.currentTimeMillis() - startTime > 60000L) {
            throw new RuntimeException("Failed to start cluster. Timed out " + actionMessage);
        }
        CommonUtils.sleepMs((long)10L);
    }

    private boolean workerRegistered() {
        long workerId = WorkerIdRegistry.getWorkerId();
        if (workerId == 0L) {
            return false;
        }
        BlockMaster blockMaster = PrivateAccess.getBlockMaster((AlluxioMaster)this.getMaster().getInternalMaster());
        return BlockMasterPrivateAccess.isWorkerRegistered((BlockMaster)blockMaster, (long)workerId);
    }

    protected abstract void startMaster(Configuration var1) throws IOException;

    protected abstract void startWorker(Configuration var1) throws IOException, ConnectionFailedException;

    protected void setupTest(Configuration conf) throws IOException {
        String alluxioHome = conf.get("alluxio.home");
        UnderFileSystemUtils.deleteDir((String)alluxioHome, (Configuration)conf);
        UnderFileSystemUtils.mkdirIfNotExists((String)conf.get("alluxio.underfs.address"), (Configuration)conf);
        int numLevel = conf.getInt("alluxio.worker.tieredstore.levels");
        for (int level = 0; level < numLevel; ++level) {
            String[] dirPaths;
            String tierLevelDirPath = String.format("alluxio.worker.tieredstore.level%d.dirs.path", level);
            for (String dirPath : dirPaths = conf.get(tierLevelDirPath).split(",")) {
                UnderFileSystemUtils.mkdirIfNotExists((String)dirPath, (Configuration)conf);
            }
        }
        this.mUfsCluster = UnderFileSystemCluster.get(this.mHome, conf);
        String journalFolder = this.mUfsCluster.getUnderFilesystemAddress() + "/journal" + RANDOM_GENERATOR.nextLong();
        conf.set("alluxio.master.journal.folder", journalFolder);
        UnderFileSystemUtils.mkdirIfNotExists((String)journalFolder, (Configuration)conf);
        for (String masterServiceName : AlluxioMaster.getServiceNames()) {
            UnderFileSystemUtils.mkdirIfNotExists((String)PathUtils.concatPath((Object)journalFolder, (Object[])new Object[]{masterServiceName}), (Configuration)conf);
        }
        UnderFileSystemUtils.touch((String)PathUtils.concatPath((Object)journalFolder, (Object[])new Object[]{"_format_" + System.currentTimeMillis()}), (Configuration)conf);
        if (this.mUfsCluster.getClass().getSimpleName().equals("LocalMiniDFSCluster") || this.mUfsCluster.getClass().getSimpleName().equals("S3UnderStorageCluster") || this.mUfsCluster.getClass().getSimpleName().equals("OSSUnderStorageCluster")) {
            String ufsAddress = this.mUfsCluster.getUnderFilesystemAddress() + this.mHome;
            conf.set("alluxio.underfs.address", ufsAddress);
        }
    }

    public void stop() throws Exception {
        this.stopFS();
        this.stopUFS();
        this.resetContext();
        this.resetLoginUser();
    }

    public abstract void stopFS() throws Exception;

    protected void stopUFS() throws Exception {
        LOG.info("stop under storage system");
        if (this.mUfsCluster != null) {
            this.mUfsCluster.cleanup();
        }
    }

    private void resetLoginUser() throws Exception {
        Field field = LoginUser.class.getDeclaredField("sLoginUser");
        field.setAccessible(true);
        field.set(null, null);
    }

    public Configuration newTestConf() throws IOException {
        Configuration testConf = Configuration.createDefaultConf();
        this.setAlluxioHome();
        this.setHostname();
        testConf.set("alluxio.test.mode", "true");
        testConf.set("alluxio.home", this.mHome);
        testConf.set("alluxio.user.block.size.bytes.default", Integer.toString(this.mUserBlockSize));
        testConf.set("alluxio.user.block.remote.read.buffer.size.bytes", Integer.toString(64));
        testConf.set("alluxio.master.hostname", this.mHostname);
        testConf.set("alluxio.master.port", Integer.toString(0));
        testConf.set("alluxio.master.web.port", Integer.toString(0));
        testConf.set("alluxio.master.ttl.checker.interval.ms", Integer.toString(1000));
        testConf.set("alluxio.master.worker.threads.min", "1");
        testConf.set("alluxio.master.worker.threads.max", "100");
        testConf.set("alluxio.master.bind.host", this.mHostname);
        testConf.set("alluxio.master.web.bind.host", this.mHostname);
        testConf.set("alluxio.master.retry", "3");
        testConf.set("alluxio.network.host.resolution.timeout.ms", "250");
        testConf.set("alluxio.web.threads", "1");
        testConf.set("alluxio.web.resources", PathUtils.concatPath((Object)System.getProperty("user.dir"), (Object[])new Object[]{"../core/server/src/main/webapp"}));
        testConf.set("alluxio.user.file.writetype.default", "CACHE_THROUGH");
        testConf.set("alluxio.worker.port", Integer.toString(0));
        testConf.set("alluxio.worker.data.port", Integer.toString(0));
        testConf.set("alluxio.worker.web.port", Integer.toString(0));
        testConf.set("alluxio.worker.data.folder", "/datastore");
        testConf.set("alluxio.worker.memory.size", Long.toString(this.mWorkerCapacityBytes));
        testConf.set("alluxio.worker.block.heartbeat.interval.ms", Integer.toString(15));
        testConf.set("alluxio.worker.block.threads.min", Integer.toString(1));
        testConf.set("alluxio.worker.block.threads.max", Integer.toString(2048));
        testConf.set("alluxio.worker.network.netty.worker.threads", Integer.toString(2));
        testConf.set("alluxio.worker.bind.host", this.mHostname);
        testConf.set("alluxio.worker.data.bind.host", this.mHostname);
        testConf.set("alluxio.worker.web.bind.host", this.mHostname);
        testConf.set("alluxio.worker.network.netty.shutdown.quiet.period", Integer.toString(0));
        testConf.set("alluxio.worker.network.netty.shutdown.timeout", Integer.toString(0));
        String ramdiskPath = PathUtils.concatPath((Object)this.mHome, (Object[])new Object[]{"ramdisk"});
        testConf.set(String.format("alluxio.worker.tieredstore.level%d.alias", 0), "MEM");
        testConf.set(String.format("alluxio.worker.tieredstore.level%d.dirs.path", 0), ramdiskPath);
        testConf.set(String.format("alluxio.worker.tieredstore.level%d.dirs.quota", 0), Long.toString(this.mWorkerCapacityBytes));
        int numLevel = testConf.getInt("alluxio.worker.tieredstore.levels");
        for (int level = 1; level < numLevel; ++level) {
            String tierLevelDirPath = String.format("alluxio.worker.tieredstore.level%d.dirs.path", level);
            String[] dirPaths = testConf.get(tierLevelDirPath).split(",");
            ArrayList<String> newPaths = new ArrayList<String>();
            for (String dirPath : dirPaths) {
                String newPath = this.mHome + dirPath;
                newPaths.add(newPath);
            }
            testConf.set(String.format("alluxio.worker.tieredstore.level%d.dirs.path", level), Joiner.on((char)',').join(newPaths));
        }
        testConf.merge((Map)System.getProperties());
        return testConf;
    }

    protected void runWorker() throws IOException, ConnectionFailedException {
        this.mWorker = new AlluxioWorker();
        Whitebox.setInternalState(AlluxioWorker.class, (String)"sAlluxioWorker", (Object)this.mWorker);
        Runnable runWorker = new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractLocalAlluxioCluster.this.mWorker.start();
                }
                catch (Exception e) {
                    throw new RuntimeException(e + " \n Start Worker Error \n" + e.getMessage(), e);
                }
            }
        };
        this.mWorkerThread = new Thread(runWorker);
        this.mWorkerThread.start();
    }

    public abstract FileSystem getClient() throws IOException;

    protected abstract LocalAlluxioMaster getMaster();

    public Configuration getMasterConf() {
        return this.mMasterConf;
    }

    protected void resetContext() {
    }

    protected void setHostname() {
        this.mHostname = NetworkAddressUtils.getLocalHostName((int)100);
    }

    protected void setAlluxioHome() throws IOException {
        this.mHome = File.createTempFile("Alluxio", "U" + System.currentTimeMillis()).getAbsolutePath();
    }
}

