/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.Configuration;
import alluxio.client.ClientContext;
import alluxio.client.file.FileSystem;
import alluxio.client.util.ClientTestUtils;
import alluxio.exception.ConnectionFailedException;
import alluxio.master.AbstractLocalAlluxioCluster;
import alluxio.master.LocalAlluxioMaster;
import alluxio.master.MasterContext;
import alluxio.wire.WorkerNetAddress;
import alluxio.worker.AlluxioWorker;
import alluxio.worker.WorkerContext;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class LocalAlluxioCluster
extends AbstractLocalAlluxioCluster {
    private LocalAlluxioMaster mMaster;

    public LocalAlluxioCluster(long workerCapacityBytes, int userBlockSize) {
        super(workerCapacityBytes, userBlockSize);
    }

    @Override
    public FileSystem getClient() throws IOException {
        return this.mMaster.getClient();
    }

    @Override
    public LocalAlluxioMaster getMaster() {
        return this.mMaster;
    }

    public String getHostname() {
        return this.mHostname;
    }

    public String getMasterUri() {
        return this.mMaster.getUri();
    }

    public int getMasterPort() {
        return this.mMaster.getRPCLocalPort();
    }

    public String getAlluxioHome() {
        return this.mHome;
    }

    public AlluxioWorker getWorker() {
        return this.mWorker;
    }

    public Configuration getWorkerConf() {
        return this.mWorkerConf;
    }

    public WorkerNetAddress getWorkerAddress() {
        return this.mWorker.getNetAddress();
    }

    @Override
    protected void startMaster(Configuration testConf) throws IOException {
        this.mMasterConf = new Configuration(testConf);
        MasterContext.reset((Configuration)this.mMasterConf);
        this.mMaster = LocalAlluxioMaster.create(this.mHome);
        this.mMaster.start();
        testConf.set("alluxio.master.port", String.valueOf(this.getMasterPort()));
        ClientContext.getConf().merge(testConf);
        ClientTestUtils.reinitializeClientContext();
    }

    @Override
    protected void startWorker(Configuration conf) throws IOException, ConnectionFailedException {
        this.mWorkerConf = new Configuration(conf);
        WorkerContext.reset((Configuration)this.mWorkerConf);
        this.runWorker();
    }

    @Override
    protected void resetContext() {
        MasterContext.reset();
        WorkerContext.reset();
        ClientTestUtils.resetClientContext();
    }

    @Override
    public void stopFS() throws Exception {
        LOG.info("stop Alluxio filesystem");
        this.mWorker.stop();
        this.mMaster.stop();
    }

    public void stopWorker() throws Exception {
        this.mMaster.clearClients();
        this.mWorker.stop();
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        System.clearProperty("fs.hdfs.impl.disable.cache");
    }
}

