/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs;

import alluxio.Configuration;
import alluxio.underfs.LocalFileSystemCluster;
import alluxio.underfs.UnderFileSystem;
import alluxio.util.io.PathUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang3.StringUtils;

@NotThreadSafe
public abstract class UnderFileSystemCluster {
    private static final String INTEGRATION_UFS_PROFILE_KEY = "ufs";
    private static String sUnderFSClass;
    private static UnderFileSystemCluster sUnderFSCluster;
    protected String mBaseDir;
    protected final Configuration mConfiguration;

    public static synchronized UnderFileSystemCluster get() {
        Preconditions.checkNotNull((Object)sUnderFSCluster, (Object)"sUnderFSCluster has not been initialized yet");
        return sUnderFSCluster;
    }

    public static synchronized UnderFileSystemCluster get(String baseDir, Configuration configuration) throws IOException {
        if (sUnderFSCluster == null) {
            sUnderFSCluster = UnderFileSystemCluster.getUnderFilesystemCluster(baseDir, configuration);
        }
        if (!sUnderFSCluster.isStarted()) {
            sUnderFSCluster.start();
            sUnderFSCluster.registerJVMOnExistHook();
        }
        return sUnderFSCluster;
    }

    public static UnderFileSystemCluster getUnderFilesystemCluster(String baseDir, Configuration configuration) {
        sUnderFSClass = System.getProperty(INTEGRATION_UFS_PROFILE_KEY);
        if (!StringUtils.isEmpty((CharSequence)sUnderFSClass)) {
            try {
                UnderFileSystemCluster ufsCluster = (UnderFileSystemCluster)Class.forName(sUnderFSClass).getConstructor(String.class, Configuration.class).newInstance(baseDir, configuration);
                System.out.println("Initialized under file system testing cluster of type " + ufsCluster.getClass().getCanonicalName() + " for integration testing");
                return ufsCluster;
            }
            catch (Exception e) {
                System.err.println("Failed to initialize the ufsCluster of " + sUnderFSClass + " for integration test.");
                throw Throwables.propagate((Throwable)e);
            }
        }
        System.out.println("Using default LocalFilesystemCluster for integration testing");
        return new LocalFileSystemCluster(baseDir, configuration);
    }

    public static synchronized String getUnderFSClass() {
        return sUnderFSClass;
    }

    public UnderFileSystemCluster(String baseDir, Configuration configuration) {
        this.mBaseDir = baseDir;
        this.mConfiguration = configuration;
    }

    public void cleanup() throws IOException {
        if (this.isStarted()) {
            String path = this.getUnderFilesystemAddress() + "/";
            UnderFileSystem ufs = UnderFileSystem.get((String)path, (Configuration)this.mConfiguration);
            for (String p : ufs.list(path)) {
                ufs.delete(PathUtils.concatPath((Object)path, (Object[])new Object[]{p}), true);
            }
        }
    }

    public abstract String getUnderFilesystemAddress();

    public abstract boolean isStarted();

    public void registerJVMOnExistHook() throws IOException {
        Runtime.getRuntime().addShutdownHook(new ShutdownHook(this));
    }

    public abstract void shutdown() throws IOException;

    public abstract void start() throws IOException;

    static {
        sUnderFSCluster = null;
    }

    class ShutdownHook
    extends Thread {
        UnderFileSystemCluster mUFSCluster = null;

        public ShutdownHook(UnderFileSystemCluster ufsCluster) {
            this.mUFSCluster = ufsCluster;
        }

        @Override
        public void run() {
            if (this.mUFSCluster != null) {
                try {
                    this.mUFSCluster.shutdown();
                }
                catch (IOException e) {
                    System.out.println("Failed to shutdown underfs cluster: " + e);
                }
            }
        }
    }
}

