/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.AlluxioTestDirectory;
import alluxio.Configuration;
import alluxio.ConfigurationTestUtils;
import alluxio.client.file.FileSystem;
import alluxio.client.util.ClientTestUtils;
import alluxio.exception.ConnectionFailedException;
import alluxio.master.AlluxioMaster;
import alluxio.master.LocalAlluxioMaster;
import alluxio.master.PrivateAccess;
import alluxio.master.block.BlockMaster;
import alluxio.master.block.BlockMasterPrivateAccess;
import alluxio.security.LoginUser;
import alluxio.underfs.LocalFileSystemCluster;
import alluxio.underfs.UnderFileSystemCluster;
import alluxio.util.CommonUtils;
import alluxio.util.UnderFileSystemUtils;
import alluxio.util.io.PathUtils;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.worker.AlluxioWorker;
import alluxio.worker.WorkerIdRegistry;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import javax.annotation.concurrent.NotThreadSafe;
import org.powermock.reflect.Whitebox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class AbstractLocalAlluxioCluster {
    protected static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private static final long CLUSTER_READY_POLL_INTERVAL_MS = 10L;
    private static final long CLUSTER_READY_TIMEOUT_MS = 60000L;
    private static final String ELLIPSIS = "\u2026";
    private static final Random RANDOM_GENERATOR = new Random();
    protected long mWorkerCapacityBytes;
    protected int mUserBlockSize;
    protected AlluxioWorker mWorker;
    protected UnderFileSystemCluster mUfsCluster;
    protected String mHome;
    protected String mHostname;
    protected Thread mWorkerThread;

    public AbstractLocalAlluxioCluster(long workerCapacityBytes, int userBlockSize) {
        this.mWorkerCapacityBytes = workerCapacityBytes;
        this.mUserBlockSize = userBlockSize;
    }

    public void start() throws IOException, ConnectionFailedException {
        System.setProperty("fs.hdfs.impl.disable.cache", "true");
        this.setupTest();
        this.startMaster();
        this.waitForMasterReady();
        this.startWorker();
        this.waitForWorkerReady();
        this.reset();
    }

    private void waitForMasterReady() {
        long startTime = System.currentTimeMillis();
        String actionMessage = "waiting for master to serve web";
        LOG.info(actionMessage + ELLIPSIS);
        while (!NetworkAddressUtils.isServing((String)this.getMaster().getWebBindHost(), (int)this.getMaster().getWebLocalPort()) || Configuration.getInt((String)"alluxio.master.web.port") == 0) {
            this.waitAndCheckTimeout(startTime, actionMessage);
        }
        actionMessage = "waiting for master to serve rpc";
        LOG.info(actionMessage + ELLIPSIS);
        while (!NetworkAddressUtils.isServing((String)this.getMaster().getRPCBindHost(), (int)this.getMaster().getRPCLocalPort()) || Configuration.getInt((String)"alluxio.master.port") == 0) {
            this.waitAndCheckTimeout(startTime, actionMessage);
        }
    }

    private void waitForWorkerReady() {
        long startTime = System.currentTimeMillis();
        String actionMessage = "waiting for worker to register with master";
        LOG.info(actionMessage + ELLIPSIS);
        while (!this.workerRegistered()) {
            this.waitAndCheckTimeout(startTime, actionMessage);
        }
        actionMessage = "waiting for worker to serve web";
        LOG.info(actionMessage + ELLIPSIS);
        while (!NetworkAddressUtils.isServing((String)this.mWorker.getWebBindHost(), (int)this.mWorker.getWebLocalPort()) || Configuration.getInt((String)"alluxio.worker.web.port") == 0) {
            this.waitAndCheckTimeout(startTime, actionMessage);
        }
        actionMessage = "waiting for worker to serve data";
        LOG.info(actionMessage + ELLIPSIS);
        while (!NetworkAddressUtils.isServing((String)this.mWorker.getDataBindHost(), (int)this.mWorker.getDataLocalPort()) || Configuration.getInt((String)"alluxio.worker.data.port") == 0) {
            this.waitAndCheckTimeout(startTime, actionMessage);
        }
        actionMessage = "waiting for worker to serve rpc";
        LOG.info(actionMessage + ELLIPSIS);
        while (!NetworkAddressUtils.isServing((String)this.mWorker.getRPCBindHost(), (int)this.mWorker.getRPCLocalPort()) || Configuration.getInt((String)"alluxio.worker.port") == 0) {
            this.waitAndCheckTimeout(startTime, actionMessage);
        }
    }

    private void waitAndCheckTimeout(long startTime, String actionMessage) {
        if (System.currentTimeMillis() - startTime > 60000L) {
            throw new RuntimeException("Failed to start cluster. Timed out " + actionMessage);
        }
        CommonUtils.sleepMs((long)10L);
    }

    private boolean workerRegistered() {
        long workerId = WorkerIdRegistry.getWorkerId();
        if (workerId == 0L) {
            return false;
        }
        BlockMaster blockMaster = PrivateAccess.getBlockMaster((AlluxioMaster)this.getMaster().getInternalMaster());
        return BlockMasterPrivateAccess.isWorkerRegistered((BlockMaster)blockMaster, (long)workerId);
    }

    protected abstract void startMaster() throws IOException;

    protected abstract void startWorker() throws IOException, ConnectionFailedException;

    protected void setupTest() throws IOException {
        String alluxioHome = Configuration.get((String)"alluxio.home");
        UnderFileSystemUtils.deleteDir((String)alluxioHome);
        UnderFileSystemUtils.mkdirIfNotExists((String)Configuration.get((String)"alluxio.underfs.address"));
        int numLevel = Configuration.getInt((String)"alluxio.worker.tieredstore.levels");
        for (int level = 0; level < numLevel; ++level) {
            String[] dirPaths;
            String tierLevelDirPath = String.format("alluxio.worker.tieredstore.level%d.dirs.path", level);
            for (String dirPath : dirPaths = Configuration.get((String)tierLevelDirPath).split(",")) {
                UnderFileSystemUtils.mkdirIfNotExists((String)dirPath);
            }
        }
        this.mUfsCluster = UnderFileSystemCluster.get(this.mHome);
        String journalFolder = this.mUfsCluster.getUnderFilesystemAddress() + "/journal" + RANDOM_GENERATOR.nextLong();
        Configuration.set((String)"alluxio.master.journal.folder", (String)journalFolder);
        UnderFileSystemUtils.mkdirIfNotExists((String)journalFolder);
        for (String masterServiceName : AlluxioMaster.getServiceNames()) {
            UnderFileSystemUtils.mkdirIfNotExists((String)PathUtils.concatPath((Object)journalFolder, (Object[])new Object[]{masterServiceName}));
        }
        UnderFileSystemUtils.touch((String)PathUtils.concatPath((Object)journalFolder, (Object[])new Object[]{"_format_" + System.currentTimeMillis()}));
        if (!this.mUfsCluster.getClass().getName().equals(LocalFileSystemCluster.class.getName())) {
            String ufsAddress = this.mUfsCluster.getUnderFilesystemAddress() + this.mHome;
            Configuration.set((String)"alluxio.underfs.address", (String)ufsAddress);
        }
    }

    public void stop() throws Exception {
        this.stopFS();
        this.stopUFS();
        ConfigurationTestUtils.resetConfiguration();
        this.reset();
        this.resetLoginUser();
    }

    public abstract void stopFS() throws Exception;

    protected void stopUFS() throws Exception {
        LOG.info("stop under storage system");
        if (this.mUfsCluster != null) {
            this.mUfsCluster.cleanup();
        }
    }

    private void resetLoginUser() throws Exception {
        Field field = LoginUser.class.getDeclaredField("sLoginUser");
        field.setAccessible(true);
        field.set(null, null);
    }

    public void initializeTestConfiguration() throws IOException {
        this.setAlluxioHome();
        this.setHostname();
        Configuration.set((String)"alluxio.test.mode", (String)"true");
        Configuration.set((String)"alluxio.home", (String)this.mHome);
        Configuration.set((String)"alluxio.user.block.size.bytes.default", (String)Integer.toString(this.mUserBlockSize));
        Configuration.set((String)"alluxio.user.block.remote.read.buffer.size.bytes", (String)Integer.toString(64));
        Configuration.set((String)"alluxio.master.hostname", (String)this.mHostname);
        Configuration.set((String)"alluxio.master.port", (String)Integer.toString(0));
        Configuration.set((String)"alluxio.master.web.port", (String)Integer.toString(0));
        Configuration.set((String)"alluxio.master.ttl.checker.interval.ms", (String)Integer.toString(1000));
        Configuration.set((String)"alluxio.master.worker.threads.min", (String)"1");
        Configuration.set((String)"alluxio.master.worker.threads.max", (String)"100");
        Configuration.set((String)"alluxio.master.bind.host", (String)this.mHostname);
        Configuration.set((String)"alluxio.master.web.bind.host", (String)this.mHostname);
        Configuration.set((String)"alluxio.master.retry", (String)"3");
        Configuration.set((String)"alluxio.network.host.resolution.timeout.ms", (String)"250");
        Configuration.set((String)"alluxio.web.threads", (String)"1");
        Configuration.set((String)"alluxio.web.resources", (String)PathUtils.concatPath((Object)System.getProperty("user.dir"), (Object[])new Object[]{"../core/server/src/main/webapp"}));
        Configuration.set((String)"alluxio.user.file.writetype.default", (String)"CACHE_THROUGH");
        Configuration.set((String)"alluxio.worker.port", (String)Integer.toString(0));
        Configuration.set((String)"alluxio.worker.data.port", (String)Integer.toString(0));
        Configuration.set((String)"alluxio.worker.web.port", (String)Integer.toString(0));
        Configuration.set((String)"alluxio.worker.data.folder", (String)"/datastore");
        Configuration.set((String)"alluxio.worker.memory.size", (String)Long.toString(this.mWorkerCapacityBytes));
        Configuration.set((String)"alluxio.worker.block.heartbeat.interval.ms", (String)Integer.toString(15));
        Configuration.set((String)"alluxio.worker.block.threads.min", (String)Integer.toString(1));
        Configuration.set((String)"alluxio.worker.block.threads.max", (String)Integer.toString(2048));
        Configuration.set((String)"alluxio.worker.network.netty.worker.threads", (String)Integer.toString(2));
        Configuration.set((String)"alluxio.worker.bind.host", (String)this.mHostname);
        Configuration.set((String)"alluxio.worker.data.bind.host", (String)this.mHostname);
        Configuration.set((String)"alluxio.worker.web.bind.host", (String)this.mHostname);
        Configuration.set((String)"alluxio.worker.network.netty.shutdown.quiet.period", (String)Integer.toString(0));
        Configuration.set((String)"alluxio.worker.network.netty.shutdown.timeout", (String)Integer.toString(0));
        String ramdiskPath = PathUtils.concatPath((Object)this.mHome, (Object[])new Object[]{"ramdisk"});
        Configuration.set((String)String.format("alluxio.worker.tieredstore.level%d.alias", 0), (String)"MEM");
        Configuration.set((String)String.format("alluxio.worker.tieredstore.level%d.dirs.path", 0), (String)ramdiskPath);
        Configuration.set((String)String.format("alluxio.worker.tieredstore.level%d.dirs.quota", 0), (String)Long.toString(this.mWorkerCapacityBytes));
        int numLevel = Configuration.getInt((String)"alluxio.worker.tieredstore.levels");
        for (int level = 1; level < numLevel; ++level) {
            String tierLevelDirPath = String.format("alluxio.worker.tieredstore.level%d.dirs.path", level);
            String[] dirPaths = Configuration.get((String)tierLevelDirPath).split(",");
            ArrayList<String> newPaths = new ArrayList<String>();
            for (String dirPath : dirPaths) {
                String newPath = this.mHome + dirPath;
                newPaths.add(newPath);
            }
            Configuration.set((String)String.format("alluxio.worker.tieredstore.level%d.dirs.path", level), (String)Joiner.on((char)',').join(newPaths));
        }
        Configuration.merge((Map)System.getProperties());
    }

    protected void runWorker() throws IOException, ConnectionFailedException {
        this.mWorker = new AlluxioWorker();
        Whitebox.setInternalState(AlluxioWorker.class, (String)"sAlluxioWorker", (Object)this.mWorker);
        Runnable runWorker = new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractLocalAlluxioCluster.this.mWorker.start();
                }
                catch (Exception e) {
                    throw new RuntimeException(e + " \n Start Worker Error \n" + e.getMessage(), e);
                }
            }
        };
        this.mWorkerThread = new Thread(runWorker);
        this.mWorkerThread.start();
    }

    public abstract FileSystem getClient() throws IOException;

    protected abstract LocalAlluxioMaster getMaster();

    protected void reset() {
        ClientTestUtils.resetClient();
    }

    protected void setHostname() {
        this.mHostname = NetworkAddressUtils.getLocalHostName((int)100);
    }

    protected void setAlluxioHome() {
        this.mHome = AlluxioTestDirectory.createTemporaryDirectory((String)"test-cluster").getAbsolutePath();
    }
}

