/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.client.file.FileSystem;
import alluxio.exception.ConnectionFailedException;
import alluxio.master.AbstractLocalAlluxioCluster;
import alluxio.master.LocalAlluxioMaster;
import alluxio.wire.WorkerNetAddress;
import alluxio.worker.AlluxioWorker;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class LocalAlluxioCluster
extends AbstractLocalAlluxioCluster {
    private LocalAlluxioMaster mMaster;

    public LocalAlluxioCluster(long workerCapacityBytes, int userBlockSize) {
        super(workerCapacityBytes, userBlockSize);
    }

    @Override
    public FileSystem getClient() throws IOException {
        return this.mMaster.getClient();
    }

    @Override
    public LocalAlluxioMaster getMaster() {
        return this.mMaster;
    }

    public String getHostname() {
        return this.mHostname;
    }

    public String getMasterURI() {
        return this.mMaster.getUri();
    }

    public int getMasterPort() {
        return this.mMaster.getRPCLocalPort();
    }

    public String getAlluxioHome() {
        return this.mHome;
    }

    public AlluxioWorker getWorker() {
        return this.mWorker;
    }

    public WorkerNetAddress getWorkerAddress() {
        return this.mWorker.getNetAddress();
    }

    @Override
    protected void startMaster() throws IOException {
        this.mMaster = LocalAlluxioMaster.create(this.mHome);
        this.mMaster.start();
    }

    @Override
    protected void startWorker() throws IOException, ConnectionFailedException {
        this.runWorker();
    }

    @Override
    public void stopFS() throws Exception {
        LOG.info("stop Alluxio filesystem");
        this.mWorker.stop();
        this.mMaster.stop();
    }

    public void stopWorker() throws Exception {
        this.mMaster.clearClients();
        this.mWorker.stop();
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        System.clearProperty("fs.hdfs.impl.disable.cache");
    }
}

