/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.Configuration;
import alluxio.client.file.FileSystem;
import alluxio.master.AlluxioMaster;
import alluxio.master.ClientPool;
import alluxio.util.UnderFileSystemUtils;
import alluxio.util.network.NetworkAddressUtils;
import com.google.common.base.Supplier;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import javax.annotation.concurrent.NotThreadSafe;
import org.powermock.reflect.Whitebox;

@NotThreadSafe
public final class LocalAlluxioMaster {
    private final String mHostname;
    private final String mJournalFolder;
    private final AlluxioMaster mAlluxioMaster;
    private final Thread mMasterThread;
    private final Supplier<String> mClientSupplier = new Supplier<String>(){

        public String get() {
            return LocalAlluxioMaster.this.getUri();
        }
    };
    private final ClientPool mClientPool = new ClientPool(this.mClientSupplier);

    private LocalAlluxioMaster() throws IOException {
        this.mHostname = NetworkAddressUtils.getConnectHost((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.MASTER_RPC);
        this.mJournalFolder = Configuration.get((String)"alluxio.master.journal.folder");
        this.mAlluxioMaster = AlluxioMaster.Factory.create();
        Whitebox.setInternalState(AlluxioMaster.class, (String)"sAlluxioMaster", (Object)this.mAlluxioMaster);
        Configuration.set((String)"alluxio.master.port", (String)Integer.toString(this.getRPCLocalPort()));
        Runnable runMaster = new Runnable(){

            @Override
            public void run() {
                try {
                    LocalAlluxioMaster.this.mAlluxioMaster.start();
                }
                catch (Exception e) {
                    throw new RuntimeException(e + " \n Start Master Error \n" + e.getMessage(), e);
                }
            }
        };
        this.mMasterThread = new Thread(runMaster);
    }

    public static LocalAlluxioMaster create() throws IOException {
        String alluxioHome = LocalAlluxioMaster.uniquePath();
        UnderFileSystemUtils.deleteDir((String)alluxioHome);
        UnderFileSystemUtils.mkdirIfNotExists((String)alluxioHome);
        Configuration.set((String)"alluxio.home", (String)alluxioHome);
        return new LocalAlluxioMaster();
    }

    public static LocalAlluxioMaster create(String alluxioHome) throws IOException {
        UnderFileSystemUtils.mkdirIfNotExists((String)alluxioHome);
        return new LocalAlluxioMaster();
    }

    public void start() {
        this.mMasterThread.start();
    }

    public boolean isServing() {
        return this.mAlluxioMaster.isServing();
    }

    public void stop() throws Exception {
        this.clearClients();
        this.mAlluxioMaster.stop();
        System.clearProperty("alluxio.web.resources");
        System.clearProperty("alluxio.master.min.worker.threads");
    }

    public void kill() throws Exception {
        this.mMasterThread.interrupt();
    }

    public void clearClients() throws IOException {
        this.mClientPool.close();
    }

    public InetSocketAddress getAddress() {
        return this.mAlluxioMaster.getMasterAddress();
    }

    public AlluxioMaster getInternalMaster() {
        return this.mAlluxioMaster;
    }

    public String getRPCBindHost() {
        return this.mAlluxioMaster.getRPCBindHost();
    }

    public int getRPCLocalPort() {
        return this.mAlluxioMaster.getRPCLocalPort();
    }

    public String getWebBindHost() {
        return this.mAlluxioMaster.getWebBindHost();
    }

    public int getWebLocalPort() {
        return this.mAlluxioMaster.getWebLocalPort();
    }

    public String getUri() {
        return "alluxio://" + this.mHostname + ":" + this.getRPCLocalPort();
    }

    public FileSystem getClient() throws IOException {
        return this.mClientPool.getClient();
    }

    private static String uniquePath() throws IOException {
        return File.createTempFile("Alluxio", "").getAbsoluteFile() + "U" + System.nanoTime();
    }

    public String getJournalFolder() {
        return this.mJournalFolder;
    }
}

