/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.AlluxioTestDirectory;
import alluxio.Configuration;
import alluxio.ConfigurationTestUtils;
import alluxio.PropertyKey;
import alluxio.PropertyKeyFormat;
import alluxio.client.file.FileSystem;
import alluxio.client.util.ClientTestUtils;
import alluxio.exception.ConnectionFailedException;
import alluxio.master.AlluxioMaster;
import alluxio.master.LocalAlluxioMaster;
import alluxio.security.GroupMappingServiceTestUtils;
import alluxio.security.LoginUserTestUtils;
import alluxio.underfs.LocalFileSystemCluster;
import alluxio.underfs.UnderFileSystemCluster;
import alluxio.util.UnderFileSystemUtils;
import alluxio.util.io.PathUtils;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.worker.AlluxioWorkerService;
import alluxio.worker.DefaultAlluxioWorker;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class AbstractLocalAlluxioCluster {
    protected static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private static final Random RANDOM_GENERATOR = new Random();
    private static final int DEFAULT_BLOCK_SIZE_BYTES = 1024;
    private static final long DEFAULT_WORKER_MEMORY_BYTES = 0x6400000L;
    protected List<AlluxioWorkerService> mWorkers;
    protected UnderFileSystemCluster mUfsCluster;
    protected String mWorkDirectory;
    protected String mHostname;
    private int mNumWorkers;

    public AbstractLocalAlluxioCluster(int numWorkers) {
        this.mNumWorkers = numWorkers;
    }

    public void start() throws IOException, ConnectionFailedException {
        System.setProperty("fs.hdfs.impl.disable.cache", "true");
        this.setupTest();
        this.startMaster();
        this.getMaster().getInternalMaster().waitForReady();
        this.startWorkers();
        for (AlluxioWorkerService worker : this.mWorkers) {
            worker.waitForReady();
        }
        this.reset();
    }

    protected abstract void startMaster() throws IOException;

    protected abstract void startWorkers() throws IOException, ConnectionFailedException;

    protected void setupTest() throws IOException {
        String underfsAddress = Configuration.get((PropertyKey)PropertyKey.UNDERFS_ADDRESS);
        UnderFileSystemUtils.deleteDir((String)underfsAddress);
        UnderFileSystemUtils.mkdirIfNotExists((String)underfsAddress);
        int numLevel = Configuration.getInt((PropertyKey)PropertyKey.WORKER_TIERED_STORE_LEVELS);
        for (int level = 0; level < numLevel; ++level) {
            String[] dirPaths;
            PropertyKey tierLevelDirPath = PropertyKeyFormat.WORKER_TIERED_STORE_LEVEL_DIRS_PATH_FORMAT.format(new Object[]{level});
            for (String dirPath : dirPaths = Configuration.get((PropertyKey)tierLevelDirPath).split(",")) {
                UnderFileSystemUtils.mkdirIfNotExists((String)dirPath);
            }
        }
        this.mUfsCluster = UnderFileSystemCluster.get(this.mWorkDirectory);
        String journalFolder = this.mUfsCluster.getUnderFilesystemAddress() + "/journal" + RANDOM_GENERATOR.nextLong();
        Configuration.set((PropertyKey)PropertyKey.MASTER_JOURNAL_FOLDER, (Object)journalFolder);
        UnderFileSystemUtils.mkdirIfNotExists((String)journalFolder);
        for (String masterServiceName : AlluxioMaster.getServiceNames()) {
            UnderFileSystemUtils.mkdirIfNotExists((String)PathUtils.concatPath((Object)journalFolder, (Object[])new Object[]{masterServiceName}));
        }
        UnderFileSystemUtils.touch((String)PathUtils.concatPath((Object)journalFolder, (Object[])new Object[]{"_format_" + System.currentTimeMillis()}));
        if (!this.mUfsCluster.getClass().getName().equals(LocalFileSystemCluster.class.getName())) {
            String ufsAddress = this.mUfsCluster.getUnderFilesystemAddress() + this.mWorkDirectory;
            Configuration.set((PropertyKey)PropertyKey.UNDERFS_ADDRESS, (Object)ufsAddress);
        }
    }

    public void stop() throws Exception {
        this.stopFS();
        this.stopUFS();
        ConfigurationTestUtils.resetConfiguration();
        this.reset();
        LoginUserTestUtils.resetLoginUser();
    }

    public abstract void stopFS() throws Exception;

    protected void stopUFS() throws Exception {
        LOG.info("stop under storage system");
        if (this.mUfsCluster != null) {
            this.mUfsCluster.cleanup();
        }
    }

    public void initConfiguration() throws IOException {
        this.setAlluxioWorkDirectory();
        this.setHostname();
        Configuration.set((PropertyKey)PropertyKey.TEST_MODE, (Object)"true");
        Configuration.set((PropertyKey)PropertyKey.WORK_DIR, (Object)this.mWorkDirectory);
        Configuration.set((PropertyKey)PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT, (Object)Integer.toString(1024));
        Configuration.set((PropertyKey)PropertyKey.USER_BLOCK_REMOTE_READ_BUFFER_SIZE_BYTES, (Object)Integer.toString(64));
        Configuration.set((PropertyKey)PropertyKey.MASTER_HOSTNAME, (Object)this.mHostname);
        Configuration.set((PropertyKey)PropertyKey.MASTER_RPC_PORT, (Object)Integer.toString(0));
        Configuration.set((PropertyKey)PropertyKey.MASTER_WEB_PORT, (Object)Integer.toString(0));
        Configuration.set((PropertyKey)PropertyKey.MASTER_TTL_CHECKER_INTERVAL_MS, (Object)Integer.toString(1000));
        Configuration.set((PropertyKey)PropertyKey.MASTER_WORKER_THREADS_MIN, (Object)"1");
        Configuration.set((PropertyKey)PropertyKey.MASTER_WORKER_THREADS_MAX, (Object)"100");
        Configuration.set((PropertyKey)PropertyKey.MASTER_BIND_HOST, (Object)this.mHostname);
        Configuration.set((PropertyKey)PropertyKey.MASTER_WEB_BIND_HOST, (Object)this.mHostname);
        Configuration.set((PropertyKey)PropertyKey.MASTER_RETRY, (Object)"3");
        Configuration.set((PropertyKey)PropertyKey.NETWORK_HOST_RESOLUTION_TIMEOUT_MS, (Object)"250");
        Configuration.set((PropertyKey)PropertyKey.WEB_THREADS, (Object)"1");
        Configuration.set((PropertyKey)PropertyKey.WEB_RESOURCES, (Object)PathUtils.concatPath((Object)System.getProperty("user.dir"), (Object[])new Object[]{"../core/server/src/main/webapp"}));
        Configuration.set((PropertyKey)PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT, (Object)"CACHE_THROUGH");
        Configuration.set((PropertyKey)PropertyKey.WORKER_RPC_PORT, (Object)Integer.toString(0));
        Configuration.set((PropertyKey)PropertyKey.WORKER_DATA_PORT, (Object)Integer.toString(0));
        Configuration.set((PropertyKey)PropertyKey.WORKER_WEB_PORT, (Object)Integer.toString(0));
        Configuration.set((PropertyKey)PropertyKey.WORKER_DATA_FOLDER, (Object)"/datastore");
        Configuration.set((PropertyKey)PropertyKey.WORKER_MEMORY_SIZE, (Object)Long.toString(0x6400000L));
        Configuration.set((PropertyKey)PropertyKey.WORKER_BLOCK_HEARTBEAT_INTERVAL_MS, (Object)Integer.toString(15));
        Configuration.set((PropertyKey)PropertyKey.WORKER_BLOCK_THREADS_MIN, (Object)Integer.toString(1));
        Configuration.set((PropertyKey)PropertyKey.WORKER_BLOCK_THREADS_MAX, (Object)Integer.toString(2048));
        Configuration.set((PropertyKey)PropertyKey.WORKER_NETWORK_NETTY_WORKER_THREADS, (Object)Integer.toString(2));
        Configuration.set((PropertyKey)PropertyKey.WORKER_BIND_HOST, (Object)this.mHostname);
        Configuration.set((PropertyKey)PropertyKey.WORKER_DATA_BIND_HOST, (Object)this.mHostname);
        Configuration.set((PropertyKey)PropertyKey.WORKER_WEB_BIND_HOST, (Object)this.mHostname);
        Configuration.set((PropertyKey)PropertyKey.WORKER_NETWORK_NETTY_SHUTDOWN_QUIET_PERIOD, (Object)Integer.toString(0));
        Configuration.set((PropertyKey)PropertyKey.WORKER_NETWORK_NETTY_SHUTDOWN_TIMEOUT, (Object)Integer.toString(0));
        String ramdiskPath = PathUtils.concatPath((Object)this.mWorkDirectory, (Object[])new Object[]{"ramdisk"});
        Configuration.set((PropertyKey)PropertyKeyFormat.WORKER_TIERED_STORE_LEVEL_ALIAS_FORMAT.format(new Object[]{0}), (Object)"MEM");
        Configuration.set((PropertyKey)PropertyKeyFormat.WORKER_TIERED_STORE_LEVEL_DIRS_PATH_FORMAT.format(new Object[]{0}), (Object)ramdiskPath);
        int numLevel = Configuration.getInt((PropertyKey)PropertyKey.WORKER_TIERED_STORE_LEVELS);
        for (int level = 1; level < numLevel; ++level) {
            PropertyKey tierLevelDirPath = PropertyKeyFormat.WORKER_TIERED_STORE_LEVEL_DIRS_PATH_FORMAT.format(new Object[]{level});
            String[] dirPaths = Configuration.get((PropertyKey)tierLevelDirPath).split(",");
            ArrayList<String> newPaths = new ArrayList<String>();
            for (String dirPath : dirPaths) {
                String newPath = this.mWorkDirectory + dirPath;
                newPaths.add(newPath);
            }
            Configuration.set((PropertyKey)PropertyKeyFormat.WORKER_TIERED_STORE_LEVEL_DIRS_PATH_FORMAT.format(new Object[]{level}), (Object)Joiner.on((char)',').join(newPaths));
        }
        Configuration.merge((Map)System.getProperties());
    }

    protected void runWorkers() throws IOException, ConnectionFailedException {
        this.mWorkers = new ArrayList<AlluxioWorkerService>();
        for (int i = 0; i < this.mNumWorkers; ++i) {
            this.mWorkers.add((AlluxioWorkerService)new DefaultAlluxioWorker());
        }
        for (final AlluxioWorkerService worker : this.mWorkers) {
            Runnable runWorker = new Runnable(){

                @Override
                public void run() {
                    try {
                        worker.start();
                    }
                    catch (Exception e) {
                        LOG.error("Start worker error", (Throwable)e);
                        throw new RuntimeException(e + " \n Start Worker Error \n" + e.getMessage(), e);
                    }
                }
            };
            new Thread(runWorker).start();
        }
    }

    public abstract FileSystem getClient() throws IOException;

    protected abstract LocalAlluxioMaster getMaster();

    protected void reset() {
        ClientTestUtils.resetClient();
        GroupMappingServiceTestUtils.resetCache();
    }

    protected void setHostname() {
        this.mHostname = NetworkAddressUtils.getLocalHostName((int)100);
    }

    protected void setAlluxioWorkDirectory() {
        this.mWorkDirectory = AlluxioTestDirectory.createTemporaryDirectory((String)"test-cluster").getAbsolutePath();
    }
}

