/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.client.file.FileSystem;
import alluxio.exception.ConnectionFailedException;
import alluxio.master.AbstractLocalAlluxioCluster;
import alluxio.master.LocalAlluxioMaster;
import alluxio.wire.WorkerNetAddress;
import alluxio.worker.AlluxioWorkerService;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class LocalAlluxioCluster
extends AbstractLocalAlluxioCluster {
    private LocalAlluxioMaster mMaster;

    public LocalAlluxioCluster() {
        super(1);
    }

    public LocalAlluxioCluster(int numWorkers) {
        super(numWorkers);
    }

    @Override
    public FileSystem getClient() throws IOException {
        return this.mMaster.getClient();
    }

    @Override
    public LocalAlluxioMaster getMaster() {
        return this.mMaster;
    }

    public String getHostname() {
        return this.mHostname;
    }

    public String getMasterURI() {
        return this.mMaster.getUri();
    }

    public int getMasterRpcPort() {
        return this.mMaster.getRPCLocalPort();
    }

    public String getAlluxioHome() {
        return this.mWorkDirectory;
    }

    public AlluxioWorkerService getWorker() {
        return (AlluxioWorkerService)this.mWorkers.get(0);
    }

    public WorkerNetAddress getWorkerAddress() {
        return this.getWorker().getAddress();
    }

    @Override
    protected void startMaster() throws IOException {
        this.mMaster = LocalAlluxioMaster.create(this.mWorkDirectory);
        this.mMaster.start();
    }

    @Override
    protected void startWorkers() throws IOException, ConnectionFailedException {
        this.runWorkers();
    }

    @Override
    public void stopFS() throws Exception {
        LOG.info("stop Alluxio filesystem");
        for (AlluxioWorkerService worker : this.mWorkers) {
            worker.stop();
        }
        this.mMaster.stop();
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        System.clearProperty("fs.hdfs.impl.disable.cache");
    }
}

