/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.AlluxioTestDirectory;
import alluxio.Configuration;
import alluxio.PropertyKey;
import alluxio.client.file.FileSystem;
import alluxio.master.AlluxioMaster;
import alluxio.master.ClientPool;
import alluxio.util.UnderFileSystemUtils;
import alluxio.util.network.NetworkAddressUtils;
import com.google.common.base.Supplier;
import java.io.IOException;
import java.net.InetSocketAddress;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class LocalAlluxioMaster {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private final String mHostname;
    private final String mJournalFolder;
    private final AlluxioMaster mAlluxioMaster;
    private final Thread mMasterThread;
    private final Supplier<String> mClientSupplier = new Supplier<String>(){

        public String get() {
            return LocalAlluxioMaster.this.getUri();
        }
    };
    private final ClientPool mClientPool = new ClientPool(this.mClientSupplier);

    private LocalAlluxioMaster() throws IOException {
        this.mHostname = NetworkAddressUtils.getConnectHost((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.MASTER_RPC);
        this.mJournalFolder = Configuration.get((PropertyKey)PropertyKey.MASTER_JOURNAL_FOLDER);
        this.mAlluxioMaster = AlluxioMaster.Factory.create();
        Runnable runMaster = new Runnable(){

            @Override
            public void run() {
                try {
                    LocalAlluxioMaster.this.mAlluxioMaster.start();
                }
                catch (Exception e) {
                    LOG.error("Start master error", (Throwable)e);
                    throw new RuntimeException(e + " \n Start Master Error \n" + e.getMessage(), e);
                }
            }
        };
        this.mMasterThread = new Thread(runMaster);
    }

    public static LocalAlluxioMaster create() throws IOException {
        String workDirectory = LocalAlluxioMaster.uniquePath();
        UnderFileSystemUtils.deleteDir((String)workDirectory);
        UnderFileSystemUtils.mkdirIfNotExists((String)workDirectory);
        Configuration.set((PropertyKey)PropertyKey.WORK_DIR, (Object)workDirectory);
        return new LocalAlluxioMaster();
    }

    public static LocalAlluxioMaster create(String workDirectory) throws IOException {
        UnderFileSystemUtils.mkdirIfNotExists((String)workDirectory);
        return new LocalAlluxioMaster();
    }

    public void start() {
        this.mMasterThread.start();
    }

    public boolean isServing() {
        return this.mAlluxioMaster.isServing();
    }

    public void stop() throws Exception {
        this.clearClients();
        this.mAlluxioMaster.stop();
        System.clearProperty("alluxio.web.resources");
        System.clearProperty("alluxio.master.min.worker.threads");
    }

    public void kill() throws Exception {
        this.mMasterThread.interrupt();
    }

    public void clearClients() throws IOException {
        this.mClientPool.close();
    }

    public InetSocketAddress getAddress() {
        return this.mAlluxioMaster.getMasterAddress();
    }

    public AlluxioMaster getInternalMaster() {
        return this.mAlluxioMaster;
    }

    public String getRPCBindHost() {
        return this.mAlluxioMaster.getRPCBindHost();
    }

    public int getRPCLocalPort() {
        return this.mAlluxioMaster.getRPCLocalPort();
    }

    public String getWebBindHost() {
        return this.mAlluxioMaster.getWebBindHost();
    }

    public int getWebLocalPort() {
        return this.mAlluxioMaster.getWebLocalPort();
    }

    public String getUri() {
        return "alluxio://" + this.mHostname + ":" + this.getRPCLocalPort();
    }

    public FileSystem getClient() throws IOException {
        return this.mClientPool.getClient();
    }

    private static String uniquePath() throws IOException {
        return AlluxioTestDirectory.createTemporaryDirectory((String)"alluxio-master").getAbsolutePath();
    }

    public String getJournalFolder() {
        return this.mJournalFolder;
    }
}

