/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.AlluxioTestDirectory;
import alluxio.Configuration;
import alluxio.PropertyKey;
import alluxio.client.file.FileSystem;
import alluxio.exception.ConnectionFailedException;
import alluxio.master.AbstractLocalAlluxioCluster;
import alluxio.master.LocalAlluxioMaster;
import alluxio.underfs.UnderFileSystem;
import alluxio.worker.AlluxioWorkerService;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.curator.test.TestingServer;

@NotThreadSafe
public final class MultiMasterLocalAlluxioCluster
extends AbstractLocalAlluxioCluster {
    private TestingServer mCuratorServer = null;
    private int mNumOfMasters = 0;
    private final List<LocalAlluxioMaster> mMasters = new ArrayList<LocalAlluxioMaster>();

    public MultiMasterLocalAlluxioCluster(int masters) {
        this(masters, 1);
    }

    public MultiMasterLocalAlluxioCluster(int masters, int numWorkers) {
        super(numWorkers);
        this.mNumOfMasters = masters;
        try {
            this.mCuratorServer = new TestingServer(-1, AlluxioTestDirectory.createTemporaryDirectory((String)"zk"));
            LOG.info("Started testing zookeeper: {}", (Object)this.mCuratorServer.getConnectString());
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public synchronized FileSystem getClient() throws IOException {
        return this.getMaster().getClient();
    }

    public String getUri() {
        return "alluxio-ft://" + this.mHostname + ":" + this.getMaster().getRPCLocalPort();
    }

    @Override
    public LocalAlluxioMaster getMaster() {
        for (LocalAlluxioMaster master : this.mMasters) {
            if (!master.isServing()) continue;
            return master;
        }
        return this.mMasters.get(0);
    }

    public int getLeaderIndex() {
        for (int i = 0; i < this.mNumOfMasters; ++i) {
            if (!this.mMasters.get(i).isServing()) continue;
            return i;
        }
        return -1;
    }

    public boolean killStandby() {
        for (int k = 0; k < this.mNumOfMasters; ++k) {
            if (this.mMasters.get(k).isServing()) continue;
            try {
                LOG.info("master {} is a standby. killing it...", (Object)k);
                this.mMasters.get(k).kill();
                LOG.info("master {} killed.", (Object)k);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean killLeader() {
        for (int k = 0; k < this.mNumOfMasters; ++k) {
            if (!this.mMasters.get(k).isServing()) continue;
            try {
                LOG.info("master {} is the leader. killing it...", (Object)k);
                this.mMasters.get(k).kill();
                LOG.info("master {} killed.", (Object)k);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                return false;
            }
            return true;
        }
        return false;
    }

    private void deleteDir(String path) throws IOException {
        UnderFileSystem ufs = UnderFileSystem.get((String)path);
        if (ufs.exists(path) && !ufs.delete(path, true)) {
            throw new IOException("Folder " + path + " already exists but can not be deleted.");
        }
    }

    private void mkdir(String path) throws IOException {
        UnderFileSystem ufs = UnderFileSystem.get((String)path);
        if (ufs.exists(path)) {
            ufs.delete(path, true);
        }
        if (!ufs.mkdirs(path, true)) {
            throw new IOException("Failed to make folder: " + path);
        }
    }

    @Override
    protected void startWorkers() throws IOException, ConnectionFailedException {
        Configuration.set((PropertyKey)PropertyKey.WORKER_BLOCK_THREADS_MAX, (Object)"100");
        this.runWorkers();
    }

    @Override
    protected void startMaster() throws IOException {
        Configuration.set((PropertyKey)PropertyKey.ZOOKEEPER_ENABLED, (Object)"true");
        Configuration.set((PropertyKey)PropertyKey.ZOOKEEPER_ADDRESS, (Object)this.mCuratorServer.getConnectString());
        Configuration.set((PropertyKey)PropertyKey.ZOOKEEPER_ELECTION_PATH, (Object)"/election");
        Configuration.set((PropertyKey)PropertyKey.ZOOKEEPER_LEADER_PATH, (Object)"/leader");
        for (int k = 0; k < this.mNumOfMasters; ++k) {
            LocalAlluxioMaster master = LocalAlluxioMaster.create(this.mWorkDirectory);
            master.start();
            LOG.info("master NO.{} started, isServing: {}, address: {}", new Object[]{k, master.isServing(), master.getAddress()});
            this.mMasters.add(master);
            Configuration.set((PropertyKey)PropertyKey.MASTER_RPC_PORT, (Object)"0");
        }
        this.mkdir(Configuration.get((PropertyKey)PropertyKey.UNDERFS_ADDRESS));
        LOG.info("all {} masters started.", (Object)this.mNumOfMasters);
        LOG.info("waiting for a leader.");
        boolean hasLeader = false;
        block1: while (!hasLeader) {
            for (int i = 0; i < this.mMasters.size(); ++i) {
                if (!this.mMasters.get(i).isServing()) continue;
                LOG.info("master NO.{} is selected as leader. address: {}", (Object)i, (Object)this.mMasters.get(i).getAddress());
                hasLeader = true;
                continue block1;
            }
        }
        Configuration.set((PropertyKey)PropertyKey.MASTER_RPC_PORT, (Object)String.valueOf(this.getMaster().getRPCLocalPort()));
    }

    @Override
    public void stopFS() throws Exception {
        for (AlluxioWorkerService worker : this.mWorkers) {
            worker.stop();
        }
        for (int k = 0; k < this.mNumOfMasters; ++k) {
            this.mMasters.get(k).kill();
        }
        LOG.info("Stopping testing zookeeper: {}", (Object)this.mCuratorServer.getConnectString());
        this.mCuratorServer.stop();
    }
}

