/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.AlluxioTestDirectory;
import alluxio.Configuration;
import alluxio.ConfigurationTestUtils;
import alluxio.PropertyKey;
import alluxio.cli.Format;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.util.ClientTestUtils;
import alluxio.master.LocalAlluxioMaster;
import alluxio.proxy.ProxyProcess;
import alluxio.security.GroupMappingServiceTestUtils;
import alluxio.security.LoginUserTestUtils;
import alluxio.underfs.LocalFileSystemCluster;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemCluster;
import alluxio.util.UnderFileSystemUtils;
import alluxio.util.io.FileUtils;
import alluxio.util.io.PathUtils;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.worker.WorkerProcess;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class AbstractLocalAlluxioCluster {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLocalAlluxioCluster.class);
    private static final Random RANDOM_GENERATOR = new Random();
    private static final int DEFAULT_BLOCK_SIZE_BYTES = 1024;
    private static final long DEFAULT_WORKER_MEMORY_BYTES = 0x6400000L;
    protected ProxyProcess mProxyProcess = ProxyProcess.Factory.create();
    protected Thread mProxyThread;
    protected List<WorkerProcess> mWorkers;
    protected List<Thread> mWorkerThreads;
    protected UnderFileSystemCluster mUfsCluster;
    protected String mWorkDirectory;
    protected String mHostname;
    private int mNumWorkers;

    AbstractLocalAlluxioCluster(int numWorkers) {
        this.mNumWorkers = numWorkers;
        this.mWorkerThreads = new ArrayList<Thread>();
    }

    public void start() throws Exception {
        System.setProperty("fs.hdfs.impl.disable.cache", "true");
        this.resetClientPools();
        this.setupTest();
        this.startMasters();
        FileSystemContext.INSTANCE.reset();
        this.startWorkers();
        this.startProxy();
        this.reset();
    }

    protected abstract void startMasters() throws Exception;

    private void startProxy() throws Exception {
        this.mProxyProcess = ProxyProcess.Factory.create();
        Runnable runProxy = new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractLocalAlluxioCluster.this.mProxyProcess.start();
                }
                catch (InterruptedException e) {
                }
                catch (Exception e) {
                    LOG.error("Start proxy error", (Throwable)e);
                    throw new RuntimeException(e + " \n Start Proxy Error \n" + e.getMessage(), e);
                }
            }
        };
        this.mProxyThread = new Thread(runProxy);
        this.mProxyThread.setName("ProxyThread-" + System.identityHashCode(this.mProxyThread));
        this.mProxyThread.start();
        this.mProxyProcess.waitForReady();
    }

    public void startWorkers() throws Exception {
        this.mWorkers = new ArrayList<WorkerProcess>();
        for (int i = 0; i < this.mNumWorkers; ++i) {
            this.mWorkers.add(WorkerProcess.Factory.create());
        }
        for (final WorkerProcess worker : this.mWorkers) {
            Runnable runWorker = new Runnable(){

                @Override
                public void run() {
                    try {
                        worker.start();
                    }
                    catch (InterruptedException e) {
                    }
                    catch (Exception e) {
                        LOG.error("Start worker error", (Throwable)e);
                        throw new RuntimeException(e + " \n Start Worker Error \n" + e.getMessage(), e);
                    }
                }
            };
            Thread thread = new Thread(runWorker);
            thread.setName("WorkerThread-" + System.identityHashCode(thread));
            this.mWorkerThreads.add(thread);
            thread.start();
        }
        for (final WorkerProcess worker : this.mWorkers) {
            worker.waitForReady();
        }
    }

    protected void setupTest() throws IOException {
        UnderFileSystem ufs = UnderFileSystem.Factory.createForRoot();
        String underfsAddress = Configuration.get((PropertyKey)PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS);
        UnderFileSystemUtils.deleteDirIfExists((UnderFileSystem)ufs, (String)underfsAddress);
        UnderFileSystemUtils.mkdirIfNotExists((UnderFileSystem)ufs, (String)underfsAddress);
        int numLevel = Configuration.getInt((PropertyKey)PropertyKey.WORKER_TIERED_STORE_LEVELS);
        for (int level = 0; level < numLevel; ++level) {
            String[] dirPaths;
            PropertyKey tierLevelDirPath = PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_DIRS_PATH.format(new Object[]{level});
            for (String dirPath : dirPaths = Configuration.get((PropertyKey)tierLevelDirPath).split(",")) {
                FileUtils.createDir((String)dirPath);
            }
        }
        this.mUfsCluster = UnderFileSystemCluster.get(this.mWorkDirectory);
        String journalFolder = this.mUfsCluster.getUnderFilesystemAddress() + "/journal" + RANDOM_GENERATOR.nextLong();
        Configuration.set((PropertyKey)PropertyKey.MASTER_JOURNAL_FOLDER, (Object)journalFolder);
        Format.format((Format.Mode)Format.Mode.MASTER);
        if (!this.mUfsCluster.getClass().getName().equals(LocalFileSystemCluster.class.getName())) {
            String ufsAddress = this.mUfsCluster.getUnderFilesystemAddress() + this.mWorkDirectory;
            Configuration.set((PropertyKey)PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS, (Object)ufsAddress);
            UnderFileSystem nonLocalUfs = UnderFileSystem.Factory.createForRoot();
            UnderFileSystemUtils.mkdirIfNotExists((UnderFileSystem)nonLocalUfs, (String)ufsAddress);
        }
    }

    public void stop() throws Exception {
        this.stopFS();
        this.stopUFS();
        ConfigurationTestUtils.resetConfiguration();
        this.reset();
        LoginUserTestUtils.resetLoginUser();
    }

    public void stopFS() throws Exception {
        LOG.info("stop Alluxio filesystem");
        this.stopProxy();
        this.stopWorkers();
        this.stopMasters();
    }

    protected void stopUFS() throws Exception {
        LOG.info("stop under storage system");
        if (this.mUfsCluster != null) {
            this.mUfsCluster.cleanup();
        }
    }

    protected abstract void stopMasters() throws Exception;

    protected void stopProxy() throws Exception {
        this.mProxyProcess.stop();
        if (this.mProxyThread != null) {
            while (this.mProxyThread.isAlive()) {
                LOG.info("Stopping thread {}.", (Object)this.mProxyThread.getName());
                this.mProxyThread.interrupt();
                this.mProxyThread.join(1000L);
            }
            this.mProxyThread = null;
        }
    }

    public void stopWorkers() throws Exception {
        for (WorkerProcess worker : this.mWorkers) {
            worker.stop();
        }
        for (Thread thread : this.mWorkerThreads) {
            while (thread.isAlive()) {
                LOG.info("Stopping thread {}.", (Object)thread.getName());
                thread.interrupt();
                thread.join(1000L);
            }
        }
        this.mWorkerThreads.clear();
    }

    public void initConfiguration() throws IOException {
        this.setAlluxioWorkDirectory();
        this.setHostname();
        Configuration.set((PropertyKey)PropertyKey.TEST_MODE, (Object)true);
        Configuration.set((PropertyKey)PropertyKey.WORK_DIR, (Object)this.mWorkDirectory);
        Configuration.set((PropertyKey)PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT, (Object)1024);
        Configuration.set((PropertyKey)PropertyKey.USER_BLOCK_REMOTE_READ_BUFFER_SIZE_BYTES, (Object)64);
        Configuration.set((PropertyKey)PropertyKey.MASTER_HOSTNAME, (Object)this.mHostname);
        Configuration.set((PropertyKey)PropertyKey.MASTER_RPC_PORT, (Object)0);
        Configuration.set((PropertyKey)PropertyKey.MASTER_WEB_PORT, (Object)0);
        Configuration.set((PropertyKey)PropertyKey.MASTER_TTL_CHECKER_INTERVAL_MS, (Object)1000);
        Configuration.set((PropertyKey)PropertyKey.MASTER_WORKER_THREADS_MIN, (Object)1);
        Configuration.set((PropertyKey)PropertyKey.MASTER_WORKER_THREADS_MAX, (Object)100);
        Configuration.set((PropertyKey)PropertyKey.MASTER_STARTUP_CONSISTENCY_CHECK_ENABLED, (Object)false);
        Configuration.set((PropertyKey)PropertyKey.MASTER_JOURNAL_FLUSH_TIMEOUT_MS, (Object)1000);
        Configuration.set((PropertyKey)PropertyKey.MASTER_JOURNAL_TAILER_SHUTDOWN_QUIET_WAIT_TIME_MS, (Object)50);
        Configuration.set((PropertyKey)PropertyKey.MASTER_JOURNAL_TAILER_SLEEP_TIME_MS, (Object)10);
        Configuration.set((PropertyKey)PropertyKey.MASTER_BIND_HOST, (Object)this.mHostname);
        Configuration.set((PropertyKey)PropertyKey.MASTER_WEB_BIND_HOST, (Object)this.mHostname);
        Configuration.set((PropertyKey)PropertyKey.USER_RPC_RETRY_MAX_NUM_RETRY, (Object)3);
        Configuration.set((PropertyKey)PropertyKey.NETWORK_HOST_RESOLUTION_TIMEOUT_MS, (Object)250);
        Configuration.set((PropertyKey)PropertyKey.PROXY_WEB_PORT, (Object)0);
        Configuration.set((PropertyKey)PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT, (Object)"CACHE_THROUGH");
        Configuration.set((PropertyKey)PropertyKey.WEB_THREADS, (Object)1);
        Configuration.set((PropertyKey)PropertyKey.WEB_RESOURCES, (Object)PathUtils.concatPath((Object)System.getProperty("user.dir"), (Object[])new Object[]{"../core/server/common/src/main/webapp"}));
        Configuration.set((PropertyKey)PropertyKey.WORKER_RPC_PORT, (Object)0);
        Configuration.set((PropertyKey)PropertyKey.WORKER_DATA_PORT, (Object)0);
        Configuration.set((PropertyKey)PropertyKey.WORKER_WEB_PORT, (Object)0);
        Configuration.set((PropertyKey)PropertyKey.WORKER_DATA_FOLDER, (Object)"/datastore");
        Configuration.set((PropertyKey)PropertyKey.WORKER_MEMORY_SIZE, (Object)0x6400000L);
        Configuration.set((PropertyKey)PropertyKey.WORKER_BLOCK_HEARTBEAT_INTERVAL_MS, (Object)15);
        Configuration.set((PropertyKey)PropertyKey.WORKER_BLOCK_THREADS_MIN, (Object)1);
        Configuration.set((PropertyKey)PropertyKey.WORKER_BLOCK_THREADS_MAX, (Object)2048);
        Configuration.set((PropertyKey)PropertyKey.WORKER_NETWORK_NETTY_WORKER_THREADS, (Object)2);
        Configuration.set((PropertyKey)PropertyKey.WORKER_NETWORK_NETTY_SHUTDOWN_QUIET_PERIOD, (Object)0);
        Configuration.set((PropertyKey)PropertyKey.WORKER_NETWORK_NETTY_SHUTDOWN_TIMEOUT, (Object)0);
        Configuration.set((PropertyKey)PropertyKey.WORKER_BIND_HOST, (Object)this.mHostname);
        Configuration.set((PropertyKey)PropertyKey.WORKER_DATA_BIND_HOST, (Object)this.mHostname);
        Configuration.set((PropertyKey)PropertyKey.WORKER_WEB_BIND_HOST, (Object)this.mHostname);
        String ramdiskPath = PathUtils.concatPath((Object)this.mWorkDirectory, (Object[])new Object[]{"ramdisk"});
        Configuration.set((PropertyKey)PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_ALIAS.format(new Object[]{0}), (Object)"MEM");
        Configuration.set((PropertyKey)PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_DIRS_PATH.format(new Object[]{0}), (Object)ramdiskPath);
        int numLevel = Configuration.getInt((PropertyKey)PropertyKey.WORKER_TIERED_STORE_LEVELS);
        for (int level = 1; level < numLevel; ++level) {
            PropertyKey tierLevelDirPath = PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_DIRS_PATH.format(new Object[]{level});
            String[] dirPaths = Configuration.get((PropertyKey)tierLevelDirPath).split(",");
            ArrayList<String> newPaths = new ArrayList<String>();
            for (String dirPath : dirPaths) {
                String newPath = this.mWorkDirectory + dirPath;
                newPaths.add(newPath);
            }
            Configuration.set((PropertyKey)PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_DIRS_PATH.format(new Object[]{level}), (Object)Joiner.on((char)',').join(newPaths));
        }
        Configuration.merge((Map)System.getProperties());
    }

    public abstract FileSystem getClient() throws IOException;

    protected abstract LocalAlluxioMaster getLocalAlluxioMaster();

    public ProxyProcess getProxyProcess() {
        return this.mProxyProcess;
    }

    protected void reset() {
        ClientTestUtils.resetClient();
        GroupMappingServiceTestUtils.resetCache();
    }

    protected void resetClientPools() throws IOException {
        FileSystemContext.INSTANCE.reset();
    }

    protected void setHostname() {
        this.mHostname = NetworkAddressUtils.getLocalHostName((int)100);
    }

    protected void setAlluxioWorkDirectory() {
        this.mWorkDirectory = AlluxioTestDirectory.createTemporaryDirectory((String)"test-cluster").getAbsolutePath();
    }
}

