/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs;

import alluxio.underfs.LocalFileSystemCluster;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class UnderFileSystemCluster {
    private static final Logger LOG = LoggerFactory.getLogger(UnderFileSystemCluster.class);
    private static final String INTEGRATION_UFS_PROFILE_KEY = "ufs";
    private static String sUnderFSClass;
    private static UnderFileSystemCluster sUnderFSCluster;
    protected String mBaseDir;

    public static synchronized UnderFileSystemCluster get() {
        Preconditions.checkNotNull((Object)sUnderFSCluster, (Object)"sUnderFSCluster has not been initialized yet");
        return sUnderFSCluster;
    }

    public static synchronized UnderFileSystemCluster get(String baseDir) throws IOException {
        if (sUnderFSCluster == null) {
            sUnderFSCluster = UnderFileSystemCluster.getUnderFilesystemCluster(baseDir);
        }
        if (!sUnderFSCluster.isStarted()) {
            sUnderFSCluster.start();
            sUnderFSCluster.registerJVMOnExistHook();
        }
        return sUnderFSCluster;
    }

    public static UnderFileSystemCluster getUnderFilesystemCluster(String baseDir) {
        sUnderFSClass = System.getProperty(INTEGRATION_UFS_PROFILE_KEY);
        if (!StringUtils.isEmpty((CharSequence)sUnderFSClass)) {
            try {
                UnderFileSystemCluster ufsCluster = (UnderFileSystemCluster)Class.forName(sUnderFSClass).getConstructor(String.class).newInstance(baseDir);
                LOG.info("Initialized ufs cluster {} for integration testing.", (Object)sUnderFSClass);
                return ufsCluster;
            }
            catch (Exception e) {
                LOG.warn("Failed to initialize the ufs cluster {} for integration testing: {}", (Object)sUnderFSClass, (Object)e.getMessage());
                throw Throwables.propagate((Throwable)e);
            }
        }
        LOG.info("Using default {} for integration testing.", (Object)LocalFileSystemCluster.class.getName());
        return new LocalFileSystemCluster(baseDir);
    }

    public static synchronized String getUnderFSClass() {
        return sUnderFSClass;
    }

    public UnderFileSystemCluster(String baseDir) {
        this.mBaseDir = baseDir;
    }

    public abstract void cleanup() throws IOException;

    public abstract String getUnderFilesystemAddress();

    public abstract boolean isStarted();

    public void registerJVMOnExistHook() throws IOException {
        Runtime.getRuntime().addShutdownHook(new ShutdownHook(this));
    }

    public abstract void shutdown() throws IOException;

    public abstract void start() throws IOException;

    static {
        sUnderFSCluster = null;
    }

    class ShutdownHook
    extends Thread {
        UnderFileSystemCluster mUFSCluster = null;

        public ShutdownHook(UnderFileSystemCluster ufsCluster) {
            this.mUFSCluster = ufsCluster;
        }

        @Override
        public void run() {
            if (this.mUFSCluster != null) {
                try {
                    this.mUFSCluster.shutdown();
                }
                catch (IOException e) {
                    LOG.warn("Failed to shutdown underfs cluster: {}" + e.getMessage());
                }
            }
        }
    }
}

