/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.client.file.FileSystem;
import alluxio.master.AbstractLocalAlluxioCluster;
import alluxio.master.LocalAlluxioMaster;
import alluxio.wire.WorkerNetAddress;
import alluxio.worker.WorkerProcess;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class LocalAlluxioCluster
extends AbstractLocalAlluxioCluster {
    private static final Logger LOG = LoggerFactory.getLogger(LocalAlluxioCluster.class);
    private LocalAlluxioMaster mMaster;

    public LocalAlluxioCluster() {
        super(1);
    }

    public LocalAlluxioCluster(int numWorkers) {
        super(numWorkers);
    }

    @Override
    public FileSystem getClient() throws IOException {
        return this.mMaster.getClient();
    }

    @Override
    public LocalAlluxioMaster getLocalAlluxioMaster() {
        return this.mMaster;
    }

    public String getHostname() {
        return this.mHostname;
    }

    public String getMasterURI() {
        return this.mMaster.getUri();
    }

    public int getMasterRpcPort() {
        return this.mMaster.getRpcLocalPort();
    }

    public String getAlluxioHome() {
        return this.mWorkDirectory;
    }

    public WorkerProcess getWorkerProcess() {
        return (WorkerProcess)this.mWorkers.get(0);
    }

    public WorkerNetAddress getWorkerAddress() {
        return this.getWorkerProcess().getAddress();
    }

    @Override
    public void startMasters() throws Exception {
        this.mMaster = LocalAlluxioMaster.create(this.mWorkDirectory);
        this.mMaster.start();
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        System.clearProperty("fs.hdfs.impl.disable.cache");
    }

    @Override
    public void stopMasters() throws Exception {
        this.mMaster.stop();
    }
}

