/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.AlluxioTestDirectory;
import alluxio.Configuration;
import alluxio.PropertyKey;
import alluxio.client.file.FileSystem;
import alluxio.master.AbstractLocalAlluxioCluster;
import alluxio.master.LocalAlluxioMaster;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.options.DeleteOptions;
import alluxio.util.CommonUtils;
import alluxio.util.WaitForOptions;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.curator.test.TestingServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class MultiMasterLocalAlluxioCluster
extends AbstractLocalAlluxioCluster {
    private static final Logger LOG = LoggerFactory.getLogger(MultiMasterLocalAlluxioCluster.class);
    private TestingServer mCuratorServer = null;
    private int mNumOfMasters = 0;
    private final List<LocalAlluxioMaster> mMasters = new ArrayList<LocalAlluxioMaster>();

    public MultiMasterLocalAlluxioCluster(int numMasters) {
        this(numMasters, 1);
    }

    MultiMasterLocalAlluxioCluster(int numMasters, int numWorkers) {
        super(numWorkers);
        this.mNumOfMasters = numMasters;
        try {
            this.mCuratorServer = new TestingServer(-1, AlluxioTestDirectory.createTemporaryDirectory((String)"zk"));
            LOG.info("Started testing zookeeper: {}", (Object)this.mCuratorServer.getConnectString());
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public synchronized FileSystem getClient() throws IOException {
        return this.getLocalAlluxioMaster().getClient();
    }

    public String getUri() {
        return "alluxio-ft://" + this.mHostname + ":" + this.getLocalAlluxioMaster().getRpcLocalPort();
    }

    @Override
    public LocalAlluxioMaster getLocalAlluxioMaster() {
        for (LocalAlluxioMaster master : this.mMasters) {
            if (!master.isServing()) continue;
            return master;
        }
        return this.mMasters.get(0);
    }

    public int getLeaderIndex() {
        for (int i = 0; i < this.mNumOfMasters; ++i) {
            if (!this.mMasters.get(i).isServing()) continue;
            return i;
        }
        return -1;
    }

    public boolean stopStandby() {
        for (int k = 0; k < this.mNumOfMasters; ++k) {
            if (this.mMasters.get(k).isServing()) continue;
            try {
                LOG.info("master {} is a standby. stopping it...", (Object)k);
                this.mMasters.get(k).stop();
                LOG.info("master {} stopped.", (Object)k);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean stopLeader() {
        for (int k = 0; k < this.mNumOfMasters; ++k) {
            if (!this.mMasters.get(k).isServing()) continue;
            try {
                LOG.info("master {} is the leader. stopping it...", (Object)k);
                this.mMasters.get(k).stop();
                LOG.info("master {} stopped.", (Object)k);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                return false;
            }
            return true;
        }
        return false;
    }

    public void waitForNewMaster(int timeoutMs) {
        CommonUtils.waitFor((String)"the new leader master to start", (Function)new Function<Void, Boolean>(){

            public Boolean apply(Void input) {
                return MultiMasterLocalAlluxioCluster.this.getLeaderIndex() != -1;
            }
        }, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(timeoutMs));
    }

    @Override
    protected void startMasters() throws IOException {
        String path;
        Configuration.set((PropertyKey)PropertyKey.ZOOKEEPER_ENABLED, (Object)"true");
        Configuration.set((PropertyKey)PropertyKey.ZOOKEEPER_ADDRESS, (Object)this.mCuratorServer.getConnectString());
        Configuration.set((PropertyKey)PropertyKey.ZOOKEEPER_ELECTION_PATH, (Object)"/election");
        Configuration.set((PropertyKey)PropertyKey.ZOOKEEPER_LEADER_PATH, (Object)"/leader");
        for (int k = 0; k < this.mNumOfMasters; ++k) {
            LocalAlluxioMaster master = LocalAlluxioMaster.create(this.mWorkDirectory);
            master.start();
            LOG.info("master NO.{} started, isServing: {}, address: {}", new Object[]{k, master.isServing(), master.getAddress()});
            this.mMasters.add(master);
            Configuration.set((PropertyKey)PropertyKey.MASTER_RPC_PORT, (Object)"0");
        }
        UnderFileSystem ufs = UnderFileSystem.Factory.createForRoot();
        if (ufs.isDirectory(path = Configuration.get((PropertyKey)PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS))) {
            ufs.deleteDirectory(path, DeleteOptions.defaults().setRecursive(true));
        }
        if (!ufs.mkdirs(path)) {
            throw new IOException("Failed to make folder: " + path);
        }
        LOG.info("all {} masters started.", (Object)this.mNumOfMasters);
        LOG.info("waiting for a leader.");
        boolean hasLeader = false;
        block1: while (!hasLeader) {
            for (int i = 0; i < this.mMasters.size(); ++i) {
                if (!this.mMasters.get(i).isServing()) continue;
                LOG.info("master NO.{} is selected as leader. address: {}", (Object)i, (Object)this.mMasters.get(i).getAddress());
                hasLeader = true;
                continue block1;
            }
        }
        Configuration.set((PropertyKey)PropertyKey.MASTER_RPC_PORT, (Object)String.valueOf(this.getLocalAlluxioMaster().getRpcLocalPort()));
    }

    @Override
    public void startWorkers() throws Exception {
        Configuration.set((PropertyKey)PropertyKey.WORKER_BLOCK_THREADS_MAX, (Object)"100");
        super.startWorkers();
    }

    @Override
    public void stopFS() throws Exception {
        super.stopFS();
        LOG.info("Stopping testing zookeeper: {}", (Object)this.mCuratorServer.getConnectString());
        this.mCuratorServer.close();
    }

    @Override
    public void stopMasters() throws Exception {
        for (int k = 0; k < this.mNumOfMasters; ++k) {
            this.mMasters.get(k).stop();
        }
    }
}

