/*
 * Decompiled with CFR 0.152.
 */
package alluxio.multi.process;

import alluxio.PropertyKey;
import alluxio.multi.process.ExternalProcess;
import alluxio.multi.process.LimitedLifeWorkerProcess;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class Worker
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(Worker.class);
    private final File mLogsDir;
    private final Map<PropertyKey, String> mProperties;
    private ExternalProcess mProcess;

    public Worker(File logsDir, Map<PropertyKey, String> properties) throws IOException {
        this.mLogsDir = logsDir;
        this.mProperties = properties;
    }

    public synchronized void start() throws IOException {
        Preconditions.checkState((this.mProcess == null ? 1 : 0) != 0, (Object)"Worker is already running");
        this.mProcess = new ExternalProcess(this.mProperties, LimitedLifeWorkerProcess.class, new File(this.mLogsDir, "worker.out"));
        this.mProcess.start();
    }

    @Override
    public synchronized void close() {
        if (this.mProcess != null) {
            this.mProcess.stop();
            this.mProcess = null;
        }
    }
}

