/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.AlluxioTestDirectory;
import alluxio.Configuration;
import alluxio.ConfigurationTestUtils;
import alluxio.Process;
import alluxio.PropertyKey;
import alluxio.cli.Format;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.util.ClientTestUtils;
import alluxio.master.LocalAlluxioMaster;
import alluxio.master.TestUtils;
import alluxio.proxy.ProxyProcess;
import alluxio.security.GroupMappingServiceTestUtils;
import alluxio.security.LoginUserTestUtils;
import alluxio.underfs.UnderFileSystem;
import alluxio.util.UnderFileSystemUtils;
import alluxio.util.io.FileUtils;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.worker.WorkerProcess;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class AbstractLocalAlluxioCluster {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLocalAlluxioCluster.class);
    private static final Random RANDOM_GENERATOR = new Random();
    protected ProxyProcess mProxyProcess = ProxyProcess.Factory.create();
    protected Thread mProxyThread;
    protected List<WorkerProcess> mWorkers;
    protected List<Thread> mWorkerThreads;
    protected String mWorkDirectory;
    protected String mHostname;
    private int mNumWorkers;

    AbstractLocalAlluxioCluster(int numWorkers) {
        this.mNumWorkers = numWorkers;
        this.mWorkerThreads = new ArrayList<Thread>();
    }

    public void start() throws Exception {
        System.setProperty("fs.hdfs.impl.disable.cache", "true");
        this.resetClientPools();
        this.setupTest();
        this.startMasters();
        FileSystemContext.get().reset(Configuration.global());
        this.startWorkers();
        this.startProxy();
        this.reset();
    }

    protected abstract void startMasters() throws Exception;

    public void restartMasters() throws Exception {
        this.stopMasters();
        this.startMasters();
    }

    private void startProxy() throws Exception {
        this.mProxyProcess = ProxyProcess.Factory.create();
        Runnable runProxy = new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractLocalAlluxioCluster.this.mProxyProcess.start();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception e) {
                    LOG.error("Start proxy error", (Throwable)e);
                    throw new RuntimeException(e + " \n Start Proxy Error \n" + e.getMessage(), e);
                }
            }
        };
        this.mProxyThread = new Thread(runProxy);
        this.mProxyThread.setName("ProxyThread-" + System.identityHashCode(this.mProxyThread));
        this.mProxyThread.start();
        TestUtils.waitForReady((Process)this.mProxyProcess);
    }

    public void startWorkers() throws Exception {
        this.mWorkers = new ArrayList<WorkerProcess>();
        for (int i = 0; i < this.mNumWorkers; ++i) {
            this.mWorkers.add(WorkerProcess.Factory.create());
        }
        for (final WorkerProcess worker : this.mWorkers) {
            Runnable runWorker = new Runnable(){

                @Override
                public void run() {
                    try {
                        worker.start();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Exception e) {
                        LOG.error("Start worker error", (Throwable)e);
                        throw new RuntimeException(e + " \n Start Worker Error \n" + e.getMessage(), e);
                    }
                }
            };
            Thread thread = new Thread(runWorker);
            thread.setName("WorkerThread-" + System.identityHashCode(thread));
            this.mWorkerThreads.add(thread);
            thread.start();
        }
        for (final WorkerProcess worker : this.mWorkers) {
            TestUtils.waitForReady((Process)worker);
        }
    }

    protected void setupTest() throws IOException {
        UnderFileSystem ufs = UnderFileSystem.Factory.createForRoot();
        String underfsAddress = Configuration.get((PropertyKey)PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS);
        UnderFileSystemUtils.deleteDirIfExists((UnderFileSystem)ufs, (String)underfsAddress);
        UnderFileSystemUtils.mkdirIfNotExists((UnderFileSystem)ufs, (String)underfsAddress);
        int numLevel = Configuration.getInt((PropertyKey)PropertyKey.WORKER_TIERED_STORE_LEVELS);
        for (int level = 0; level < numLevel; ++level) {
            String[] dirPaths;
            PropertyKey tierLevelDirPath = PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_DIRS_PATH.format(new Object[]{level});
            for (String dirPath : dirPaths = Configuration.get((PropertyKey)tierLevelDirPath).split(",")) {
                FileUtils.createDir((String)dirPath);
            }
        }
        Format.format((Format.Mode)Format.Mode.MASTER);
    }

    public void stop() throws Exception {
        this.stopFS();
        this.reset();
        LoginUserTestUtils.resetLoginUser();
        ConfigurationTestUtils.resetConfiguration();
    }

    public void stopFS() throws Exception {
        LOG.info("stop Alluxio filesystem");
        this.stopProxy();
        this.stopWorkers();
        this.stopMasters();
    }

    protected abstract void stopMasters() throws Exception;

    protected void stopProxy() throws Exception {
        this.mProxyProcess.stop();
        if (this.mProxyThread != null) {
            while (this.mProxyThread.isAlive()) {
                LOG.info("Stopping thread {}.", (Object)this.mProxyThread.getName());
                this.mProxyThread.interrupt();
                this.mProxyThread.join(1000L);
            }
            this.mProxyThread = null;
        }
    }

    public void stopWorkers() throws Exception {
        for (WorkerProcess worker : this.mWorkers) {
            worker.stop();
        }
        for (Thread thread : this.mWorkerThreads) {
            while (thread.isAlive()) {
                LOG.info("Stopping thread {}.", (Object)thread.getName());
                thread.interrupt();
                thread.join(1000L);
            }
        }
        this.mWorkerThreads.clear();
    }

    public void initConfiguration() throws IOException {
        this.setAlluxioWorkDirectory();
        this.setHostname();
        for (Map.Entry entry : ConfigurationTestUtils.testConfigurationDefaults((String)this.mHostname, (String)this.mWorkDirectory).entrySet()) {
            Configuration.set((PropertyKey)((PropertyKey)entry.getKey()), entry.getValue());
        }
        Configuration.set((PropertyKey)PropertyKey.TEST_MODE, (Object)true);
        Configuration.set((PropertyKey)PropertyKey.MASTER_RPC_PORT, (Object)0);
        Configuration.set((PropertyKey)PropertyKey.MASTER_WEB_PORT, (Object)0);
        Configuration.set((PropertyKey)PropertyKey.PROXY_WEB_PORT, (Object)0);
        Configuration.set((PropertyKey)PropertyKey.WORKER_RPC_PORT, (Object)0);
        Configuration.set((PropertyKey)PropertyKey.WORKER_DATA_PORT, (Object)0);
        Configuration.set((PropertyKey)PropertyKey.WORKER_WEB_PORT, (Object)0);
    }

    public abstract FileSystem getClient() throws IOException;

    public abstract FileSystem getClient(FileSystemContext var1) throws IOException;

    protected abstract LocalAlluxioMaster getLocalAlluxioMaster();

    public ProxyProcess getProxyProcess() {
        return this.mProxyProcess;
    }

    protected void reset() {
        ClientTestUtils.resetClient();
        GroupMappingServiceTestUtils.resetCache();
    }

    protected void resetClientPools() throws IOException {
        Configuration.set((PropertyKey)PropertyKey.USER_METRICS_COLLECTION_ENABLED, (Object)false);
        FileSystemContext.get().reset(Configuration.global());
    }

    protected void setHostname() {
        this.mHostname = NetworkAddressUtils.getLocalHostName((int)100);
    }

    protected void setAlluxioWorkDirectory() {
        this.mWorkDirectory = AlluxioTestDirectory.createTemporaryDirectory((String)"test-cluster").getAbsolutePath();
    }
}

