/*
 * Decompiled with CFR 0.152.
 */
package alluxio.multi.process;

import alluxio.PropertyKey;
import alluxio.multi.process.ExternalProcess;
import alluxio.multi.process.LimitedLifeMasterProcess;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class Master
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(Master.class);
    private final File mLogsDir;
    private final Map<PropertyKey, String> mProperties;
    private ExternalProcess mProcess;

    public Master(File logsDir, Map<PropertyKey, String> properties) throws IOException {
        this.mLogsDir = logsDir;
        this.mProperties = properties;
    }

    public void updateConf(PropertyKey key, @Nullable String value) {
        if (value == null) {
            this.mProperties.remove(key);
        } else {
            this.mProperties.put(key, value);
        }
    }

    public synchronized void start() {
        Preconditions.checkState((this.mProcess == null ? 1 : 0) != 0, (Object)"Master is already running");
        LOG.info("Starting master with port {}", (Object)this.mProperties.get(PropertyKey.MASTER_RPC_PORT));
        this.mProcess = new ExternalProcess(this.mProperties, LimitedLifeMasterProcess.class, new File(this.mLogsDir, "master.out"));
        try {
            this.mProcess.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<PropertyKey, String> getConf() {
        return ImmutableMap.copyOf(this.mProperties);
    }

    @Override
    public synchronized void close() {
        if (this.mProcess != null) {
            this.mProcess.stop();
            this.mProcess = null;
        }
    }
}

