/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.AlluxioTestDirectory;
import alluxio.ConfigurationTestUtils;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.ServerConfiguration;
import alluxio.master.AbstractLocalAlluxioCluster;
import alluxio.master.LocalAlluxioMaster;
import alluxio.master.journal.JournalType;
import alluxio.master.metastore.MetastoreType;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.options.DeleteOptions;
import alluxio.util.CommonUtils;
import alluxio.util.WaitForOptions;
import alluxio.zookeeper.RestartableTestingServer;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class MultiMasterLocalAlluxioCluster
extends AbstractLocalAlluxioCluster {
    private static final Logger LOG = LoggerFactory.getLogger(MultiMasterLocalAlluxioCluster.class);
    private RestartableTestingServer mCuratorServer = null;
    private int mNumOfMasters = 0;
    private final List<LocalAlluxioMaster> mMasters = new ArrayList<LocalAlluxioMaster>();

    public MultiMasterLocalAlluxioCluster(int numMasters) {
        this(numMasters, 1);
    }

    public MultiMasterLocalAlluxioCluster(int numMasters, int numWorkers) {
        super(numWorkers);
        this.mNumOfMasters = numMasters;
        try {
            this.mCuratorServer = new RestartableTestingServer(-1, AlluxioTestDirectory.createTemporaryDirectory((String)"zk"));
            LOG.info("Started testing zookeeper: {}", (Object)this.mCuratorServer.getConnectString());
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void initConfiguration() throws IOException {
        this.setAlluxioWorkDirectory();
        this.setHostname();
        for (Map.Entry entry : ConfigurationTestUtils.testConfigurationDefaults((AlluxioConfiguration)ServerConfiguration.global(), (String)this.mHostname, (String)this.mWorkDirectory).entrySet()) {
            ServerConfiguration.set((PropertyKey)((PropertyKey)entry.getKey()), entry.getValue());
        }
        ServerConfiguration.set((PropertyKey)PropertyKey.MASTER_RPC_PORT, (Object)0);
        ServerConfiguration.set((PropertyKey)PropertyKey.TEST_MODE, (Object)true);
        ServerConfiguration.set((PropertyKey)PropertyKey.MASTER_METASTORE, (Object)MetastoreType.HEAP);
        ServerConfiguration.set((PropertyKey)PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.UFS);
        ServerConfiguration.set((PropertyKey)PropertyKey.MASTER_WEB_PORT, (Object)0);
        ServerConfiguration.set((PropertyKey)PropertyKey.PROXY_WEB_PORT, (Object)0);
        ServerConfiguration.set((PropertyKey)PropertyKey.WORKER_RPC_PORT, (Object)0);
        ServerConfiguration.set((PropertyKey)PropertyKey.WORKER_WEB_PORT, (Object)0);
    }

    @Override
    public synchronized FileSystem getClient() throws IOException {
        return this.getLocalAlluxioMaster().getClient();
    }

    @Override
    public FileSystem getClient(FileSystemContext context) throws IOException {
        return this.getLocalAlluxioMaster().getClient(context);
    }

    public String getUri() {
        return "alluxio-ft://" + this.mHostname + ":" + this.getLocalAlluxioMaster().getRpcLocalPort();
    }

    @Override
    public LocalAlluxioMaster getLocalAlluxioMaster() {
        for (LocalAlluxioMaster master : this.mMasters) {
            if (!master.isServing()) continue;
            return master;
        }
        return this.mMasters.get(0);
    }

    public int getLeaderIndex() {
        for (int i = 0; i < this.mNumOfMasters; ++i) {
            if (!this.mMasters.get(i).isServing()) continue;
            return i;
        }
        return -1;
    }

    public List<InetSocketAddress> getMasterAddresses() {
        ArrayList<InetSocketAddress> addrs = new ArrayList<InetSocketAddress>();
        for (int i = 0; i < this.mNumOfMasters; ++i) {
            addrs.add(this.mMasters.get(i).getAddress());
        }
        return addrs;
    }

    public boolean stopStandby() {
        for (int k = 0; k < this.mNumOfMasters; ++k) {
            if (this.mMasters.get(k).isServing()) continue;
            try {
                LOG.info("master {} is a standby. stopping it...", (Object)k);
                this.mMasters.get(k).stop();
                LOG.info("master {} stopped.", (Object)k);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean stopLeader() {
        for (int k = 0; k < this.mNumOfMasters; ++k) {
            if (!this.mMasters.get(k).isServing()) continue;
            try {
                LOG.info("master {} is the leader. stopping it...", (Object)k);
                this.mMasters.get(k).stop();
                LOG.info("master {} stopped.", (Object)k);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                return false;
            }
            return true;
        }
        return false;
    }

    public void waitForNewMaster(int timeoutMs) throws TimeoutException, InterruptedException {
        CommonUtils.waitFor((String)"the new leader master to start", () -> this.getLeaderIndex() != -1, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(timeoutMs));
    }

    public void stopZk() throws Exception {
        this.mCuratorServer.stop();
    }

    public void restartZk() throws Exception {
        this.mCuratorServer.restart();
    }

    @Override
    protected void startMasters() throws IOException {
        String path;
        ServerConfiguration.set((PropertyKey)PropertyKey.ZOOKEEPER_ENABLED, (Object)"true");
        ServerConfiguration.set((PropertyKey)PropertyKey.ZOOKEEPER_ADDRESS, (Object)this.mCuratorServer.getConnectString());
        ServerConfiguration.set((PropertyKey)PropertyKey.ZOOKEEPER_ELECTION_PATH, (Object)"/election");
        ServerConfiguration.set((PropertyKey)PropertyKey.ZOOKEEPER_LEADER_PATH, (Object)"/leader");
        for (int k = 0; k < this.mNumOfMasters; ++k) {
            LocalAlluxioMaster master = LocalAlluxioMaster.create(this.mWorkDirectory);
            master.start();
            LOG.info("master NO.{} started, isServing: {}, address: {}", new Object[]{k, master.isServing(), master.getAddress()});
            this.mMasters.add(master);
            ServerConfiguration.set((PropertyKey)PropertyKey.MASTER_RPC_PORT, (Object)"0");
            ServerConfiguration.set((PropertyKey)PropertyKey.MASTER_WEB_PORT, (Object)"0");
        }
        UnderFileSystem ufs = UnderFileSystem.Factory.createForRoot((AlluxioConfiguration)ServerConfiguration.global());
        if (ufs.isDirectory(path = ServerConfiguration.get((PropertyKey)PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS))) {
            ufs.deleteDirectory(path, DeleteOptions.defaults().setRecursive(true));
        }
        if (!ufs.mkdirs(path)) {
            throw new IOException("Failed to make folder: " + path);
        }
        LOG.info("all {} masters started.", (Object)this.mNumOfMasters);
        LOG.info("waiting for a leader.");
        boolean hasLeader = false;
        block1: while (!hasLeader) {
            for (int i = 0; i < this.mMasters.size(); ++i) {
                if (!this.mMasters.get(i).isServing()) continue;
                LOG.info("master NO.{} is selected as leader. address: {}", (Object)i, (Object)this.mMasters.get(i).getAddress());
                hasLeader = true;
                continue block1;
            }
        }
        ServerConfiguration.set((PropertyKey)PropertyKey.MASTER_RPC_PORT, (Object)String.valueOf(this.getLocalAlluxioMaster().getRpcLocalPort()));
    }

    @Override
    public void startWorkers() throws Exception {
        ServerConfiguration.set((PropertyKey)PropertyKey.WORKER_BLOCK_THREADS_MAX, (Object)"100");
        super.startWorkers();
    }

    @Override
    public void stopFS() throws Exception {
        super.stopFS();
        LOG.info("Stopping testing zookeeper: {}", (Object)this.mCuratorServer.getConnectString());
        this.mCuratorServer.close();
    }

    @Override
    public void stopMasters() throws Exception {
        for (int k = 0; k < this.mNumOfMasters; ++k) {
            this.mMasters.get(k).stop();
        }
    }
}

