/*
 * Decompiled with CFR 0.152.
 */
package alluxio.multi.process;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class PortCoordination {
    private static final AtomicInteger NEXT_PORT = new AtomicInteger(11000);
    private static final Set<Integer> SKIP_PORTS = new HashSet<Object>(Arrays.asList(new Object[0]));
    public static final List<ReservedPort> EMBEDDED_JOURNAL_FAILOVER = PortCoordination.allocate(3, 0);
    public static final List<ReservedPort> EMBEDDED_JOURNAL_RESTART = PortCoordination.allocate(3, 0);
    public static final List<ReservedPort> EMBEDDED_JOURNAL_RESTART_STRESS = PortCoordination.allocate(3, 0);
    public static final List<ReservedPort> JOURNAL_MIGRATION = PortCoordination.allocate(3, 1);
    public static final List<ReservedPort> BACKUP_RESTORE_EMBEDDED = PortCoordination.allocate(3, 1);
    public static final List<ReservedPort> CONFIG_CHECKER_MULTI_WORKERS = PortCoordination.allocate(1, 2);
    public static final List<ReservedPort> CONFIG_CHECKER_MULTI_NODES = PortCoordination.allocate(2, 2);
    public static final List<ReservedPort> CONFIG_CHECKER_UNSET_VS_SET = PortCoordination.allocate(2, 0);
    public static final List<ReservedPort> CONFIG_CHECKER_MULTI_MASTERS = PortCoordination.allocate(2, 0);
    public static final List<ReservedPort> MULTI_PROCESS_SIMPLE_CLUSTER = PortCoordination.allocate(1, 1);
    public static final List<ReservedPort> MULTI_PROCESS_ZOOKEEPER = PortCoordination.allocate(3, 2);
    public static final List<ReservedPort> JOURNAL_STOP_SINGLE_MASTER = PortCoordination.allocate(1, 0);
    public static final List<ReservedPort> JOURNAL_STOP_MULTI_MASTER = PortCoordination.allocate(3, 0);
    public static final List<ReservedPort> BACKUP_RESTORE_ZK = PortCoordination.allocate(3, 1);
    public static final List<ReservedPort> BACKUP_RESTORE_SINGLE = PortCoordination.allocate(1, 1);
    public static final List<ReservedPort> ZOOKEEPER_FAILURE = PortCoordination.allocate(1, 1);
    public static final List<ReservedPort> BACKWARDS_COMPATIBILITY = PortCoordination.allocate(1, 1);

    private static synchronized List<ReservedPort> allocate(int numMasters, int numWorkers) {
        int needed = numMasters * 3 + numWorkers * 3;
        ImmutableList.Builder ports = ImmutableList.builder();
        for (int i = 0; i < needed; ++i) {
            int port = NEXT_PORT.getAndIncrement();
            while (SKIP_PORTS.contains(port)) {
                port = NEXT_PORT.getAndIncrement();
            }
            ports.add((Object)new ReservedPort(port));
        }
        return ports.build();
    }

    public static class ReservedPort {
        private final int mPort;

        private ReservedPort(int port) {
            this.mPort = port;
        }

        public int getPort() {
            return this.mPort;
        }
    }
}

