/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.ConfigurationTestUtils;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.ServerConfiguration;
import alluxio.master.AbstractLocalAlluxioCluster;
import alluxio.master.LocalAlluxioMaster;
import alluxio.master.TestUtils;
import alluxio.wire.WorkerNetAddress;
import alluxio.worker.WorkerProcess;
import java.io.IOException;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class LocalAlluxioCluster
extends AbstractLocalAlluxioCluster {
    public static final String DEFAULT_TEST_NAME = "test";
    private static final Logger LOG = LoggerFactory.getLogger(LocalAlluxioCluster.class);
    private LocalAlluxioMaster mMaster;

    public LocalAlluxioCluster() {
        this(1);
    }

    public LocalAlluxioCluster(int numWorkers) {
        super(numWorkers);
    }

    @Override
    public FileSystem getClient() throws IOException {
        return this.mMaster.getClient();
    }

    @Override
    public FileSystem getClient(FileSystemContext context) throws IOException {
        return this.mMaster.getClient(context);
    }

    @Override
    public LocalAlluxioMaster getLocalAlluxioMaster() {
        return this.mMaster;
    }

    public String getHostname() {
        return this.mHostname;
    }

    public String getMasterURI() {
        return this.mMaster.getUri();
    }

    public int getMasterRpcPort() {
        return this.mMaster.getRpcLocalPort();
    }

    public String getAlluxioHome() {
        return this.mWorkDirectory;
    }

    public WorkerProcess getWorkerProcess() {
        return (WorkerProcess)this.mWorkers.get(0);
    }

    public WorkerNetAddress getWorkerAddress() {
        return this.getWorkerProcess().getAddress();
    }

    @Override
    public void initConfiguration(String name) throws IOException {
        this.setAlluxioWorkDirectory(name);
        this.setHostname();
        for (Map.Entry entry : ConfigurationTestUtils.testConfigurationDefaults((AlluxioConfiguration)ServerConfiguration.global(), (String)this.mHostname, (String)this.mWorkDirectory).entrySet()) {
            ServerConfiguration.set((PropertyKey)((PropertyKey)entry.getKey()), entry.getValue());
        }
        ServerConfiguration.set((PropertyKey)PropertyKey.TEST_MODE, (Object)true);
        ServerConfiguration.set((PropertyKey)PropertyKey.JOB_WORKER_THROTTLING, (Object)false);
        ServerConfiguration.set((PropertyKey)PropertyKey.PROXY_WEB_PORT, (Object)0);
        ServerConfiguration.set((PropertyKey)PropertyKey.WORKER_RPC_PORT, (Object)0);
        ServerConfiguration.set((PropertyKey)PropertyKey.WORKER_WEB_PORT, (Object)0);
    }

    @Override
    public void startMasters() throws Exception {
        this.mMaster = LocalAlluxioMaster.create(this.mWorkDirectory, true);
        this.mMaster.start();
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        TestUtils.assertAllLocksReleased(this);
        System.clearProperty("fs.hdfs.impl.disable.cache");
    }

    @Override
    public void stopMasters() throws Exception {
        this.mMaster.stop();
    }
}

