/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.Process;
import alluxio.conf.PropertyKey;
import alluxio.conf.ServerConfiguration;
import alluxio.exception.ConnectionFailedException;
import alluxio.master.AlluxioJobMasterProcess;
import alluxio.master.TestUtils;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.worker.JobWorkerProcess;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class LocalAlluxioJobCluster {
    private static final Logger LOG = LoggerFactory.getLogger(LocalAlluxioJobCluster.class);
    private AlluxioJobMasterProcess mMaster;
    private JobWorkerProcess mWorker;
    private Map<PropertyKey, String> mConfiguration = new HashMap<PropertyKey, String>();
    private String mHostname;
    private Thread mMasterThread;
    private Thread mWorkerThread;
    private boolean mIsRunning = false;

    public void start() throws IOException, ConnectionFailedException {
        LOG.info("Start Alluxio job service");
        this.setupTest();
        this.updateTestConf();
        this.startMaster();
        TestUtils.waitForReady((Process)this.mMaster);
        this.startWorker();
        TestUtils.waitForReady((Process)this.mWorker);
        this.mIsRunning = true;
    }

    public void stop() throws Exception {
        if (this.mIsRunning) {
            LOG.info("Stop Alluxio job service");
            this.mWorker.stop();
            this.mMaster.stop();
            this.mIsRunning = false;
        }
    }

    public AlluxioJobMasterProcess getMaster() {
        return this.mMaster;
    }

    public JobWorkerProcess getWorker() {
        return this.mWorker;
    }

    public String getHostname() {
        return this.mHostname;
    }

    public void restartWorker() throws Exception {
        this.mWorker.stop();
        this.startWorker();
    }

    private void setupTest() throws IOException {
    }

    private void updateTestConf() throws IOException {
        this.setHostname();
        ServerConfiguration.set((PropertyKey)PropertyKey.JOB_MASTER_BIND_HOST, (Object)this.mHostname);
        ServerConfiguration.set((PropertyKey)PropertyKey.JOB_MASTER_HOSTNAME, (Object)this.mHostname);
        ServerConfiguration.set((PropertyKey)PropertyKey.JOB_MASTER_WEB_BIND_HOST, (Object)this.mHostname);
        ServerConfiguration.set((PropertyKey)PropertyKey.JOB_WORKER_BIND_HOST, (Object)this.mHostname);
        ServerConfiguration.set((PropertyKey)PropertyKey.JOB_WORKER_RPC_PORT, (Object)Integer.toString(0));
        ServerConfiguration.set((PropertyKey)PropertyKey.JOB_WORKER_WEB_PORT, (Object)Integer.toString(0));
        ServerConfiguration.set((PropertyKey)PropertyKey.JOB_WORKER_WEB_BIND_HOST, (Object)this.mHostname);
        for (Map.Entry<PropertyKey, String> e : this.mConfiguration.entrySet()) {
            ServerConfiguration.set((PropertyKey)e.getKey(), (Object)e.getValue());
        }
    }

    public void setProperty(PropertyKey pk, String value) {
        this.mConfiguration.put(pk, value);
    }

    private void startMaster() throws IOException, ConnectionFailedException {
        this.mMaster = AlluxioJobMasterProcess.Factory.create();
        ServerConfiguration.set((PropertyKey)PropertyKey.JOB_MASTER_RPC_PORT, (Object)String.valueOf(this.mMaster.getRpcAddress().getPort()));
        Runnable runMaster = new Runnable(){

            @Override
            public void run() {
                try {
                    LocalAlluxioJobCluster.this.mMaster.start();
                }
                catch (Exception e) {
                    throw new RuntimeException(e + " \n Start Master Error \n" + e.getMessage(), e);
                }
            }
        };
        this.mMasterThread = new Thread(runMaster);
        this.mMasterThread.start();
    }

    private void startWorker() throws IOException, ConnectionFailedException {
        this.mWorker = JobWorkerProcess.Factory.create();
        Runnable runWorker = new Runnable(){

            @Override
            public void run() {
                try {
                    LocalAlluxioJobCluster.this.mWorker.start();
                }
                catch (Exception e) {
                    throw new RuntimeException(e + " \n Start Worker Error \n" + e.getMessage(), e);
                }
            }
        };
        this.mWorkerThread = new Thread(runWorker);
        this.mWorkerThread.start();
    }

    private void setHostname() {
        this.mHostname = NetworkAddressUtils.getLocalHostName((int)((int)ServerConfiguration.getMs((PropertyKey)PropertyKey.NETWORK_HOST_RESOLUTION_TIMEOUT_MS)));
    }
}

