/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.ServerConfiguration;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ClientPool
implements Closeable {
    private final List<FileSystem> mClients = Collections.synchronizedList(new ArrayList());

    ClientPool(Supplier<String> uriSupplier) {
    }

    public FileSystem getClient() throws IOException {
        FileSystem fs = FileSystem.Factory.create((AlluxioConfiguration)ServerConfiguration.global());
        this.mClients.add(fs);
        return fs;
    }

    public FileSystem getClient(FileSystemContext context) throws IOException {
        FileSystem fs = FileSystem.Factory.create((FileSystemContext)context);
        this.mClients.add(fs);
        return fs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        List<FileSystem> list = this.mClients;
        synchronized (list) {
            this.mClients.forEach(client -> {
                try {
                    client.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            this.mClients.clear();
        }
    }
}

