/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.AlluxioURI;
import alluxio.ConfigurationTestUtils;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.NodeState;
import alluxio.master.AbstractLocalAlluxioCluster;
import alluxio.master.LocalAlluxioMaster;
import alluxio.master.journal.JournalType;
import alluxio.multi.process.MasterNetAddress;
import alluxio.multi.process.PortCoordination;
import alluxio.util.CommonUtils;
import alluxio.util.WaitForOptions;
import alluxio.util.io.PathUtils;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.worker.WorkerProcess;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class MultiMasterEmbeddedJournalLocalAlluxioCluster
extends AbstractLocalAlluxioCluster {
    private static final Logger LOG = LoggerFactory.getLogger(MultiMasterEmbeddedJournalLocalAlluxioCluster.class);
    private int mNumOfMasters = 0;
    private final List<LocalAlluxioMaster> mMasters = new ArrayList<LocalAlluxioMaster>();
    private final List<PortCoordination.ReservedPort> mPorts;
    private final List<MasterNetAddress> mMasterAddresses;
    private final List<String> mJournalFolders = new ArrayList<String>();

    public MultiMasterEmbeddedJournalLocalAlluxioCluster(int numMasters, int numWorkers, List<PortCoordination.ReservedPort> reservedPorts) throws IOException {
        super(numWorkers);
        this.mNumOfMasters = numMasters;
        this.mPorts = new ArrayList<PortCoordination.ReservedPort>(reservedPorts);
        this.mMasterAddresses = this.generateMasterAddresses(numMasters);
    }

    private List<MasterNetAddress> generateMasterAddresses(int numMasters) throws IOException {
        int timeout = (int)Configuration.getMs((PropertyKey)PropertyKey.NETWORK_HOST_RESOLUTION_TIMEOUT_MS);
        ArrayList<MasterNetAddress> addrs = new ArrayList<MasterNetAddress>();
        for (int i = 0; i < numMasters; ++i) {
            addrs.add(new MasterNetAddress(NetworkAddressUtils.getLocalHostName((int)timeout), this.getNewPort(), this.getNewPort(), this.getNewPort()));
        }
        return addrs;
    }

    private int getNewPort() throws IOException {
        Preconditions.checkState((!this.mPorts.isEmpty() ? 1 : 0) != 0, (Object)"Out of ports to reserve");
        return this.mPorts.remove(this.mPorts.size() - 1).getPort();
    }

    @Override
    public void initConfiguration(String name) throws IOException {
        this.setAlluxioWorkDirectory(name);
        this.setHostname();
        for (Map.Entry entry : ConfigurationTestUtils.testConfigurationDefaults((AlluxioConfiguration)Configuration.global(), (String)this.mHostname, (String)this.mWorkDirectory).entrySet()) {
            Configuration.set((PropertyKey)((PropertyKey)entry.getKey()), entry.getValue());
        }
        Configuration.set((PropertyKey)PropertyKey.TEST_MODE, (Object)true);
        Configuration.set((PropertyKey)PropertyKey.JOB_WORKER_THROTTLING, (Object)false);
        Configuration.set((PropertyKey)PropertyKey.PROXY_WEB_PORT, (Object)0);
        Configuration.set((PropertyKey)PropertyKey.WORKER_RPC_PORT, (Object)0);
        Configuration.set((PropertyKey)PropertyKey.WORKER_WEB_PORT, (Object)0);
        ArrayList<String> journalAddresses = new ArrayList<String>();
        ArrayList<String> rpcAddresses = new ArrayList<String>();
        for (MasterNetAddress address : this.mMasterAddresses) {
            journalAddresses.add(String.format("%s:%d", address.getHostname(), address.getEmbeddedJournalPort()));
            rpcAddresses.add(String.format("%s:%d", address.getHostname(), address.getRpcPort()));
        }
        Configuration.set((PropertyKey)PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.EMBEDDED);
        Configuration.set((PropertyKey)PropertyKey.MASTER_EMBEDDED_JOURNAL_ADDRESSES, (Object)Joiner.on((String)",").join(journalAddresses));
        Configuration.set((PropertyKey)PropertyKey.MASTER_RPC_ADDRESSES, (Object)Joiner.on((String)",").join(rpcAddresses));
    }

    @Override
    public synchronized FileSystem getClient() throws IOException {
        return this.getLocalAlluxioMaster().getClient();
    }

    @Override
    public FileSystem getClient(FileSystemContext context) throws IOException {
        return this.getLocalAlluxioMaster().getClient(context);
    }

    @Override
    public LocalAlluxioMaster getLocalAlluxioMaster() {
        for (LocalAlluxioMaster master : this.mMasters) {
            if (!master.isServing() || master.getMasterProcess().mLeaderSelector.getState() != NodeState.PRIMARY) continue;
            return master;
        }
        return this.mMasters.get(0);
    }

    public LocalAlluxioMaster getLocalAlluxioMasterByIndex(int index) {
        return this.mMasters.get(index);
    }

    public WorkerProcess getWorkerProcess(int index) {
        return (WorkerProcess)this.mWorkers.get(index);
    }

    public int getLeaderIndex() {
        for (int i = 0; i < this.mNumOfMasters; ++i) {
            if (!this.mMasters.get(i).isServing() || this.mMasters.get((int)i).getMasterProcess().mLeaderSelector.getState() != NodeState.PRIMARY) continue;
            return i;
        }
        return -1;
    }

    public List<InetSocketAddress> getMasterAddresses() {
        ArrayList<InetSocketAddress> addrs = new ArrayList<InetSocketAddress>();
        for (int i = 0; i < this.mNumOfMasters; ++i) {
            addrs.add(this.mMasters.get(i).getAddress());
        }
        return addrs;
    }

    public boolean stopStandby() {
        for (int k = 0; k < this.mNumOfMasters; ++k) {
            if (this.mMasters.get(k).isServing()) continue;
            try {
                LOG.info("master {} is a standby. stopping it...", (Object)k);
                this.mMasters.get(k).stop();
                LOG.info("master {} stopped.", (Object)k);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean stopLeader() {
        int leaderId = this.getLeaderIndex();
        try {
            LOG.info("master {} is the leader. stopping it...", (Object)leaderId);
            this.getLocalAlluxioMasterByIndex(leaderId).stop();
            LOG.info("master {} stopped.", (Object)leaderId);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public void waitForPrimaryMasterServing(int timeoutMs) throws TimeoutException, InterruptedException {
        CommonUtils.waitFor((String)"the primary leader master to start", () -> {
            int leaderId = this.getLeaderIndex();
            if (leaderId == -1) {
                return false;
            }
            try {
                this.getLocalAlluxioMasterByIndex(leaderId).getClient().listStatus(new AlluxioURI("/"));
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(timeoutMs));
    }

    @Override
    protected void startMasters() throws IOException {
        for (int k = 0; k < this.mNumOfMasters; ++k) {
            Configuration.set((PropertyKey)PropertyKey.MASTER_METASTORE_DIR, (Object)PathUtils.concatPath((Object)this.mWorkDirectory, (Object)("metastore-" + k)));
            MasterNetAddress address = this.mMasterAddresses.get(k);
            Configuration.set((PropertyKey)PropertyKey.LOGGER_TYPE, (Object)"MASTER_LOGGER");
            Configuration.set((PropertyKey)PropertyKey.MASTER_HOSTNAME, (Object)address.getHostname());
            Configuration.set((PropertyKey)PropertyKey.MASTER_RPC_PORT, (Object)address.getRpcPort());
            Configuration.set((PropertyKey)PropertyKey.MASTER_WEB_PORT, (Object)address.getWebPort());
            Configuration.set((PropertyKey)PropertyKey.MASTER_EMBEDDED_JOURNAL_PORT, (Object)address.getEmbeddedJournalPort());
            Configuration.set((PropertyKey)PropertyKey.MASTER_JOURNAL_FOLDER, (Object)this.mJournalFolders.get(k));
            LocalAlluxioMaster master = LocalAlluxioMaster.create(this.mWorkDirectory, false);
            master.start();
            LOG.info("master NO.{} started, isServing: {}, address: {}", new Object[]{k, master.isServing(), master.getAddress()});
            this.mMasters.add(master);
        }
        LOG.info("all {} masters started.", (Object)this.mNumOfMasters);
        LOG.info("waiting for a leader.");
        try {
            this.waitForMasterServing();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        Configuration.set((PropertyKey)PropertyKey.MASTER_RPC_PORT, (Object)this.getLocalAlluxioMaster().getRpcLocalPort());
    }

    @Override
    public void startWorkers() throws Exception {
        super.startWorkers();
    }

    @Override
    public void stopFS() throws Exception {
        super.stopFS();
    }

    @Override
    public void stopMasters() throws Exception {
        for (int k = 0; k < this.mNumOfMasters; ++k) {
            this.mMasters.get(k).stop();
        }
    }

    @Override
    protected void formatJournal() {
        for (int i = 0; i < this.mNumOfMasters; ++i) {
            String extension = "-" + i;
            File journalDir = new File(this.mWorkDirectory, "journal" + extension);
            journalDir.mkdirs();
            this.mJournalFolders.add(journalDir.getAbsolutePath());
        }
    }
}

