/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.AlluxioTestDirectory;
import alluxio.ConfigurationTestUtils;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.master.AbstractLocalAlluxioCluster;
import alluxio.master.LocalAlluxioMaster;
import alluxio.master.journal.JournalType;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.options.DeleteOptions;
import alluxio.util.CommonUtils;
import alluxio.util.WaitForOptions;
import alluxio.util.io.PathUtils;
import alluxio.worker.WorkerProcess;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.curator.test.TestingServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class MultiMasterLocalAlluxioCluster
extends AbstractLocalAlluxioCluster {
    private static final Logger LOG = LoggerFactory.getLogger(MultiMasterLocalAlluxioCluster.class);
    private TestingServer mCuratorServer = null;
    private int mNumOfMasters = 0;
    private final List<LocalAlluxioMaster> mMasters = new ArrayList<LocalAlluxioMaster>();

    public MultiMasterLocalAlluxioCluster(int numMasters) {
        this(numMasters, 1);
    }

    public MultiMasterLocalAlluxioCluster(int numMasters, int numWorkers) {
        super(numWorkers);
        this.mNumOfMasters = numMasters;
        try {
            this.mCuratorServer = new TestingServer(-1, AlluxioTestDirectory.createTemporaryDirectory((String)"zk"));
            LOG.info("Started testing zookeeper: {}", (Object)this.mCuratorServer.getConnectString());
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void initConfiguration(String name) throws IOException {
        this.setAlluxioWorkDirectory(name);
        this.setHostname();
        for (Map.Entry entry : ConfigurationTestUtils.testConfigurationDefaults((AlluxioConfiguration)Configuration.global(), (String)this.mHostname, (String)this.mWorkDirectory).entrySet()) {
            Configuration.set((PropertyKey)((PropertyKey)entry.getKey()), entry.getValue());
        }
        Configuration.set((PropertyKey)PropertyKey.MASTER_RPC_PORT, (Object)0);
        Configuration.set((PropertyKey)PropertyKey.TEST_MODE, (Object)true);
        Configuration.set((PropertyKey)PropertyKey.JOB_WORKER_THROTTLING, (Object)false);
        Configuration.set((PropertyKey)PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.UFS);
        Configuration.set((PropertyKey)PropertyKey.MASTER_WEB_PORT, (Object)0);
        Configuration.set((PropertyKey)PropertyKey.PROXY_WEB_PORT, (Object)0);
        Configuration.set((PropertyKey)PropertyKey.WORKER_RPC_PORT, (Object)0);
        Configuration.set((PropertyKey)PropertyKey.WORKER_WEB_PORT, (Object)0);
    }

    @Override
    public synchronized FileSystem getClient() throws IOException {
        return this.getLocalAlluxioMaster().getClient();
    }

    @Override
    public FileSystem getClient(FileSystemContext context) throws IOException {
        return this.getLocalAlluxioMaster().getClient(context);
    }

    public String getUri() {
        return "alluxio://zk@" + this.mCuratorServer.getConnectString();
    }

    @Override
    public LocalAlluxioMaster getLocalAlluxioMaster() {
        for (LocalAlluxioMaster master : this.mMasters) {
            if (!master.isServing()) continue;
            return master;
        }
        return this.mMasters.get(0);
    }

    public WorkerProcess getWorkerProcess(int index) {
        return (WorkerProcess)this.mWorkers.get(index);
    }

    public int getLeaderIndex() {
        for (int i = 0; i < this.mNumOfMasters; ++i) {
            if (!this.mMasters.get(i).isServing()) continue;
            return i;
        }
        return -1;
    }

    public List<InetSocketAddress> getMasterAddresses() {
        ArrayList<InetSocketAddress> addrs = new ArrayList<InetSocketAddress>();
        for (int i = 0; i < this.mNumOfMasters; ++i) {
            addrs.add(this.mMasters.get(i).getAddress());
        }
        return addrs;
    }

    public boolean stopStandby() {
        for (int k = 0; k < this.mNumOfMasters; ++k) {
            if (this.mMasters.get(k).isServing()) continue;
            try {
                LOG.info("master {} is a standby. stopping it...", (Object)k);
                this.mMasters.get(k).stop();
                LOG.info("master {} stopped.", (Object)k);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean stopLeader() {
        for (int k = 0; k < this.mNumOfMasters; ++k) {
            if (!this.mMasters.get(k).isServing()) continue;
            try {
                LOG.info("master {} is the leader. stopping it...", (Object)k);
                this.mMasters.get(k).stop();
                LOG.info("master {} stopped.", (Object)k);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                return false;
            }
            return true;
        }
        return false;
    }

    public void waitForNewMaster(int timeoutMs) throws TimeoutException, InterruptedException {
        CommonUtils.waitFor((String)"the new leader master to start", () -> this.getLeaderIndex() != -1, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(timeoutMs));
    }

    public void stopZk() throws Exception {
        this.mCuratorServer.stop();
    }

    public void restartZk() throws Exception {
        this.mCuratorServer.restart();
    }

    @Override
    protected void startMasters() throws IOException {
        String path;
        Configuration.set((PropertyKey)PropertyKey.ZOOKEEPER_ENABLED, (Object)true);
        Configuration.set((PropertyKey)PropertyKey.ZOOKEEPER_ADDRESS, (Object)this.mCuratorServer.getConnectString());
        Configuration.set((PropertyKey)PropertyKey.ZOOKEEPER_ELECTION_PATH, (Object)"/alluxio/election");
        Configuration.set((PropertyKey)PropertyKey.ZOOKEEPER_LEADER_PATH, (Object)"/alluxio/leader");
        for (int k = 0; k < this.mNumOfMasters; ++k) {
            Configuration.set((PropertyKey)PropertyKey.MASTER_METASTORE_DIR, (Object)PathUtils.concatPath((Object)this.mWorkDirectory, (Object)("metastore-" + k)));
            LocalAlluxioMaster master = LocalAlluxioMaster.create(this.mWorkDirectory, false);
            master.start();
            LOG.info("master NO.{} started, isServing: {}, address: {}", new Object[]{k, master.isServing(), master.getAddress()});
            this.mMasters.add(master);
            Configuration.set((PropertyKey)PropertyKey.MASTER_RPC_PORT, (Object)0);
            Configuration.set((PropertyKey)PropertyKey.MASTER_WEB_PORT, (Object)0);
        }
        UnderFileSystem ufs = UnderFileSystem.Factory.createForRoot((AlluxioConfiguration)Configuration.global());
        if (ufs.isDirectory(path = Configuration.getString((PropertyKey)PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS))) {
            ufs.deleteExistingDirectory(path, DeleteOptions.defaults().setRecursive(true));
        }
        if (!ufs.mkdirs(path)) {
            throw new IOException("Failed to make folder: " + path);
        }
        LOG.info("all {} masters started.", (Object)this.mNumOfMasters);
        LOG.info("waiting for a leader.");
        try {
            this.waitForMasterServing();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        Configuration.set((PropertyKey)PropertyKey.MASTER_RPC_PORT, (Object)this.getLocalAlluxioMaster().getRpcLocalPort());
    }

    @Override
    public void startWorkers() throws Exception {
        super.startWorkers();
    }

    @Override
    public void stopFS() throws Exception {
        super.stopFS();
        LOG.info("Stopping testing zookeeper: {}", (Object)this.mCuratorServer.getConnectString());
        this.mCuratorServer.close();
    }

    @Override
    public void stopMasters() throws Exception {
        for (int k = 0; k < this.mNumOfMasters; ++k) {
            this.mMasters.get(k).stop();
        }
    }
}

