/*
 * Decompiled with CFR 0.152.
 */
package alluxio.multi.process;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortCoordination {
    private static final Logger LOG = LoggerFactory.getLogger(PortCoordination.class);
    private static final AtomicInteger NEXT_PORT = new AtomicInteger(11000);
    private static final Set<Integer> SKIP_PORTS = new HashSet<Object>(Arrays.asList(new Object[0]));
    public static final List<ReservedPort> EMBEDDED_JOURNAL_FAILOVER = PortCoordination.allocate(3, 0);
    public static final List<ReservedPort> EMBEDDED_JOURNAL_SNAPSHOT_MASTER = PortCoordination.allocate(3, 0);
    public static final List<ReservedPort> EMBEDDED_JOURNAL_SNAPSHOT_FOLLOWER = PortCoordination.allocate(3, 0);
    public static final List<ReservedPort> EMBEDDED_JOURNAL_SNAPSHOT_TRANSFER_LOAD = PortCoordination.allocate(3, 0);
    public static final List<ReservedPort> EMBEDDED_JOURNAL_SNAPSHOT_SINGLE_MASTER = PortCoordination.allocate(1, 0);
    public static final List<ReservedPort> EMBEDDED_JOURNAL_RESTART = PortCoordination.allocate(3, 0);
    public static final List<ReservedPort> EMBEDDED_JOURNAL_RESTART_STRESS = PortCoordination.allocate(3, 0);
    public static final List<ReservedPort> EMBEDDED_JOURNAL_RESIZE = PortCoordination.allocate(5, 0);
    public static final List<ReservedPort> EMBEDDED_JOURNAL_GROW = PortCoordination.allocate(3, 0);
    public static final List<ReservedPort> EMBEDDED_JOURNAL_REPLACE_ALL = PortCoordination.allocate(3, 0);
    public static final List<ReservedPort> EMBEDDED_JOURNAL_TRANSFER_LEADER = PortCoordination.allocate(5, 0);
    public static final List<ReservedPort> EMBEDDED_JOURNAL_REPEAT_TRANSFER_LEADER = PortCoordination.allocate(5, 0);
    public static final List<ReservedPort> EMBEDDED_JOURNAL_ALREADY_TRANSFERRING = PortCoordination.allocate(5, 0);
    public static final List<ReservedPort> EMBEDDED_JOURNAL_OUTSIDE_CLUSTER = PortCoordination.allocate(5, 0);
    public static final List<ReservedPort> EMBEDDED_JOURNAL_NEW_MEMBER = PortCoordination.allocate(6, 0);
    public static final List<ReservedPort> EMBEDDED_JOURNAL_UNAVAILABLE_MASTER = PortCoordination.allocate(5, 0);
    public static final List<ReservedPort> JOURNAL_MIGRATION = PortCoordination.allocate(3, 1);
    public static final List<ReservedPort> BACKUP_RESTORE_EMBEDDED = PortCoordination.allocate(3, 1);
    public static final List<ReservedPort> BACKUP_SYNC_ON_RESTORE = PortCoordination.allocate(1, 1);
    public static final List<ReservedPort> BACKUP_CONTENT_ON_RESTORE = PortCoordination.allocate(1, 1);
    public static final List<ReservedPort> CONFIG_CHECKER_MULTI_WORKERS = PortCoordination.allocate(1, 2);
    public static final List<ReservedPort> CONFIG_CHECKER_MULTI_NODES = PortCoordination.allocate(2, 2);
    public static final List<ReservedPort> CONFIG_CHECKER_UNSET_VS_SET = PortCoordination.allocate(2, 0);
    public static final List<ReservedPort> CONFIG_CHECKER_MULTI_MASTERS = PortCoordination.allocate(2, 0);
    public static final List<ReservedPort> CONFIG_CHECKER_MULTI_MASTERS_EMBEDDED_HA = PortCoordination.allocate(2, 0);
    public static final List<ReservedPort> MULTI_PROCESS_SIMPLE_CLUSTER = PortCoordination.allocate(1, 1);
    public static final List<ReservedPort> MULTI_PROCESS_ZOOKEEPER = PortCoordination.allocate(3, 2);
    public static final List<ReservedPort> JOURNAL_STOP_SINGLE_MASTER = PortCoordination.allocate(1, 0);
    public static final List<ReservedPort> JOURNAL_STOP_MULTI_MASTER = PortCoordination.allocate(3, 0);
    public static final List<ReservedPort> BACKUP_RESTORE_ZK = PortCoordination.allocate(3, 1);
    public static final List<ReservedPort> BACKUP_RESTORE_SINGLE = PortCoordination.allocate(1, 1);
    public static final List<ReservedPort> BACKUP_DELEGATION_PROTOCOL = PortCoordination.allocate(3, 1);
    public static final List<ReservedPort> BACKUP_DELEGATION_FAILOVER_PROTOCOL = PortCoordination.allocate(2, 1);
    public static final List<ReservedPort> BACKUP_DELEGATION_ZK = PortCoordination.allocate(2, 1);
    public static final List<ReservedPort> BACKUP_DELEGATION_EMBEDDED = PortCoordination.allocate(2, 1);
    public static final List<ReservedPort> BACKUP_RESTORE_METASSTORE_HEAP = PortCoordination.allocate(1, 1);
    public static final List<ReservedPort> BACKUP_RESTORE_METASSTORE_ROCKS = PortCoordination.allocate(1, 1);
    public static final List<ReservedPort> BACKUP_EMERGENCY_1 = PortCoordination.allocate(1, 0);
    public static final List<ReservedPort> BACKUP_EMERGENCY_2 = PortCoordination.allocate(1, 0);
    public static final List<ReservedPort> BACKUP_EMERGENCY_HA_1 = PortCoordination.allocate(3, 0);
    public static final List<ReservedPort> BACKUP_EMERGENCY_HA_2 = PortCoordination.allocate(3, 0);
    public static final List<ReservedPort> ZOOKEEPER_FAILURE = PortCoordination.allocate(2, 1);
    public static final List<ReservedPort> ZOOKEEPER_CONNECTION_POLICY_STANDARD = PortCoordination.allocate(2, 0);
    public static final List<ReservedPort> ZOOKEEPER_CONNECTION_POLICY_SESSION = PortCoordination.allocate(2, 0);
    public static final List<ReservedPort> CHECKPOINT = PortCoordination.allocate(2, 0);
    public static final List<ReservedPort> TRIGGERED_UFS_CHECKPOINT = PortCoordination.allocate(1, 1);
    public static final List<ReservedPort> TRIGGERED_EMBEDDED_CHECKPOINT = PortCoordination.allocate(1, 1);
    public static final List<ReservedPort> BACKWARDS_COMPATIBILITY = PortCoordination.allocate(1, 1);
    public static final List<ReservedPort> MULTI_MASTER_URI = PortCoordination.allocate(3, 1);
    public static final List<ReservedPort> ZOOKEEPER_URI = PortCoordination.allocate(3, 2);
    public static final List<ReservedPort> QUORUM_SHELL = PortCoordination.allocate(3, 0);
    public static final List<ReservedPort> QUORUM_SHELL_INFO = PortCoordination.allocate(3, 0);
    public static final List<ReservedPort> QUORUM_SHELL_REMOVE = PortCoordination.allocate(5, 0);
    public static final List<ReservedPort> WORKER_ALL_MASTER_REGISTRATION = PortCoordination.allocate(3, 1);

    private static synchronized List<ReservedPort> allocate(int numMasters, int numWorkers) {
        int needed = numMasters * 3 + numWorkers * 3;
        ImmutableList.Builder ports = ImmutableList.builder();
        for (int i = 0; i < needed; ++i) {
            int port = NEXT_PORT.getAndIncrement();
            while (SKIP_PORTS.contains(port) || !PortCoordination.isAvailable(port)) {
                port = NEXT_PORT.getAndIncrement();
            }
            ports.add((Object)new ReservedPort(port));
        }
        return ports.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isAvailable(int port) {
        try (Socket ignored = new Socket("localhost", port);){
            LOG.info("Port {} is unavailable", (Object)port);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            return true;
        }
    }

    public static class ReservedPort {
        private final int mPort;

        private ReservedPort(int port) {
            this.mPort = port;
        }

        public int getPort() {
            return this.mPort;
        }
    }
}

