/*
 * Decompiled with CFR 0.152.
 */
package alluxio.multi.process;

import alluxio.conf.PropertyKey;
import alluxio.multi.process.ExternalProcess;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class BaseMaster
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(BaseMaster.class);
    private final File mLogsDir;
    final Map<PropertyKey, Object> mProperties;
    private ExternalProcess mProcess;

    public BaseMaster(File logsDir, Map<PropertyKey, Object> properties) throws IOException {
        this.mLogsDir = logsDir;
        this.mProperties = properties;
    }

    public void updateConf(PropertyKey key, @Nullable Object value) {
        if (value == null) {
            this.mProperties.remove(key);
        } else {
            this.mProperties.put(key, value);
        }
    }

    abstract int getPort();

    abstract Class<?> getProcessClass();

    public synchronized void start() {
        Preconditions.checkState((this.mProcess == null ? 1 : 0) != 0, (Object)"Master is already running");
        LOG.info("Starting master type {} with port {}", this.getProcessClass(), (Object)this.getPort());
        this.mProcess = new ExternalProcess(this.mProperties, this.getProcessClass(), new File(this.mLogsDir, "master.out"));
        try {
            this.mProcess.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<PropertyKey, Object> getConf() {
        return ImmutableMap.copyOf(this.mProperties);
    }

    @Override
    public synchronized void close() {
        if (this.mProcess != null) {
            this.mProcess.stop();
            this.mProcess = null;
        }
    }
}

