/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.AlluxioTestDirectory;
import alluxio.AlluxioURI;
import alluxio.ClientContext;
import alluxio.Process;
import alluxio.cli.Format;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.meta.MetaMasterClient;
import alluxio.client.meta.RetryHandlingMetaMasterClient;
import alluxio.client.util.ClientTestUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.exception.status.UnavailableException;
import alluxio.master.LocalAlluxioMaster;
import alluxio.master.MasterClientContext;
import alluxio.master.TestUtils;
import alluxio.master.block.BlockMaster;
import alluxio.master.block.DefaultBlockMaster;
import alluxio.proxy.ProxyProcess;
import alluxio.security.GroupMappingServiceTestUtils;
import alluxio.underfs.UnderFileSystem;
import alluxio.util.CommonUtils;
import alluxio.util.UnderFileSystemUtils;
import alluxio.util.WaitForOptions;
import alluxio.util.io.FileUtils;
import alluxio.util.io.PathUtils;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.wire.WorkerNetAddress;
import alluxio.worker.WorkerProcess;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class AbstractLocalAlluxioCluster {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLocalAlluxioCluster.class);
    private static final Random RANDOM_GENERATOR = new Random();
    private static final int WAIT_MASTER_START_TIMEOUT_MS = 200000;
    protected ProxyProcess mProxyProcess = ProxyProcess.Factory.create();
    protected Thread mProxyThread;
    protected List<WorkerProcess> mWorkers;
    protected List<Thread> mWorkerThreads;
    protected String mWorkDirectory;
    protected String mHostname;
    private int mNumWorkers;

    AbstractLocalAlluxioCluster(int numWorkers) {
        this.mNumWorkers = numWorkers;
        this.mWorkerThreads = new ArrayList<Thread>();
    }

    public void start() throws Exception {
        System.setProperty("fs.hdfs.impl.disable.cache", "true");
        this.resetClientPools();
        this.setupTest();
        this.startMasters();
        this.startWorkers();
        this.startProxy();
        this.reset();
    }

    protected abstract void startMasters() throws Exception;

    protected void waitForMasterServing() throws TimeoutException, InterruptedException {
        CommonUtils.waitFor((String)"master starts serving RPCs", () -> {
            try {
                this.getClient().getStatus(new AlluxioURI("/"));
                return true;
            }
            catch (AlluxioException | AlluxioStatusException e) {
                LOG.error("Failed to get status of /:", e);
                return false;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(200000L));
    }

    public void restartMasters() throws Exception {
        this.stopMasters();
        this.startMasters();
    }

    protected void startProxy() throws Exception {
        this.mProxyProcess = ProxyProcess.Factory.create();
        Runnable runProxy = () -> {
            try {
                this.mProxyProcess.start();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                LOG.error("Start proxy error", (Throwable)e);
                throw new RuntimeException(e + " \n Start Proxy Error \n" + e.getMessage(), e);
            }
        };
        this.mProxyThread = new Thread(runProxy);
        this.mProxyThread.setName("ProxyThread-" + System.identityHashCode(this.mProxyThread));
        this.mProxyThread.start();
        TestUtils.waitForReady((Process)this.mProxyProcess);
    }

    public void startWorkers() throws Exception {
        this.mWorkers = new ArrayList<WorkerProcess>();
        for (int i = 0; i < this.mNumWorkers; ++i) {
            if (Configuration.getBoolean((PropertyKey)PropertyKey.DORA_ENABLED)) {
                String pageStoreDir = PathUtils.concatPath((Object)this.mWorkDirectory, (Object)("worker" + i));
                Configuration.set((PropertyKey)PropertyKey.WORKER_PAGE_STORE_DIRS, (Object)pageStoreDir);
                Configuration.set((PropertyKey)PropertyKey.DORA_WORKER_METASTORE_ROCKSDB_DIR, (Object)pageStoreDir);
            }
            WorkerProcess worker = WorkerProcess.Factory.create();
            this.mWorkers.add(worker);
            Runnable runWorker = () -> {
                try {
                    worker.start();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception e) {
                    LOG.error("Start worker error", (Throwable)e);
                    throw new RuntimeException(e + " \n Start Worker Error \n" + e.getMessage(), e);
                }
            };
            Thread thread = new Thread(runWorker);
            thread.setName("WorkerThread-" + System.identityHashCode(thread));
            this.mWorkerThreads.add(thread);
            thread.start();
        }
        for (WorkerProcess worker : this.mWorkers) {
            TestUtils.waitForReady((Process)worker);
        }
    }

    public void restartWorkers(Collection<WorkerNetAddress> addresses) throws Exception {
        for (WorkerNetAddress addr : addresses) {
            Configuration.set((PropertyKey)PropertyKey.WORKER_RPC_PORT, (Object)addr.getRpcPort());
            Configuration.set((PropertyKey)PropertyKey.WORKER_WEB_PORT, (Object)addr.getWebPort());
            WorkerProcess worker = WorkerProcess.Factory.create();
            this.mWorkers.add(worker);
            Runnable runWorker = () -> {
                try {
                    worker.start();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception e) {
                    LOG.error("Start worker error", (Throwable)e);
                    throw new RuntimeException(e + " \n Start Worker Error \n" + e.getMessage(), e);
                }
            };
            Thread thread = new Thread(runWorker);
            thread.setName("WorkerThread-" + System.identityHashCode(thread));
            this.mWorkerThreads.add(thread);
            thread.start();
            TestUtils.waitForReady((Process)worker);
        }
    }

    protected void setupTest() throws IOException {
        UnderFileSystem ufs = UnderFileSystem.Factory.createForRoot((AlluxioConfiguration)Configuration.global());
        String underfsAddress = Configuration.getString((PropertyKey)PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS);
        String doraUfsRoot = Configuration.getString((PropertyKey)PropertyKey.DORA_CLIENT_UFS_ROOT);
        UnderFileSystem doraUfs = UnderFileSystem.Factory.create((String)doraUfsRoot, (AlluxioConfiguration)Configuration.global());
        if (!ufs.isObjectStorage()) {
            UnderFileSystemUtils.deleteDirIfExists((UnderFileSystem)ufs, (String)underfsAddress);
        }
        if (!doraUfs.isObjectStorage()) {
            UnderFileSystemUtils.deleteDirIfExists((UnderFileSystem)doraUfs, (String)doraUfsRoot);
        }
        UnderFileSystemUtils.mkdirIfNotExists((UnderFileSystem)ufs, (String)underfsAddress);
        UnderFileSystemUtils.mkdirIfNotExists((UnderFileSystem)doraUfs, (String)doraUfsRoot);
        int numLevel = Configuration.getInt((PropertyKey)PropertyKey.WORKER_TIERED_STORE_LEVELS);
        for (int level = 0; level < numLevel; ++level) {
            String[] dirPaths;
            PropertyKey tierLevelDirPath = PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_DIRS_PATH.format(new Object[]{level});
            for (String dirPath : dirPaths = Configuration.getString((PropertyKey)tierLevelDirPath).split(",")) {
                FileUtils.createDir((String)dirPath);
            }
        }
        this.formatJournal();
    }

    protected void formatJournal() throws IOException {
        Format.format((Format.Mode)Format.Mode.MASTER, (AlluxioConfiguration)Configuration.global());
    }

    public void stop() throws Exception {
        this.stopFS();
        this.reset();
        Configuration.reloadProperties();
    }

    public void stopFS() throws Exception {
        LOG.info("stop Alluxio filesystem");
        this.stopProxy();
        this.stopWorkers();
        this.stopMasters();
    }

    public void formatAndRestartMasters() throws Exception {
        this.stopMasters();
        Format.format((Format.Mode)Format.Mode.MASTER, (AlluxioConfiguration)Configuration.global());
        this.startMasters();
    }

    protected abstract void stopMasters() throws Exception;

    protected void stopProxy() throws Exception {
        this.mProxyProcess.stop();
        if (this.mProxyThread != null) {
            while (this.mProxyThread.isAlive()) {
                LOG.info("Stopping thread {}.", (Object)this.mProxyThread.getName());
                this.mProxyThread.interrupt();
                this.mProxyThread.join(1000L);
            }
            this.mProxyThread = null;
        }
    }

    public void stopWorkers() throws Exception {
        this.killWorkerProcesses();
        LocalAlluxioMaster master = this.getLocalAlluxioMaster();
        if (master != null) {
            DefaultBlockMaster bm = (DefaultBlockMaster)master.getMasterProcess().getMaster(BlockMaster.class);
            bm.forgetAllWorkers();
        }
    }

    public void killWorkerProcesses() throws Exception {
        if (this.mWorkers == null) {
            return;
        }
        for (WorkerProcess worker : this.mWorkers) {
            worker.stop();
        }
        for (Thread thread : this.mWorkerThreads) {
            while (thread.isAlive()) {
                LOG.info("Stopping thread {}.", (Object)thread.getName());
                thread.interrupt();
                thread.join(1000L);
            }
        }
        this.mWorkerThreads.clear();
    }

    public boolean isStartedWorkers() {
        return !this.mWorkerThreads.isEmpty();
    }

    public abstract void initConfiguration(String var1) throws IOException;

    public abstract FileSystem getClient() throws IOException;

    public abstract FileSystem getClient(FileSystemContext var1) throws IOException;

    protected abstract LocalAlluxioMaster getLocalAlluxioMaster();

    public ProxyProcess getProxyProcess() {
        return this.mProxyProcess;
    }

    public void waitForWorkersRegistered(int timeoutMs) throws TimeoutException, InterruptedException, IOException {
        try (RetryHandlingMetaMasterClient client = new RetryHandlingMetaMasterClient(MasterClientContext.newBuilder((ClientContext)ClientContext.create((AlluxioConfiguration)Configuration.global())).build());){
            CommonUtils.waitFor((String)"workers registered", () -> this.lambda$waitForWorkersRegistered$4((MetaMasterClient)client), (WaitForOptions)WaitForOptions.defaults().setInterval(200).setTimeoutMs((long)timeoutMs));
        }
    }

    protected void reset() {
        ClientTestUtils.resetClient((InstancedConfiguration)Configuration.modifiableGlobal());
        GroupMappingServiceTestUtils.resetCache();
    }

    protected void resetClientPools() {
        Configuration.set((PropertyKey)PropertyKey.USER_METRICS_COLLECTION_ENABLED, (Object)false);
    }

    protected void setHostname() {
        this.mHostname = NetworkAddressUtils.getLocalHostName((int)100);
    }

    protected void setAlluxioWorkDirectory(String name) {
        if (name.contains(",")) {
            String normalizedName = name.replace(",", "_");
            LOG.warn("Alluxio work directory {} contains delimiter ',', renaming it to {}", (Object)name, (Object)normalizedName);
            name = normalizedName;
        }
        this.mWorkDirectory = AlluxioTestDirectory.createTemporaryDirectory((String)name).getAbsolutePath();
    }

    private /* synthetic */ Boolean lambda$waitForWorkersRegistered$4(MetaMasterClient client) {
        try {
            return client.getMasterInfo(Collections.emptySet()).getWorkerAddressesList().size() == this.mNumWorkers;
        }
        catch (UnavailableException e) {
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

