/*
 * Decompiled with CFR 0.152.
 */
package alluxio.multi.process;

import alluxio.AlluxioTestDirectory;
import alluxio.AlluxioURI;
import alluxio.ClientContext;
import alluxio.ConfigurationRule;
import alluxio.ConfigurationTestUtils;
import alluxio.cli.Format;
import alluxio.client.block.BlockMasterClient;
import alluxio.client.block.RetryHandlingBlockMasterClient;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.FileSystemMasterClient;
import alluxio.client.file.RetryHandlingFileSystemMasterClient;
import alluxio.client.journal.JournalMasterClient;
import alluxio.client.journal.RetryHandlingJournalMasterClient;
import alluxio.client.meta.MetaMasterClient;
import alluxio.client.meta.RetryHandlingMetaMasterClient;
import alluxio.client.metrics.MetricsMasterClient;
import alluxio.client.metrics.RetryHandlingMetricsMasterClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.conf.Source;
import alluxio.exception.status.UnavailableException;
import alluxio.grpc.MasterInfo;
import alluxio.grpc.ServiceType;
import alluxio.master.MasterClientContext;
import alluxio.master.MasterInquireClient;
import alluxio.master.PollingMasterInquireClient;
import alluxio.master.SingleMasterInquireClient;
import alluxio.master.ZkMasterInquireClient;
import alluxio.master.journal.JournalType;
import alluxio.multi.process.Clients;
import alluxio.multi.process.Master;
import alluxio.multi.process.MasterNetAddress;
import alluxio.multi.process.PortCoordination;
import alluxio.multi.process.Worker;
import alluxio.security.user.ServerUserState;
import alluxio.util.CommonUtils;
import alluxio.util.WaitForOptions;
import alluxio.util.io.PathUtils;
import alluxio.util.network.NetworkAddressUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.security.auth.Subject;
import net.bytebuddy.utility.RandomString;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.curator.test.TestingServer;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class MultiProcessCluster {
    public static final int PORTS_PER_MASTER = 3;
    public static final int PORTS_PER_WORKER = 3;
    private static final int MASTER_START_DELAY_MS = 500;
    private static final Logger LOG = LoggerFactory.getLogger(MultiProcessCluster.class);
    private static final File ARTIFACTS_DIR = new File("./target/artifacts");
    private static final File TESTS_LOG = new File("./target/logs/tests.log");
    private static final int WAIT_MASTER_SERVING_TIMEOUT_MS = 30000;
    private final Map<PropertyKey, Object> mProperties;
    private final Map<Integer, Map<PropertyKey, String>> mMasterProperties;
    private final Map<Integer, Map<PropertyKey, String>> mWorkerProperties;
    private int mNumMasters;
    private final int mNumWorkers;
    private final String mClusterName;
    private final Closer mCloser;
    private final List<Master> mMasters;
    private final List<Worker> mWorkers;
    private final List<PortCoordination.ReservedPort> mPorts;
    private final boolean mNoFormat;
    private DeployMode mDeployMode;
    private File mWorkDir;
    private List<MasterNetAddress> mMasterAddresses;
    private List<String> mMasterIds = new ArrayList<String>();
    private State mState;
    private TestingServer mCuratorServer;
    private FileSystemContext mFilesystemContext;
    private boolean mSuccess;

    private MultiProcessCluster(Map<PropertyKey, Object> properties, Map<Integer, Map<PropertyKey, String>> masterProperties, Map<Integer, Map<PropertyKey, String>> workerProperties, int numMasters, int numWorkers, String clusterName, boolean noFormat, List<PortCoordination.ReservedPort> ports) {
        LogManager.getLogger(MultiProcessCluster.class).setLevel(Level.DEBUG);
        Preconditions.checkState((ports.size() >= numMasters * 3 + numWorkers * 3 ? 1 : 0) != 0, (String)"We require %s ports per master and %s ports per worker, but there are %s masters, %s workers, and %s ports", (Object[])new Object[]{3, 3, numMasters, numWorkers, ports.size()});
        this.mProperties = properties;
        this.mMasterProperties = masterProperties;
        this.mWorkerProperties = workerProperties;
        this.mNumMasters = numMasters;
        this.mNumWorkers = numWorkers;
        this.mClusterName = clusterName + "-" + Math.abs(ThreadLocalRandom.current().nextInt());
        this.mNoFormat = noFormat;
        this.mMasters = new ArrayList<Master>();
        this.mWorkers = new ArrayList<Worker>();
        this.mPorts = new ArrayList<PortCoordination.ReservedPort>(ports);
        this.mCloser = Closer.create();
        this.mState = State.NOT_STARTED;
        this.mSuccess = false;
        JournalType journalType = (JournalType)this.mProperties.getOrDefault(PropertyKey.MASTER_JOURNAL_TYPE, Configuration.getEnum((PropertyKey)PropertyKey.MASTER_JOURNAL_TYPE, JournalType.class));
        this.mDeployMode = journalType == JournalType.EMBEDDED ? DeployMode.EMBEDDED : (numMasters > 1 ? DeployMode.ZOOKEEPER_HA : DeployMode.UFS_NON_HA);
    }

    public synchronized void start() throws Exception {
        Preconditions.checkState((this.mState != State.STARTED ? 1 : 0) != 0, (Object)"Cannot start while already started");
        Preconditions.checkState((this.mState != State.DESTROYED ? 1 : 0) != 0, (Object)"Cannot start a destroyed cluster");
        this.mWorkDir = AlluxioTestDirectory.createTemporaryDirectory((String)this.mClusterName);
        this.mState = State.STARTED;
        LOG.info("Starting alluxio cluster {} with base directory {}", (Object)this.mClusterName, (Object)this.mWorkDir.getAbsolutePath());
        this.startNewMasters(this.mNumMasters, !this.mNoFormat);
        for (int i = 0; i < this.mNumWorkers; ++i) {
            this.createWorker(i).start();
        }
        LOG.info("Starting alluxio cluster in directory {}", (Object)this.mWorkDir.getAbsolutePath());
        int primaryMasterIndex = this.getPrimaryMasterIndex(30000);
        LOG.info("Alluxio primary master {} starts serving RPCs", (Object)this.mMasterAddresses.get(primaryMasterIndex));
    }

    public synchronized void startNewMasters(int count, boolean format) throws Exception {
        int startIndex = 0;
        if (this.mMasterAddresses != null) {
            startIndex = this.mMasterAddresses.size();
        } else {
            this.mMasterAddresses = new ArrayList<MasterNetAddress>();
        }
        List<MasterNetAddress> masterAddresses = this.generateMasterAddresses(count);
        for (MasterNetAddress masterNetAddress : masterAddresses) {
            String id = masterNetAddress.getEmbeddedJournalPort() + "-" + RandomString.make((int)8);
            this.mMasterIds.add(id);
        }
        this.mMasterAddresses.addAll(masterAddresses);
        this.mNumMasters = this.mMasterAddresses.size();
        LOG.info("Master addresses: {}", this.mMasterAddresses);
        switch (this.mDeployMode) {
            case UFS_NON_HA: {
                MasterNetAddress masterAddress = this.mMasterAddresses.get(0);
                this.mProperties.put(PropertyKey.MASTER_JOURNAL_TYPE, JournalType.UFS);
                this.mProperties.put(PropertyKey.MASTER_HOSTNAME, masterAddress.getHostname());
                this.mProperties.put(PropertyKey.MASTER_RPC_PORT, masterAddress.getRpcPort());
                this.mProperties.put(PropertyKey.MASTER_WEB_PORT, masterAddress.getWebPort());
                break;
            }
            case EMBEDDED: {
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> rpcAddresses = new ArrayList<String>();
                for (MasterNetAddress address : this.mMasterAddresses) {
                    arrayList.add(String.format("%s:%d", address.getHostname(), address.getEmbeddedJournalPort()));
                    rpcAddresses.add(String.format("%s:%d", address.getHostname(), address.getRpcPort()));
                }
                this.mProperties.put(PropertyKey.MASTER_JOURNAL_TYPE, JournalType.EMBEDDED);
                this.mProperties.put(PropertyKey.MASTER_EMBEDDED_JOURNAL_ADDRESSES, Joiner.on((String)",").join(arrayList));
                this.mProperties.put(PropertyKey.MASTER_RPC_ADDRESSES, Joiner.on((String)",").join(rpcAddresses));
                break;
            }
            case ZOOKEEPER_HA: {
                this.mCuratorServer = (TestingServer)this.mCloser.register((Closeable)new TestingServer(-1, AlluxioTestDirectory.createTemporaryDirectory((String)"zk")));
                this.mProperties.put(PropertyKey.MASTER_JOURNAL_TYPE, JournalType.UFS);
                this.mProperties.put(PropertyKey.ZOOKEEPER_ENABLED, true);
                this.mProperties.put(PropertyKey.ZOOKEEPER_ADDRESS, this.mCuratorServer.getConnectString());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown deploy mode: " + (Object)((Object)this.mDeployMode));
            }
        }
        for (Map.Entry entry : ConfigurationTestUtils.testConfigurationDefaults((AlluxioConfiguration)Configuration.global(), (String)NetworkAddressUtils.getLocalHostName((int)((int)Configuration.getMs((PropertyKey)PropertyKey.NETWORK_HOST_RESOLUTION_TIMEOUT_MS))), (String)this.mWorkDir.getAbsolutePath()).entrySet()) {
            if (this.mProperties.containsKey(entry.getKey()) || ((PropertyKey)entry.getKey()).equals((Object)PropertyKey.USER_RPC_RETRY_MAX_DURATION)) continue;
            this.mProperties.put((PropertyKey)entry.getKey(), entry.getValue());
        }
        if (!this.mProperties.containsKey(PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS)) {
            this.mProperties.put(PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS, PathUtils.concatPath((Object)this.mWorkDir, (Object)"underFSStorage"));
            new File((String)this.mProperties.get(PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS)).mkdirs();
        }
        this.mProperties.put(PropertyKey.DORA_CLIENT_UFS_ROOT, PathUtils.concatPath((Object)this.mWorkDir, (Object)"underFSStorage"));
        this.mProperties.put(PropertyKey.MASTER_WORKER_REGISTER_LEASE_ENABLED, false);
        this.mProperties.put(PropertyKey.USER_NETTY_DATA_TRANSMISSION_ENABLED, true);
        if (format) {
            this.formatJournal();
        }
        this.writeConf();
        Configuration.merge(this.mProperties, (Source)Source.RUNTIME);
        for (int i = 0; i < count; ++i) {
            this.createMaster(startIndex + i).start();
            this.wait(500L);
        }
        this.mFilesystemContext = null;
    }

    public synchronized int waitForAndKillPrimaryMaster(int timeoutMs) throws TimeoutException, InterruptedException {
        int index = this.getPrimaryMasterIndex(timeoutMs);
        this.mMasters.get(index).close();
        return index;
    }

    public synchronized int getPrimaryMasterIndex(int timeoutMs) throws TimeoutException, InterruptedException {
        int primaryRpcPort;
        FileSystem fs = this.getFileSystemClient();
        MasterInquireClient inquireClient = this.getMasterInquireClient();
        CommonUtils.waitFor((String)"a primary master to be serving", () -> {
            try {
                fs.getStatus(new AlluxioURI("/"));
                return true;
            }
            catch (Exception e) {
                LOG.error("Failed to get status of root directory:", (Throwable)e);
                return false;
            }
        }, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs((long)timeoutMs));
        try {
            primaryRpcPort = inquireClient.getPrimaryRpcAddress().getPort();
        }
        catch (UnavailableException e) {
            throw new RuntimeException(e);
        }
        for (int i = 0; i < this.mMasterAddresses.size(); ++i) {
            if (this.mMasterAddresses.get(i).getRpcPort() != primaryRpcPort) continue;
            return i;
        }
        throw new RuntimeException(String.format("No master found with RPC port %d. Master addresses: %s", primaryRpcPort, this.mMasterAddresses));
    }

    public synchronized void waitForAllNodesRegistered(int timeoutMs) throws TimeoutException, InterruptedException {
        MetaMasterClient metaMasterClient = this.getMetaMasterClient();
        int nodeCount = this.mNumMasters + this.mNumWorkers;
        CommonUtils.waitFor((String)"all nodes registered", () -> {
            try {
                MasterInfo masterInfo = metaMasterClient.getMasterInfo(Collections.emptySet());
                int liveNodeNum = masterInfo.getMasterAddressesList().size() + masterInfo.getWorkerAddressesList().size();
                if (liveNodeNum == nodeCount) {
                    return true;
                }
                LOG.info("Master addresses: {}. Worker addresses: {}", (Object)masterInfo.getMasterAddressesList(), (Object)masterInfo.getWorkerAddressesList());
                return false;
            }
            catch (UnavailableException e) {
                return false;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, (WaitForOptions)WaitForOptions.defaults().setInterval(200).setTimeoutMs((long)timeoutMs));
    }

    public synchronized DeployMode getDeployMode() {
        return this.mDeployMode;
    }

    public synchronized FileSystemContext getFilesystemContext() {
        if (this.mFilesystemContext == null) {
            this.mFilesystemContext = FileSystemContext.create((Subject)new Subject(), (MasterInquireClient)this.getMasterInquireClient(), (AlluxioConfiguration)Configuration.global());
            this.mCloser.register((Closeable)this.mFilesystemContext);
        }
        return this.mFilesystemContext;
    }

    public synchronized FileSystem getFileSystemClient() {
        Preconditions.checkState((this.mState == State.STARTED ? 1 : 0) != 0, (String)"must be in the started state to create an fs client, but state was %s", (Object)((Object)this.mState));
        return FileSystem.Factory.create((FileSystemContext)this.getFilesystemContext());
    }

    public synchronized MetaMasterClient getMetaMasterClient() {
        Preconditions.checkState((this.mState == State.STARTED ? 1 : 0) != 0, (String)"must be in the started state to create a meta master client, but state was %s", (Object)((Object)this.mState));
        return new RetryHandlingMetaMasterClient(MasterClientContext.newBuilder((ClientContext)ClientContext.create((AlluxioConfiguration)Configuration.global())).setMasterInquireClient(this.getMasterInquireClient()).build());
    }

    public synchronized MetricsMasterClient getMetricsMasterClient() {
        Preconditions.checkState((this.mState == State.STARTED ? 1 : 0) != 0, (String)"must be in the started state to create a metrics master client, but state was %s", (Object)((Object)this.mState));
        return new RetryHandlingMetricsMasterClient(MasterClientContext.newBuilder((ClientContext)ClientContext.create((AlluxioConfiguration)Configuration.global())).setMasterInquireClient(this.getMasterInquireClient()).build());
    }

    public synchronized JournalMasterClient getJournalMasterClientForMaster() {
        Preconditions.checkState((this.mState == State.STARTED ? 1 : 0) != 0, (String)"must be in the started state to create a journal master client, but state was %s", (Object)((Object)this.mState));
        return new RetryHandlingJournalMasterClient(MasterClientContext.newBuilder((ClientContext)ClientContext.create((AlluxioConfiguration)Configuration.global())).setMasterInquireClient(this.getMasterInquireClient()).build());
    }

    public synchronized Clients getClients() {
        Preconditions.checkState((this.mState == State.STARTED ? 1 : 0) != 0, (String)"must be in the started state to create a meta master client, but state was %s", (Object)((Object)this.mState));
        MasterClientContext config = MasterClientContext.newBuilder((ClientContext)ClientContext.create((AlluxioConfiguration)Configuration.global())).setMasterInquireClient(this.getMasterInquireClient()).build();
        return new Clients(this.getFileSystemClient(), (FileSystemMasterClient)new RetryHandlingFileSystemMasterClient(config), (MetaMasterClient)new RetryHandlingMetaMasterClient(config), (BlockMasterClient)new RetryHandlingBlockMasterClient(config));
    }

    public synchronized void notifySuccess() {
        this.mSuccess = true;
    }

    public synchronized void saveWorkdir() throws IOException {
        Preconditions.checkState((this.mState == State.STARTED ? 1 : 0) != 0, (Object)"cluster must be started before you can save its work directory");
        ARTIFACTS_DIR.mkdirs();
        File tarball = new File(this.mWorkDir.getParentFile(), this.mWorkDir.getName() + ".tar.gz");
        ProcessBuilder pb = new ProcessBuilder("tar", "-czf", tarball.getName(), this.mWorkDir.getName());
        pb.directory(this.mWorkDir.getParentFile());
        pb.redirectOutput(ProcessBuilder.Redirect.appendTo(TESTS_LOG));
        pb.redirectError(ProcessBuilder.Redirect.appendTo(TESTS_LOG));
        Process p = pb.start();
        try {
            p.waitFor();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        File finalTarball = new File(ARTIFACTS_DIR, tarball.getName());
        FileUtils.moveFile((File)tarball, (File)finalTarball);
        LOG.info("Saved cluster {} to {}", (Object)this.mClusterName, (Object)finalTarball.getAbsolutePath());
    }

    public synchronized void destroy() throws IOException {
        if (this.mState == State.DESTROYED) {
            return;
        }
        if (!this.mSuccess) {
            this.saveWorkdir();
        }
        this.mCloser.close();
        Configuration.reloadProperties();
        LOG.info("Destroyed cluster {}", (Object)this.mClusterName);
        this.mState = State.DESTROYED;
    }

    public synchronized void startMasters() {
        this.mMasters.forEach(master -> master.start());
    }

    public synchronized void startMaster(int i) throws IOException {
        Preconditions.checkState((this.mState == State.STARTED ? 1 : 0) != 0, (Object)"Must be in a started state to start masters");
        this.mMasters.get(i).start();
    }

    public synchronized void startWorker(int i) throws IOException {
        Preconditions.checkState((this.mState == State.STARTED ? 1 : 0) != 0, (Object)"Must be in a started state to start workers");
        this.mWorkers.get(i).start();
    }

    public synchronized void stopMasters() {
        this.mMasters.forEach(master -> master.close());
    }

    public synchronized void stopMaster(int i) throws IOException {
        this.mMasters.get(i).close();
    }

    public synchronized void stopAndRemoveMaster(int i) throws IOException {
        this.stopMaster(i);
        this.mMasterAddresses.remove(i);
        this.mMasterIds.remove(i);
        this.mMasters.remove(i);
        this.mMasterProperties.remove(i);
        --this.mNumMasters;
        switch (this.mDeployMode) {
            case EMBEDDED: {
                String journalAddresses = this.mMasterAddresses.stream().map(addr -> String.format("%s:%d", addr.getHostname(), addr.getEmbeddedJournalPort())).collect(Collectors.joining(","));
                String rpcAddresses = this.mMasterAddresses.stream().map(addr -> String.format("%s:%d", addr.getHostname(), addr.getRpcPort())).collect(Collectors.joining(","));
                this.mProperties.put(PropertyKey.MASTER_EMBEDDED_JOURNAL_ADDRESSES, journalAddresses);
                this.mProperties.put(PropertyKey.MASTER_RPC_ADDRESSES, rpcAddresses);
                Configuration.set((PropertyKey)PropertyKey.MASTER_EMBEDDED_JOURNAL_ADDRESSES, (Object)journalAddresses);
                Configuration.set((PropertyKey)PropertyKey.MASTER_RPC_ADDRESSES, (Object)rpcAddresses);
                break;
            }
            case ZOOKEEPER_HA: {
                break;
            }
            default: {
                throw new IllegalStateException("Unimplemented deploy mode: " + (Object)((Object)this.mDeployMode));
            }
        }
        this.mFilesystemContext = null;
    }

    public synchronized void updateMasterConf(PropertyKey key, @Nullable String value) {
        this.mMasters.forEach(master -> master.updateConf(key, value));
    }

    public synchronized void addExternalMasterAddress(MasterNetAddress externalMasterAddress) {
        this.mMasterAddresses.add(externalMasterAddress);
        this.mFilesystemContext = null;
    }

    public synchronized void updateDeployMode(DeployMode mode) {
        this.mDeployMode = mode;
        if (this.mDeployMode == DeployMode.EMBEDDED) {
            for (int i = 0; i < this.mMasters.size(); ++i) {
                Master master = this.mMasters.get(i);
                MasterNetAddress address = this.mMasterAddresses.get(i);
                master.updateConf(PropertyKey.MASTER_EMBEDDED_JOURNAL_PORT, address.getEmbeddedJournalPort());
                File journalDir = new File(this.mWorkDir, "journal" + i);
                journalDir.mkdirs();
                master.updateConf(PropertyKey.MASTER_JOURNAL_FOLDER, journalDir.getAbsolutePath());
            }
        }
    }

    public synchronized void stopWorker(int i) throws IOException {
        this.mWorkers.get(i).close();
    }

    public synchronized String getJournalDir() {
        return (String)this.mProperties.get(PropertyKey.MASTER_JOURNAL_FOLDER);
    }

    public String getJournalDir(int masterId) {
        return (String)this.mMasters.get(masterId).getConf().get(PropertyKey.MASTER_JOURNAL_FOLDER);
    }

    public synchronized List<MasterNetAddress> getMasterAddresses() {
        return this.mMasterAddresses;
    }

    public synchronized void stopZk() throws IOException {
        this.mCuratorServer.stop();
    }

    public synchronized void restartZk() throws Exception {
        Preconditions.checkNotNull((Object)this.mCuratorServer, (Object)"mCuratorServer");
        this.mCuratorServer.restart();
    }

    private synchronized Master createMaster(int i) throws IOException {
        Preconditions.checkState((this.mState == State.STARTED ? 1 : 0) != 0, (Object)"Must be in a started state to create masters");
        MasterNetAddress address = this.mMasterAddresses.get(i);
        String extension = "-" + this.mMasterIds.get(i);
        File confDir = new File(this.mWorkDir, "conf-master" + extension);
        File metastoreDir = new File(this.mWorkDir, "metastore-master" + extension);
        File logsDir = new File(this.mWorkDir, "logs-master" + extension);
        logsDir.mkdirs();
        HashMap<PropertyKey, Object> conf = new HashMap<PropertyKey, Object>();
        conf.put(PropertyKey.LOGGER_TYPE, "MASTER_LOGGER");
        conf.put(PropertyKey.CONF_DIR, confDir.getAbsolutePath());
        conf.put(PropertyKey.MASTER_METASTORE_DIR, metastoreDir.getAbsolutePath());
        conf.put(PropertyKey.LOGS_DIR, logsDir.getAbsolutePath());
        conf.put(PropertyKey.MASTER_HOSTNAME, address.getHostname());
        conf.put(PropertyKey.MASTER_RPC_PORT, address.getRpcPort());
        conf.put(PropertyKey.MASTER_WEB_PORT, address.getWebPort());
        conf.put(PropertyKey.MASTER_EMBEDDED_JOURNAL_PORT, address.getEmbeddedJournalPort());
        if (this.mDeployMode.equals((Object)DeployMode.EMBEDDED)) {
            File journalDir = new File(this.mWorkDir, "journal" + extension);
            journalDir.mkdirs();
            conf.put(PropertyKey.MASTER_JOURNAL_FOLDER, journalDir.getAbsolutePath());
        }
        Master master = (Master)this.mCloser.register((Closeable)new Master(logsDir, conf));
        this.mMasters.add(master);
        return master;
    }

    private synchronized Worker createWorker(int i) throws IOException {
        Preconditions.checkState((this.mState == State.STARTED ? 1 : 0) != 0, (Object)"Must be in a started state to create workers");
        File confDir = new File(this.mWorkDir, "conf-worker" + i);
        File logsDir = new File(this.mWorkDir, "logs-worker" + i);
        File ramdisk = new File(this.mWorkDir, "ramdisk" + i);
        File workerMetaStoreDir = new File(this.mWorkDir, "metastore-worker-" + i);
        logsDir.mkdirs();
        ramdisk.mkdirs();
        workerMetaStoreDir.mkdirs();
        int rpcPort = this.getNewPort();
        int dataPort = this.getNewPort();
        int webPort = this.getNewPort();
        HashMap<PropertyKey, Object> conf = new HashMap<PropertyKey, Object>();
        conf.put(PropertyKey.LOGGER_TYPE, "WORKER_LOGGER");
        conf.put(PropertyKey.CONF_DIR, confDir.getAbsolutePath());
        conf.put(PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_DIRS_PATH.format(new Object[]{0}), ramdisk.getAbsolutePath());
        conf.put(PropertyKey.LOGS_DIR, logsDir.getAbsolutePath());
        conf.put(PropertyKey.WORKER_RPC_PORT, rpcPort);
        conf.put(PropertyKey.WORKER_WEB_PORT, webPort);
        conf.put(PropertyKey.WORKER_DATA_PORT, dataPort);
        conf.put(PropertyKey.DORA_WORKER_METASTORE_ROCKSDB_DIR, workerMetaStoreDir.getAbsolutePath());
        conf.put(PropertyKey.DORA_CLIENT_UFS_ROOT, PathUtils.concatPath((Object)this.mWorkDir, (Object)"underFSStorage"));
        conf.put(PropertyKey.MASTER_WORKER_REGISTER_LEASE_ENABLED, false);
        conf.put(PropertyKey.USER_NETTY_DATA_TRANSMISSION_ENABLED, true);
        Worker worker = (Worker)this.mCloser.register((Closeable)new Worker(logsDir, conf));
        this.mWorkers.add(worker);
        LOG.info("Created worker with (rpc, data, web) ports ({}, {}, {})", new Object[]{rpcPort, dataPort, webPort});
        return worker;
    }

    public synchronized void formatJournal() throws IOException {
        if (this.mDeployMode == DeployMode.EMBEDDED) {
            for (Master master : this.mMasters) {
                File journalDir = new File((String)master.getConf().get(PropertyKey.MASTER_JOURNAL_FOLDER));
                FileUtils.deleteDirectory((File)journalDir);
                journalDir.mkdirs();
            }
            return;
        }
        try (Closeable c = new ConfigurationRule(this.mProperties, Configuration.modifiableGlobal()).toResource();){
            Format.format((Format.Mode)Format.Mode.MASTER, (AlluxioConfiguration)Configuration.global());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized MasterInquireClient getMasterInquireClient() {
        switch (this.mDeployMode) {
            case UFS_NON_HA: {
                Preconditions.checkState((this.mMasters.size() == 1 ? 1 : 0) != 0, (Object)"Running with multiple masters requires Zookeeper or Embedded Journal");
                return new SingleMasterInquireClient(InetSocketAddress.createUnresolved(this.mMasterAddresses.get(0).getHostname(), this.mMasterAddresses.get(0).getRpcPort()));
            }
            case EMBEDDED: {
                if (this.mMasterAddresses.size() > 1) {
                    ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>(this.mMasterAddresses.size());
                    for (MasterNetAddress address : this.mMasterAddresses) {
                        addresses.add(InetSocketAddress.createUnresolved(address.getHostname(), address.getRpcPort()));
                    }
                    return new PollingMasterInquireClient(addresses, Configuration.global(), ServerUserState.global(), ServiceType.META_MASTER_CLIENT_SERVICE);
                }
                return new SingleMasterInquireClient(InetSocketAddress.createUnresolved(this.mMasterAddresses.get(0).getHostname(), this.mMasterAddresses.get(0).getRpcPort()));
            }
            case ZOOKEEPER_HA: {
                return ZkMasterInquireClient.getClient((String)this.mCuratorServer.getConnectString(), (String)Configuration.getString((PropertyKey)PropertyKey.ZOOKEEPER_ELECTION_PATH), (String)Configuration.getString((PropertyKey)PropertyKey.ZOOKEEPER_LEADER_PATH), (int)Configuration.getInt((PropertyKey)PropertyKey.ZOOKEEPER_LEADER_INQUIRY_RETRY_COUNT), (boolean)Configuration.getBoolean((PropertyKey)PropertyKey.ZOOKEEPER_AUTH_ENABLED));
            }
        }
        throw new IllegalStateException("Unknown deploy mode: " + (Object)((Object)this.mDeployMode));
    }

    private void writeConf() throws IOException {
        int i;
        for (i = 0; i < this.mNumMasters; ++i) {
            String extension = "-" + this.mMasterIds.get(i);
            File confDir = new File(this.mWorkDir, "conf-master" + extension);
            this.writeConfToFile(confDir, this.mMasterProperties.getOrDefault(i, new HashMap()));
        }
        for (i = 0; i < this.mNumWorkers; ++i) {
            File confDir = new File(this.mWorkDir, "conf-worker" + i);
            this.writeConfToFile(confDir, this.mWorkerProperties.getOrDefault(i, new HashMap()));
        }
    }

    private int getNewPort() throws IOException {
        Preconditions.checkState((!this.mPorts.isEmpty() ? 1 : 0) != 0, (Object)"Out of ports to reserve");
        return this.mPorts.remove(this.mPorts.size() - 1).getPort();
    }

    private void writeConfToFile(File dir, Map<PropertyKey, String> properties) throws IOException {
        HashMap<PropertyKey, Object> map = new HashMap<PropertyKey, Object>(this.mProperties);
        for (Map.Entry<PropertyKey, String> entry : properties.entrySet()) {
            map.put(entry.getKey(), entry.getValue());
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : map.entrySet()) {
            sb.append(String.format("%s=%s%n", entry.getKey(), entry.getValue()));
        }
        dir.mkdirs();
        Throwable throwable = null;
        try (FileOutputStream fileOutputStream = new FileOutputStream(new File(dir, "alluxio-site.properties"));){
            fileOutputStream.write(sb.toString().getBytes(Charsets.UTF_8));
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
    }

    private List<MasterNetAddress> generateMasterAddresses(int numMasters) throws IOException {
        ArrayList<MasterNetAddress> addrs = new ArrayList<MasterNetAddress>();
        for (int i = 0; i < numMasters; ++i) {
            addrs.add(new MasterNetAddress(NetworkAddressUtils.getLocalHostName((int)((int)Configuration.getMs((PropertyKey)PropertyKey.NETWORK_HOST_RESOLUTION_TIMEOUT_MS))), this.getNewPort(), this.getNewPort(), this.getNewPort()));
        }
        return addrs;
    }

    public static Builder newBuilder(List<PortCoordination.ReservedPort> reservedPorts) {
        return new Builder(reservedPorts);
    }

    public static final class Builder {
        private final List<PortCoordination.ReservedPort> mReservedPorts;
        private Map<PropertyKey, Object> mProperties = new HashMap<PropertyKey, Object>();
        private Map<Integer, Map<PropertyKey, String>> mMasterProperties = new HashMap<Integer, Map<PropertyKey, String>>();
        private Map<Integer, Map<PropertyKey, String>> mWorkerProperties = new HashMap<Integer, Map<PropertyKey, String>>();
        private int mNumMasters = 1;
        private int mNumWorkers = 1;
        private String mClusterName = "AlluxioMiniCluster";
        private boolean mNoFormat = false;

        private Builder(List<PortCoordination.ReservedPort> reservedPorts) {
            this.mReservedPorts = reservedPorts;
        }

        public Builder addProperty(PropertyKey key, Object value) {
            Preconditions.checkState((!key.equals((Object)PropertyKey.ZOOKEEPER_ENABLED) ? 1 : 0) != 0, (Object)"Enable Zookeeper via #setDeployMode instead of #addProperty");
            this.mProperties.put(key, value);
            return this;
        }

        public Builder addProperties(Map<PropertyKey, Object> properties) {
            for (Map.Entry<PropertyKey, Object> entry : properties.entrySet()) {
                this.addProperty(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public Builder setMasterProperties(Map<Integer, Map<PropertyKey, String>> properties) {
            this.mMasterProperties = properties;
            return this;
        }

        public Builder setWorkerProperties(Map<Integer, Map<PropertyKey, String>> properties) {
            this.mWorkerProperties = properties;
            return this;
        }

        public Builder setNumMasters(int numMasters) {
            this.mNumMasters = numMasters;
            return this;
        }

        public Builder setNumWorkers(int numWorkers) {
            this.mNumWorkers = numWorkers;
            return this;
        }

        public Builder setClusterName(String clusterName) {
            this.mClusterName = clusterName;
            return this;
        }

        public Builder setNoFormat(boolean noFormat) {
            this.mNoFormat = noFormat;
            return this;
        }

        public MultiProcessCluster build() {
            Preconditions.checkState((this.mMasterProperties.keySet().stream().filter(key -> key >= this.mNumMasters || key < 0).count() == 0L ? 1 : 0) != 0, (String)"The master indexes in master properties should be bigger or equal to zero and small than %s", (int)this.mNumMasters);
            Preconditions.checkState((this.mWorkerProperties.keySet().stream().filter(key -> key >= this.mNumWorkers || key < 0).count() == 0L ? 1 : 0) != 0, (String)"The worker indexes in worker properties should be bigger or equal to zero and small than %s", (int)this.mNumWorkers);
            return new MultiProcessCluster(this.mProperties, this.mMasterProperties, this.mWorkerProperties, this.mNumMasters, this.mNumWorkers, this.mClusterName, this.mNoFormat, this.mReservedPorts);
        }
    }

    public static enum DeployMode {
        EMBEDDED,
        UFS_NON_HA,
        ZOOKEEPER_HA;

    }

    private static enum State {
        NOT_STARTED,
        STARTED,
        DESTROYED;

    }
}

