/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.ClientContext;
import alluxio.ConfigurationTestUtils;
import alluxio.client.block.BlockMasterClient;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.master.AbstractLocalAlluxioCluster;
import alluxio.master.LocalAlluxioMaster;
import alluxio.master.MasterClientContext;
import alluxio.master.TestUtils;
import alluxio.membership.WorkerClusterView;
import alluxio.util.CommonUtils;
import alluxio.util.WaitForOptions;
import alluxio.wire.WorkerNetAddress;
import alluxio.worker.WorkerProcess;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class LocalAlluxioCluster
extends AbstractLocalAlluxioCluster {
    private static final Logger LOG = LoggerFactory.getLogger(LocalAlluxioCluster.class);
    private boolean mIncludeProxy;
    private LocalAlluxioMaster mMaster;

    public LocalAlluxioCluster() {
        this(1, false);
    }

    public LocalAlluxioCluster(int numWorkers, boolean includeProxy) {
        super(numWorkers);
        this.mIncludeProxy = includeProxy;
    }

    @Override
    public FileSystem getClient() throws IOException {
        return this.mMaster.getClient();
    }

    @Override
    public FileSystem getClient(FileSystemContext context) throws IOException {
        return this.mMaster.getClient(context);
    }

    @Override
    public LocalAlluxioMaster getLocalAlluxioMaster() {
        return this.mMaster;
    }

    public String getHostname() {
        return this.mHostname;
    }

    public String getMasterURI() {
        return this.mMaster.getUri();
    }

    public int getMasterRpcPort() {
        return this.mMaster.getRpcLocalPort();
    }

    public String getAlluxioHome() {
        return this.mWorkDirectory;
    }

    public WorkerProcess getWorkerProcess() {
        return (WorkerProcess)this.mWorkers.get(0);
    }

    public WorkerNetAddress getWorkerAddress() {
        return this.getWorkerProcess().getAddress();
    }

    @Override
    public void initConfiguration(String name) throws IOException {
        this.setAlluxioWorkDirectory(name);
        this.setHostname();
        for (Map.Entry entry : ConfigurationTestUtils.testConfigurationDefaults((AlluxioConfiguration)Configuration.global(), (String)this.mHostname, (String)this.mWorkDirectory).entrySet()) {
            Configuration.set((PropertyKey)((PropertyKey)entry.getKey()), entry.getValue());
        }
        Configuration.set((PropertyKey)PropertyKey.TEST_MODE, (Object)true);
        Configuration.set((PropertyKey)PropertyKey.JOB_WORKER_THROTTLING, (Object)false);
        Configuration.set((PropertyKey)PropertyKey.PROXY_WEB_PORT, (Object)0);
        Configuration.set((PropertyKey)PropertyKey.WORKER_RPC_PORT, (Object)0);
        Configuration.set((PropertyKey)PropertyKey.WORKER_DATA_PORT, (Object)0);
        Configuration.set((PropertyKey)PropertyKey.WORKER_WEB_PORT, (Object)0);
        Configuration.set((PropertyKey)PropertyKey.WORKER_HTTP_SERVER_PORT, (Object)0);
        Configuration.set((PropertyKey)PropertyKey.WORKER_REST_PORT, (Object)0);
    }

    @Override
    public void startMasters() throws Exception {
        this.mMaster = LocalAlluxioMaster.create(this.mWorkDirectory);
        this.mMaster.start();
        this.waitForMasterServing();
    }

    @Override
    protected void startProxy() throws Exception {
        if (this.mIncludeProxy) {
            super.startProxy();
        }
    }

    @Override
    protected void waitForMasterServing() throws TimeoutException, InterruptedException {
        CommonUtils.waitFor((String)"master starts serving RPCs", () -> {
            try (BlockMasterClient blockMasterClient = BlockMasterClient.Factory.create((MasterClientContext)MasterClientContext.newBuilder((ClientContext)ClientContext.create((AlluxioConfiguration)Configuration.global())).build());){
                List workerInfoList = blockMasterClient.getWorkerInfoList();
                Boolean bl = true;
                return bl;
            }
            catch (IOException ioe) {
                LOG.error("getWorkerInfoList() ERROR: ", (Throwable)ioe);
                return false;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(10000L));
    }

    @Override
    protected void waitForWorkersServing() throws TimeoutException, InterruptedException {
        CommonUtils.waitFor((String)"worker starts serving RPCs", () -> {
            try (FileSystemContext fsContext = FileSystemContext.create();){
                WorkerClusterView workers = fsContext.getCachedWorkers();
                LOG.info("Observed {} workers in the cluster", (Object)workers.size());
                Boolean bl = workers.size() == this.mNumWorkers;
                return bl;
            }
            catch (IOException ioe) {
                LOG.error(ioe.getMessage());
                return false;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(10000L));
    }

    @Override
    public void stop() throws Exception {
        LOG.info("stop local alluxio cluster.");
        super.stop();
        TestUtils.assertAllLocksReleased(this);
        System.clearProperty("fs.hdfs.impl.disable.cache");
    }

    @Override
    public void stopMasters() throws Exception {
        this.mMaster.stop();
    }
}

