/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.AlluxioTestDirectory;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.master.AlluxioMasterProcess;
import alluxio.master.ClientPool;
import alluxio.util.io.FileUtils;
import alluxio.util.network.NetworkAddressUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Supplier;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class LocalAlluxioMaster {
    private static final Logger LOG = LoggerFactory.getLogger(LocalAlluxioMaster.class);
    private final String mHostname;
    private final String mJournalFolder;
    private final Supplier<String> mClientSupplier = this::getUri;
    private final ClientPool mClientPool = new ClientPool(this.mClientSupplier);
    private AlluxioMasterProcess mMasterProcess;
    private Thread mMasterThread;

    private LocalAlluxioMaster() {
        this.mHostname = NetworkAddressUtils.getConnectHost((NetworkAddressUtils.ServiceAttributeProvider)NetworkAddressUtils.ServiceType.MASTER_RPC, (AlluxioConfiguration)Configuration.global());
        this.mJournalFolder = Configuration.getString((PropertyKey)PropertyKey.MASTER_JOURNAL_FOLDER);
    }

    public static LocalAlluxioMaster create() throws IOException {
        String workDirectory = LocalAlluxioMaster.uniquePath();
        FileUtils.deletePathRecursively((String)workDirectory);
        Configuration.set((PropertyKey)PropertyKey.WORK_DIR, (Object)workDirectory);
        return LocalAlluxioMaster.create(workDirectory);
    }

    public static LocalAlluxioMaster create(String workDirectory) throws IOException {
        if (!Files.isDirectory(Paths.get(workDirectory, new String[0]), new LinkOption[0])) {
            Files.createDirectory(Paths.get(workDirectory, new String[0]), new FileAttribute[0]);
        }
        return new LocalAlluxioMaster();
    }

    public void start() {
        this.mMasterProcess = AlluxioMasterProcess.Factory.create();
        Runnable runMaster = new Runnable(){

            @Override
            public void run() {
                try {
                    LOG.info("Starting Alluxio master {}.", (Object)LocalAlluxioMaster.this.mMasterProcess);
                    LocalAlluxioMaster.this.mMasterProcess.start();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception e) {
                    LOG.error("Start master error", (Throwable)e);
                    throw new RuntimeException(e + " \n Start Master Error \n" + e.getMessage(), e);
                }
            }
        };
        this.mMasterThread = new Thread(runMaster);
        this.mMasterThread.setName("MasterThread-" + System.identityHashCode(this.mMasterThread));
        this.mMasterThread.start();
    }

    public boolean isServing() {
        return this.mMasterProcess.isGrpcServingAsLeader();
    }

    public void stop() throws Exception {
        if (this.mMasterThread != null) {
            this.mMasterProcess.stop();
            while (this.mMasterThread.isAlive()) {
                LOG.info("Stopping thread {}.", (Object)this.mMasterThread.getName());
                this.mMasterThread.interrupt();
                this.mMasterThread.join(1000L);
            }
            this.mMasterThread = null;
        }
        this.clearClients();
        System.clearProperty("alluxio.web.resources");
        System.clearProperty("alluxio.master.min.worker.threads");
    }

    public void clearClients() throws IOException {
        this.mClientPool.close();
    }

    public InetSocketAddress getAddress() {
        return this.mMasterProcess.getRpcAddress();
    }

    public AlluxioMasterProcess getMasterProcess() {
        return this.mMasterProcess;
    }

    public int getRpcLocalPort() {
        return this.mMasterProcess.getRpcAddress().getPort();
    }

    public String getUri() {
        return "alluxio://" + this.mHostname + ":" + this.getRpcLocalPort();
    }

    public FileSystem getClient() throws IOException {
        return this.mClientPool.getClient();
    }

    public FileSystem getClient(FileSystemContext context) throws IOException {
        return this.mClientPool.getClient(context);
    }

    private static String uniquePath() throws IOException {
        return AlluxioTestDirectory.createTemporaryDirectory((String)"alluxio-master").getAbsolutePath();
    }

    public String getJournalFolder() {
        return this.mJournalFolder;
    }
}

