/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.cli.Command;
import alluxio.conf.InstancedConfiguration;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.shaded.client.com.google.common.io.Closer;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import alluxio.shaded.client.org.apache.commons.cli.CommandLine;
import alluxio.shaded.client.org.apache.commons.lang.ArrayUtils;
import alluxio.shaded.client.org.apache.commons.lang.StringUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class AbstractShell
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractShell.class);
    private Map<String, String[]> mCommandAlias;
    private Set<String> mUnstableAlias;
    private Map<String, Command> mCommands;
    protected InstancedConfiguration mConfiguration;
    protected Closer mCloser = Closer.create();

    public AbstractShell(Map<String, String[]> commandAlias, Set<String> unstableAlias, InstancedConfiguration conf) {
        this.mConfiguration = conf;
        this.mUnstableAlias = unstableAlias;
        this.mCommandAlias = commandAlias;
        this.mCommands = this.loadCommands();
    }

    public int run(String ... argv) {
        CommandLine cmdline;
        if (argv.length == 0) {
            this.printUsage();
            return -1;
        }
        String cmd = argv[0];
        Command command = this.mCommands.get(cmd);
        if (command == null) {
            Object[] replacementCmd = this.getReplacementCmd(cmd);
            if (replacementCmd == null) {
                System.err.println(String.format("%s is an unknown command.", cmd));
                this.printUsage();
                return -1;
            }
            if (this.mUnstableAlias != null && this.mUnstableAlias.contains(cmd)) {
                String deprecatedMsg = String.format("WARNING: %s is not a stable CLI command. It may be removed in the future. Use with caution in scripts. You may use '%s' instead.", cmd, StringUtils.join(replacementCmd, " "));
                System.out.println(deprecatedMsg);
            }
            String[] replacementArgv = (String[])ArrayUtils.addAll(replacementCmd, ArrayUtils.subarray(argv, 1, argv.length));
            return this.run(replacementArgv);
        }
        try {
            String[] args;
            if (command.hasSubCommand()) {
                if (argv.length < 2) {
                    throw new InvalidArgumentException("No sub-command is specified");
                }
                if (!command.getSubCommands().containsKey(argv[1])) {
                    throw new InvalidArgumentException("Unknown sub-command: " + argv[1]);
                }
                command = command.getSubCommands().get(argv[1]);
                args = argv.length > 2 ? Arrays.copyOfRange(argv, 2, argv.length) : new String[]{};
            } else {
                args = Arrays.copyOfRange(argv, 1, argv.length);
            }
            cmdline = command.parseAndValidateArgs(args);
        }
        catch (InvalidArgumentException e) {
            System.out.println("Usage: " + command.getUsage());
            System.out.println(command.getDescription());
            LOG.error("Invalid arguments for command {}:", (Object)command.getCommandName(), (Object)e);
            return -1;
        }
        try {
            return command.run(cmdline);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            LOG.error("Error running " + StringUtils.join((Object[])argv, " "), (Throwable)e);
            return -1;
        }
    }

    public Collection<Command> getCommands() {
        return this.mCommands.values();
    }

    @Override
    public void close() throws IOException {
        this.mCloser.close();
    }

    @Nullable
    private String[] getReplacementCmd(String cmd) {
        if (this.mCommandAlias == null || !this.mCommandAlias.containsKey(cmd)) {
            return null;
        }
        return this.mCommandAlias.get(cmd);
    }

    protected abstract String getShellName();

    protected abstract Map<String, Command> loadCommands();

    protected void printUsage() {
        System.out.println("Usage: alluxio " + this.getShellName() + " [generic options]");
        TreeSet<String> sortedCmds = new TreeSet<String>(this.mCommands.keySet());
        for (String cmd : sortedCmds) {
            System.out.format("%-60s%n", "\t [" + this.mCommands.get(cmd).getUsage() + "]");
        }
    }
}

