/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.cli.Command;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.shaded.client.org.apache.commons.cli.CommandLine;
import alluxio.shaded.client.org.reflections.Reflections;
import alluxio.shaded.client.org.reflections.scanners.Scanner;
import alluxio.util.CommonUtils;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

@ThreadSafe
public final class CommandUtils {
    private CommandUtils() {
    }

    public static Map<String, Command> loadCommands(String pkgName, Class[] classArgs, Object[] objectArgs) {
        HashMap<String, Command> commandsMap = new HashMap<String, Command>();
        Reflections reflections = new Reflections(Command.class.getPackage().getName(), new Scanner[0]);
        for (Class<Command> cls : reflections.getSubTypesOf(Command.class)) {
            if (!cls.getPackage().getName().equals(pkgName + ".command") || Modifier.isAbstract(cls.getModifiers())) continue;
            Command cmd = CommonUtils.createNewClassInstance(cls, classArgs, objectArgs);
            commandsMap.put(cmd.getCommandName(), cmd);
        }
        return commandsMap;
    }

    public static void checkNumOfArgsEquals(Command cmd, CommandLine cl, int n) throws InvalidArgumentException {
        if (cl.getArgs().length != n) {
            throw new InvalidArgumentException(ExceptionMessage.INVALID_ARGS_NUM.getMessage(cmd.getCommandName(), n, cl.getArgs().length));
        }
    }

    public static void checkNumOfArgsNoLessThan(Command cmd, CommandLine cl, int n) throws InvalidArgumentException {
        if (cl.getArgs().length < n) {
            throw new InvalidArgumentException(ExceptionMessage.INVALID_ARGS_NUM_INSUFFICIENT.getMessage(cmd.getCommandName(), n, cl.getArgs().length));
        }
    }

    public static void checkNumOfArgsNoMoreThan(Command cmd, CommandLine cl, int n) throws InvalidArgumentException {
        if (cl.getArgs().length > n) {
            throw new InvalidArgumentException(ExceptionMessage.INVALID_ARGS_NUM_TOO_MANY.getMessage(cmd.getCommandName(), n, cl.getArgs().length));
        }
    }
}

