/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block.stream;

import alluxio.client.BoundedStream;
import alluxio.client.Cancelable;
import alluxio.client.block.stream.DataWriter;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.options.OutStreamOptions;
import alluxio.exception.PreconditionMessage;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.io.Closer;
import alluxio.shaded.client.io.netty.buffer.ByteBuf;
import alluxio.shaded.client.io.netty.buffer.PooledByteBufAllocator;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import alluxio.wire.WorkerNetAddress;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class BlockOutStream
extends OutputStream
implements BoundedStream,
Cancelable {
    private static final Logger LOG = LoggerFactory.getLogger(BlockOutStream.class);
    private final Closer mCloser = Closer.create();
    private final long mLength;
    private final WorkerNetAddress mAddress;
    private ByteBuf mCurrentChunk = null;
    private final List<DataWriter> mDataWriters;
    private boolean mClosed;

    public static BlockOutStream create(FileSystemContext context, long blockId, long blockSize, WorkerNetAddress address, OutStreamOptions options) throws IOException {
        DataWriter dataWriter = DataWriter.Factory.create(context, blockId, blockSize, address, options);
        return new BlockOutStream(dataWriter, blockSize, address);
    }

    protected BlockOutStream(DataWriter dataWriter, long length, WorkerNetAddress address) {
        this.mLength = length;
        this.mAddress = address;
        this.mDataWriters = new ArrayList<DataWriter>(1);
        this.mDataWriters.add(dataWriter);
        this.mCloser.register(dataWriter);
        this.mClosed = false;
    }

    @Override
    public long remaining() {
        long pos = Long.MAX_VALUE;
        for (DataWriter dataWriter : this.mDataWriters) {
            pos = Math.min(pos, dataWriter.pos());
        }
        return this.mLength - pos - (long)(this.mCurrentChunk != null ? this.mCurrentChunk.readableBytes() : 0);
    }

    public static BlockOutStream createReplicatedBlockOutStream(FileSystemContext context, long blockId, long blockSize, List<WorkerNetAddress> workerNetAddresses, OutStreamOptions options) throws IOException {
        ArrayList<DataWriter> dataWriters = new ArrayList<DataWriter>();
        for (WorkerNetAddress address : workerNetAddresses) {
            DataWriter dataWriter = DataWriter.Factory.create(context, blockId, blockSize, address, options);
            dataWriters.add(dataWriter);
        }
        return new BlockOutStream(dataWriters, blockSize, workerNetAddresses);
    }

    protected BlockOutStream(List<DataWriter> dataWriters, long length, List<WorkerNetAddress> workerNetAddresses) {
        this.mLength = length;
        this.mAddress = workerNetAddresses.get(0);
        this.mDataWriters = dataWriters;
        for (DataWriter dataWriter : dataWriters) {
            this.mCloser.register(dataWriter);
        }
        this.mClosed = false;
    }

    @Override
    public void write(int b) throws IOException {
        Preconditions.checkState(this.remaining() > 0L, (Object)PreconditionMessage.ERR_END_OF_BLOCK);
        this.updateCurrentChunk(false);
        this.mCurrentChunk.writeByte(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        while (len > 0) {
            this.updateCurrentChunk(false);
            int toWrite = Math.min(len, this.mCurrentChunk.writableBytes());
            this.mCurrentChunk.writeBytes(b, off, toWrite);
            off += toWrite;
            len -= toWrite;
        }
        this.updateCurrentChunk(false);
    }

    public void write(ByteBuf buf) throws IOException {
        this.write(buf, 0, buf.readableBytes());
    }

    public void write(ByteBuf buf, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        while (len > 0) {
            this.updateCurrentChunk(false);
            int toWrite = Math.min(len, this.mCurrentChunk.writableBytes());
            this.mCurrentChunk.writeBytes(buf, off, toWrite);
            off += toWrite;
            len -= toWrite;
        }
        this.updateCurrentChunk(false);
    }

    @Override
    public void flush() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.updateCurrentChunk(true);
        for (DataWriter dataWriter : this.mDataWriters) {
            dataWriter.flush();
        }
    }

    @Override
    public void cancel() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.releaseCurrentChunk();
        Throwable exception = null;
        for (DataWriter dataWriter : this.mDataWriters) {
            try {
                dataWriter.cancel();
            }
            catch (IOException e) {
                if (exception == null) continue;
                exception.addSuppressed(e);
            }
        }
        if (exception != null) {
            throw exception;
        }
        this.close();
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        try {
            this.updateCurrentChunk(true);
        }
        catch (Throwable t) {
            throw this.mCloser.rethrow(t);
        }
        finally {
            this.mClosed = true;
            this.mCloser.close();
        }
    }

    public WorkerNetAddress getAddress() {
        return this.mAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCurrentChunk(boolean lastChunk) throws IOException {
        if (this.mCurrentChunk != null && this.mCurrentChunk.writableBytes() > 0 && !lastChunk) {
            return;
        }
        if (this.mCurrentChunk == null) {
            if (!lastChunk) {
                this.mCurrentChunk = this.allocateBuffer();
            }
            return;
        }
        if (this.mCurrentChunk.writableBytes() == 0 || lastChunk) {
            try {
                if (this.mCurrentChunk.readableBytes() > 0) {
                    for (DataWriter dataWriter : this.mDataWriters) {
                        this.mCurrentChunk.retain();
                        dataWriter.writeChunk(this.mCurrentChunk.duplicate());
                    }
                } else {
                    Preconditions.checkState(lastChunk);
                }
            }
            finally {
                this.mCurrentChunk.release();
                this.mCurrentChunk = null;
            }
        }
        if (!lastChunk) {
            this.mCurrentChunk = this.allocateBuffer();
        }
    }

    private void releaseCurrentChunk() {
        if (this.mCurrentChunk != null) {
            this.mCurrentChunk.release();
            this.mCurrentChunk = null;
        }
    }

    private ByteBuf allocateBuffer() {
        return PooledByteBufAllocator.DEFAULT.buffer(this.mDataWriters.get(0).chunkSize());
    }
}

