/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.AlluxioURI;
import alluxio.ClientContext;
import alluxio.client.file.BaseFileSystem;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.URIStatus;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.Source;
import alluxio.exception.AlluxioException;
import alluxio.exception.DirectoryNotEmptyException;
import alluxio.exception.FileAlreadyExistsException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.InvalidPathException;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.DeletePOptions;
import alluxio.grpc.ExistsPOptions;
import alluxio.grpc.FreePOptions;
import alluxio.grpc.GetStatusPOptions;
import alluxio.grpc.ListStatusPOptions;
import alluxio.grpc.MountPOptions;
import alluxio.grpc.OpenFilePOptions;
import alluxio.grpc.RenamePOptions;
import alluxio.grpc.ScheduleAsyncPersistencePOptions;
import alluxio.grpc.SetAclAction;
import alluxio.grpc.SetAclPOptions;
import alluxio.grpc.SetAttributePOptions;
import alluxio.grpc.UnmountPOptions;
import alluxio.master.MasterInquireClient;
import alluxio.security.authorization.AclEntry;
import alluxio.security.user.UserState;
import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.uri.Authority;
import alluxio.util.ConfigurationUtils;
import alluxio.wire.BlockLocationInfo;
import alluxio.wire.MountPointInfo;
import alluxio.wire.SyncPointInfo;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface FileSystem
extends Closeable {
    public boolean isClosed();

    public void createDirectory(AlluxioURI var1) throws FileAlreadyExistsException, InvalidPathException, IOException, AlluxioException;

    public void createDirectory(AlluxioURI var1, CreateDirectoryPOptions var2) throws FileAlreadyExistsException, InvalidPathException, IOException, AlluxioException;

    public FileOutStream createFile(AlluxioURI var1) throws FileAlreadyExistsException, InvalidPathException, IOException, AlluxioException;

    public FileOutStream createFile(AlluxioURI var1, CreateFilePOptions var2) throws FileAlreadyExistsException, InvalidPathException, IOException, AlluxioException;

    public void delete(AlluxioURI var1) throws DirectoryNotEmptyException, FileDoesNotExistException, IOException, AlluxioException;

    public void delete(AlluxioURI var1, DeletePOptions var2) throws DirectoryNotEmptyException, FileDoesNotExistException, IOException, AlluxioException;

    public boolean exists(AlluxioURI var1) throws InvalidPathException, IOException, AlluxioException;

    public boolean exists(AlluxioURI var1, ExistsPOptions var2) throws InvalidPathException, IOException, AlluxioException;

    public void free(AlluxioURI var1) throws FileDoesNotExistException, IOException, AlluxioException;

    public void free(AlluxioURI var1, FreePOptions var2) throws FileDoesNotExistException, IOException, AlluxioException;

    public List<BlockLocationInfo> getBlockLocations(AlluxioURI var1) throws FileDoesNotExistException, IOException, AlluxioException;

    public AlluxioConfiguration getConf();

    public URIStatus getStatus(AlluxioURI var1) throws FileDoesNotExistException, IOException, AlluxioException;

    public URIStatus getStatus(AlluxioURI var1, GetStatusPOptions var2) throws FileDoesNotExistException, IOException, AlluxioException;

    public List<URIStatus> listStatus(AlluxioURI var1) throws FileDoesNotExistException, IOException, AlluxioException;

    public List<URIStatus> listStatus(AlluxioURI var1, ListStatusPOptions var2) throws FileDoesNotExistException, IOException, AlluxioException;

    public void mount(AlluxioURI var1, AlluxioURI var2) throws IOException, AlluxioException;

    public void mount(AlluxioURI var1, AlluxioURI var2, MountPOptions var3) throws IOException, AlluxioException;

    public void updateMount(AlluxioURI var1, MountPOptions var2) throws IOException, AlluxioException;

    public Map<String, MountPointInfo> getMountTable() throws IOException, AlluxioException;

    public List<SyncPointInfo> getSyncPathList() throws IOException, AlluxioException;

    public FileInStream openFile(AlluxioURI var1) throws FileDoesNotExistException, IOException, AlluxioException;

    public FileInStream openFile(AlluxioURI var1, OpenFilePOptions var2) throws FileDoesNotExistException, IOException, AlluxioException;

    public void persist(AlluxioURI var1) throws FileDoesNotExistException, IOException, AlluxioException;

    public void persist(AlluxioURI var1, ScheduleAsyncPersistencePOptions var2) throws FileDoesNotExistException, IOException, AlluxioException;

    public void rename(AlluxioURI var1, AlluxioURI var2) throws FileDoesNotExistException, IOException, AlluxioException;

    public void rename(AlluxioURI var1, AlluxioURI var2, RenamePOptions var3) throws FileDoesNotExistException, IOException, AlluxioException;

    public void setAcl(AlluxioURI var1, SetAclAction var2, List<AclEntry> var3) throws FileDoesNotExistException, IOException, AlluxioException;

    public void setAcl(AlluxioURI var1, SetAclAction var2, List<AclEntry> var3, SetAclPOptions var4) throws FileDoesNotExistException, IOException, AlluxioException;

    public void startSync(AlluxioURI var1) throws FileDoesNotExistException, IOException, AlluxioException;

    public void stopSync(AlluxioURI var1) throws FileDoesNotExistException, IOException, AlluxioException;

    public void setAttribute(AlluxioURI var1) throws FileDoesNotExistException, IOException, AlluxioException;

    public void setAttribute(AlluxioURI var1, SetAttributePOptions var2) throws FileDoesNotExistException, IOException, AlluxioException;

    public void unmount(AlluxioURI var1) throws IOException, AlluxioException;

    public void unmount(AlluxioURI var1, UnmountPOptions var2) throws IOException, AlluxioException;

    public static class FileSystemKey {
        final Subject mSubject;
        final Authority mAuth;
        final AlluxioConfiguration mConf;

        public FileSystemKey(Subject subject, AlluxioConfiguration conf) {
            this.mConf = conf;
            this.mSubject = subject;
            this.mAuth = MasterInquireClient.Factory.getConnectDetails(conf).toAuthority();
        }

        public FileSystemKey(ClientContext ctx) {
            this(ctx.getSubject(), ctx.getClusterConf());
        }

        public int hashCode() {
            return Objects.hash(this.mSubject, this.mAuth);
        }

        public boolean equals(Object o) {
            if (!(o instanceof FileSystemKey)) {
                return false;
            }
            FileSystemKey otherKey = (FileSystemKey)o;
            return Objects.equals(this.mSubject, otherKey.mSubject) && Objects.equals(this.mAuth, otherKey.mAuth);
        }
    }

    public static class Cache {
        final ConcurrentHashMap<FileSystemKey, FileSystem> mCacheMap = new ConcurrentHashMap();

        public FileSystem get(FileSystemKey key) {
            return this.mCacheMap.computeIfAbsent(key, fileSystemKey -> Factory.create(FileSystemContext.create(key.mSubject, key.mConf), true));
        }

        public FileSystem remove(FileSystemKey key) {
            return this.mCacheMap.remove(key);
        }

        @VisibleForTesting
        void purge() {
            this.mCacheMap.forEach((fsKey, fs) -> {
                try {
                    this.mCacheMap.remove(fsKey);
                    fs.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    public static class Factory {
        private static final Logger LOG = LoggerFactory.getLogger(Factory.class);
        private static final AtomicBoolean CONF_LOGGED = new AtomicBoolean(false);
        protected static final Cache FILESYSTEM_CACHE = new Cache();

        private Factory() {
        }

        public static FileSystem get() {
            return Factory.get(new Subject());
        }

        public static FileSystem get(Subject subject) {
            Preconditions.checkNotNull(subject, "subject");
            InstancedConfiguration conf = new InstancedConfiguration(ConfigurationUtils.defaults());
            FileSystemKey key = new FileSystemKey(UserState.Factory.create(conf, subject).getSubject(), conf);
            return FILESYSTEM_CACHE.get(key);
        }

        public static FileSystem create(AlluxioConfiguration alluxioConf) {
            return Factory.create(FileSystemContext.create(alluxioConf), false);
        }

        public static FileSystem create(ClientContext ctx) {
            return Factory.create(FileSystemContext.create(ctx), false);
        }

        public static FileSystem create(FileSystemContext context) {
            return Factory.create(context, false);
        }

        private static FileSystem create(FileSystemContext context, boolean cachingEnabled) {
            if (LOG.isDebugEnabled() && !CONF_LOGGED.getAndSet(true)) {
                AlluxioConfiguration conf = context.getClusterConf();
                ArrayList<PropertyKey> keys = new ArrayList<PropertyKey>(conf.keySet());
                keys.sort(Comparator.comparing(PropertyKey::getName));
                for (PropertyKey key : keys) {
                    String value = conf.getOrDefault(key, null);
                    Source source = conf.getSource(key);
                    LOG.debug("{}={} ({})", new Object[]{key.getName(), value, source});
                }
            }
            return BaseFileSystem.create(context, cachingEnabled);
        }
    }
}

