/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.client.file.ConfigHashSync;
import alluxio.client.file.FileSystemContext;
import alluxio.concurrent.CountingLatch;
import alluxio.conf.PropertyKey;
import alluxio.heartbeat.HeartbeatThread;
import alluxio.util.ThreadFactoryUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class FileSystemContextReinitializer
implements Closeable {
    private final FileSystemContext mContext;
    private final ConfigHashSync mExecutor;
    private final ExecutorService mExecutorService;
    private CountingLatch mLatch = new CountingLatch();

    public FileSystemContextReinitializer(FileSystemContext context) {
        this.mContext = context;
        this.mExecutor = new ConfigHashSync(context);
        this.mExecutorService = Executors.newSingleThreadExecutor(ThreadFactoryUtils.build("config-hash-master-heartbeat-%d", true));
        this.mExecutorService.submit(new HeartbeatThread("Meta Master Config Hash Sync", this.mContext.getId(), this.mExecutor, (int)this.mContext.getClientContext().getClusterConf().getMs(PropertyKey.USER_CONF_SYNC_INTERVAL), this.mContext.getClientContext().getClusterConf(), this.mContext.getClientContext().getUserState()));
    }

    public void onSuccess() {
        this.mExecutor.resetMetaMasterConfigClient(this.mContext.getMasterClientContext());
    }

    public ReinitBlockerResource block() throws IOException, InterruptedException {
        Optional<IOException> exception = this.mExecutor.getException();
        if (exception.isPresent()) {
            throw exception.get();
        }
        ReinitBlockerResource r = new ReinitBlockerResource(this.mLatch);
        exception = this.mExecutor.getException();
        if (exception.isPresent()) {
            r.close();
            throw exception.get();
        }
        return r;
    }

    public ReinitAllowerResource allow() {
        return new ReinitAllowerResource(this.mLatch);
    }

    @Override
    public void close() {
        if (!this.mExecutorService.isShutdown()) {
            this.mExecutorService.shutdownNow();
        }
    }

    public static final class ReinitAllowerResource
    implements Closeable {
        private CountingLatch mLatch;

        public ReinitAllowerResource(CountingLatch latch) {
            this.mLatch = latch;
            this.mLatch.await();
        }

        @Override
        public void close() {
            this.mLatch.release();
        }
    }

    public static final class ReinitBlockerResource
    implements Closeable {
        private CountingLatch mLatch;

        public ReinitBlockerResource(CountingLatch latch) throws InterruptedException {
            this.mLatch = latch;
            this.mLatch.inc();
        }

        @Override
        public void close() {
            this.mLatch.dec();
        }
    }
}

