/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.metrics;

import alluxio.AbstractMasterClient;
import alluxio.exception.status.UnavailableException;
import alluxio.grpc.ClientMetrics;
import alluxio.grpc.MetricsHeartbeatPOptions;
import alluxio.grpc.MetricsHeartbeatPRequest;
import alluxio.grpc.MetricsMasterClientServiceGrpc;
import alluxio.grpc.ServiceType;
import alluxio.master.MasterClientContext;
import alluxio.retry.RetryUtils;
import alluxio.shaded.client.io.grpc.StatusRuntimeException;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.io.IOException;
import java.util.List;

@ThreadSafe
public class MetricsMasterClient
extends AbstractMasterClient {
    private MetricsMasterClientServiceGrpc.MetricsMasterClientServiceBlockingStub mClient = null;

    public MetricsMasterClient(MasterClientContext conf) {
        super(conf, null, RetryUtils::defaultMetricsClientRetry);
    }

    @Override
    protected ServiceType getRemoteServiceType() {
        return ServiceType.METRICS_MASTER_CLIENT_SERVICE;
    }

    @Override
    protected String getServiceName() {
        return "MetricsMasterClient";
    }

    @Override
    protected long getServiceVersion() {
        return 2L;
    }

    @Override
    protected void afterConnect() {
        this.mClient = MetricsMasterClientServiceGrpc.newBlockingStub(this.mChannel);
    }

    public void heartbeat(List<ClientMetrics> metrics) throws IOException {
        this.connect();
        try {
            MetricsHeartbeatPRequest.Builder request = MetricsHeartbeatPRequest.newBuilder();
            request.setOptions(MetricsHeartbeatPOptions.newBuilder().addAllClientMetrics(metrics).build());
            this.mClient.metricsHeartbeat(request.build());
        }
        catch (StatusRuntimeException e) {
            this.disconnect();
            throw new UnavailableException(e);
        }
    }
}

