/*
 * Decompiled with CFR 0.152.
 */
package alluxio.grpc;

import alluxio.grpc.GrpcManagedChannelPool;
import alluxio.security.authentication.AuthenticatedChannel;
import alluxio.shaded.client.io.grpc.CallOptions;
import alluxio.shaded.client.io.grpc.Channel;
import alluxio.shaded.client.io.grpc.ClientCall;
import alluxio.shaded.client.io.grpc.ClientInterceptor;
import alluxio.shaded.client.io.grpc.ClientInterceptors;
import alluxio.shaded.client.io.grpc.ForwardingClientCall;
import alluxio.shaded.client.io.grpc.ForwardingClientCallListener;
import alluxio.shaded.client.io.grpc.Metadata;
import alluxio.shaded.client.io.grpc.MethodDescriptor;
import alluxio.shaded.client.io.grpc.Status;
import java.util.function.Supplier;

public final class GrpcChannel
extends Channel {
    private final GrpcManagedChannelPool.ChannelKey mChannelKey;
    private Supplier<Boolean> mChannelHealthState;
    private Channel mChannel;
    private Runnable mAuthCloseCallback;
    private boolean mChannelReleased;
    private boolean mChannelHealthy = true;
    private final long mShutdownTimeoutMs;

    public GrpcChannel(GrpcManagedChannelPool.ChannelKey channelKey, Channel channel, long shutdownTimeoutMs) {
        this.mChannelKey = channelKey;
        this.mChannelHealthState = () -> this.mChannelHealthy;
        this.mChannel = ClientInterceptors.intercept(channel, new ChannelResponseTracker(this));
        this.mChannelReleased = false;
        this.mShutdownTimeoutMs = shutdownTimeoutMs;
    }

    public GrpcChannel(GrpcManagedChannelPool.ChannelKey channelKey, AuthenticatedChannel channel, long shutdownTimeoutMs) {
        this(channelKey, (Channel)channel, shutdownTimeoutMs);
        this.mChannelHealthState = () -> channel.isAuthenticated() && this.mChannelHealthy;
        this.mAuthCloseCallback = channel::close;
    }

    @Override
    public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
        return this.mChannel.newCall(methodDescriptor, callOptions);
    }

    @Override
    public String authority() {
        return this.mChannel.authority();
    }

    public void intercept(ClientInterceptor interceptor) {
        this.mChannel = ClientInterceptors.intercept(this.mChannel, interceptor);
    }

    public void shutdown() {
        if (this.mAuthCloseCallback != null) {
            this.mAuthCloseCallback.run();
        }
        if (!this.mChannelReleased) {
            GrpcManagedChannelPool.INSTANCE().releaseManagedChannel(this.mChannelKey, this.mShutdownTimeoutMs);
        }
        this.mChannelReleased = true;
    }

    public boolean isShutdown() {
        return this.mChannelReleased;
    }

    public boolean isHealthy() {
        return this.mChannelHealthState.get();
    }

    private class ChannelResponseTracker
    implements ClientInterceptor {
        private GrpcChannel mGrpcChannel;

        public ChannelResponseTracker(GrpcChannel grpcChannel2) {
            this.mGrpcChannel = grpcChannel2;
        }

        @Override
        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

                @Override
                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                    super.start(new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                        @Override
                        public void onClose(Status status, Metadata trailers) {
                            if (status == Status.UNAUTHENTICATED || status == Status.UNAVAILABLE) {
                                ChannelResponseTracker.this.mGrpcChannel.mChannelHealthy = false;
                            }
                            super.onClose(status, trailers);
                        }
                    }, headers);
                }
            };
        }
    }
}

