/*
 * Decompiled with CFR 0.152.
 */
package alluxio.grpc;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.grpc.GrpcChannel;
import alluxio.grpc.GrpcManagedChannelPool;
import alluxio.grpc.GrpcServerAddress;
import alluxio.security.authentication.AuthType;
import alluxio.security.authentication.ChannelAuthenticator;
import alluxio.shaded.client.io.grpc.ManagedChannel;
import alluxio.shaded.client.io.netty.channel.Channel;
import alluxio.shaded.client.io.netty.channel.EventLoopGroup;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;

public final class GrpcChannelBuilder {
    private GrpcManagedChannelPool.ChannelKey mChannelKey;
    private GrpcServerAddress mServerAddress;
    private boolean mUseSubject;
    private Subject mParentSubject;
    private String mUserName;
    private String mPassword;
    private String mImpersonationUser;
    private boolean mAuthenticateChannel;
    private AlluxioConfiguration mConfiguration;

    private GrpcChannelBuilder(GrpcServerAddress address, AlluxioConfiguration conf) {
        this.mServerAddress = address;
        this.mConfiguration = conf;
        this.mChannelKey = GrpcManagedChannelPool.ChannelKey.create(conf);
        this.mChannelKey.setAddress(address.getSocketAddress());
        this.mChannelKey.setMaxInboundMessageSize((int)this.mConfiguration.getBytes(PropertyKey.USER_NETWORK_MAX_INBOUND_MESSAGE_SIZE));
        this.mUseSubject = true;
        this.mAuthenticateChannel = true;
    }

    public static GrpcChannelBuilder newBuilder(GrpcServerAddress address, AlluxioConfiguration conf) {
        return new GrpcChannelBuilder(address, conf);
    }

    public GrpcChannelBuilder setSubject(Subject subject) {
        this.mParentSubject = subject;
        this.mUseSubject = true;
        return this;
    }

    public GrpcChannelBuilder setCredentials(String userName, String password, String impersonationUser) {
        this.mUserName = userName;
        this.mPassword = password;
        this.mImpersonationUser = impersonationUser;
        this.mUseSubject = false;
        return this;
    }

    public GrpcChannelBuilder disableAuthentication() {
        this.mAuthenticateChannel = false;
        return this;
    }

    public GrpcChannelBuilder setKeepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
        this.mChannelKey.setKeepAliveTime(keepAliveTime, timeUnit);
        return this;
    }

    public GrpcChannelBuilder setKeepAliveTimeout(long keepAliveTimeout, TimeUnit timeUnit) {
        this.mChannelKey.setKeepAliveTimeout(keepAliveTimeout, timeUnit);
        return this;
    }

    public GrpcChannelBuilder setMaxInboundMessageSize(int maxInboundMessaageSize) {
        this.mChannelKey.setMaxInboundMessageSize(maxInboundMessaageSize);
        return this;
    }

    public GrpcChannelBuilder setFlowControlWindow(int flowControlWindow) {
        this.mChannelKey.setFlowControlWindow(flowControlWindow);
        return this;
    }

    public GrpcChannelBuilder setChannelType(Class<? extends Channel> channelType) {
        this.mChannelKey.setChannelType(channelType);
        return this;
    }

    public GrpcChannelBuilder setEventLoopGroup(EventLoopGroup group) {
        this.mChannelKey.setEventLoopGroup(group);
        return this;
    }

    public GrpcChannelBuilder setPoolingStrategy(GrpcManagedChannelPool.PoolingStrategy strategy) {
        this.mChannelKey.setPoolingStrategy(strategy);
        return this;
    }

    public GrpcChannel build() throws AlluxioStatusException {
        ManagedChannel underlyingChannel = GrpcManagedChannelPool.INSTANCE().acquireManagedChannel(this.mChannelKey, this.mConfiguration.getMs(PropertyKey.NETWORK_CONNECTION_HEALTH_CHECK_TIMEOUT), this.mConfiguration.getMs(PropertyKey.NETWORK_CONNECTION_SHUTDOWN_TIMEOUT));
        try {
            AuthType authType = this.mConfiguration.getEnum(PropertyKey.SECURITY_AUTHENTICATION_TYPE, AuthType.class);
            if (this.mAuthenticateChannel && authType != AuthType.NOSASL) {
                ChannelAuthenticator channelAuthenticator = this.mUseSubject ? new ChannelAuthenticator(this.mParentSubject, this.mConfiguration) : new ChannelAuthenticator(this.mUserName, this.mPassword, this.mImpersonationUser, this.mConfiguration.getEnum(PropertyKey.SECURITY_AUTHENTICATION_TYPE, AuthType.class), this.mConfiguration.getMs(PropertyKey.NETWORK_CONNECTION_AUTH_TIMEOUT));
                return new GrpcChannel(this.mChannelKey, channelAuthenticator.authenticate(this.mServerAddress, underlyingChannel), this.mConfiguration.getMs(PropertyKey.NETWORK_CONNECTION_SHUTDOWN_TIMEOUT));
            }
            return new GrpcChannel(this.mChannelKey, underlyingChannel, this.mConfiguration.getMs(PropertyKey.NETWORK_CONNECTION_SHUTDOWN_TIMEOUT));
        }
        catch (Exception exc) {
            GrpcManagedChannelPool.INSTANCE().releaseManagedChannel(this.mChannelKey, this.mConfiguration.getMs(PropertyKey.NETWORK_CONNECTION_SHUTDOWN_TIMEOUT));
            throw exc;
        }
    }
}

