/*
 * Decompiled with CFR 0.152.
 */
package alluxio.grpc;

import alluxio.collections.Pair;
import alluxio.conf.AlluxioConfiguration;
import alluxio.resource.LockResource;
import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.common.base.Verify;
import alluxio.shaded.client.io.grpc.ConnectivityState;
import alluxio.shaded.client.io.grpc.ManagedChannel;
import alluxio.shaded.client.io.grpc.netty.NettyChannelBuilder;
import alluxio.shaded.client.io.netty.channel.Channel;
import alluxio.shaded.client.io.netty.channel.EventLoopGroup;
import alluxio.shaded.client.javax.annotation.concurrent.GuardedBy;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.shaded.client.org.apache.commons.lang.builder.HashCodeBuilder;
import alluxio.util.CommonUtils;
import alluxio.util.WaitForOptions;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class GrpcManagedChannelPool {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcManagedChannelPool.class);
    private static final Random RANDOM = new Random();
    private static GrpcManagedChannelPool sInstance = new GrpcManagedChannelPool();
    @GuardedBy(value="mLock")
    private HashMap<ChannelKey, ManagedChannelReference> mChannels = new HashMap();
    private ReentrantReadWriteLock mLock = new ReentrantReadWriteLock(true);
    protected ScheduledExecutorService mScheduler;

    public static GrpcManagedChannelPool INSTANCE() {
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownManagedChannel(ChannelKey channelKey, long shutdownTimeoutMs) {
        ManagedChannel managedChannel = this.mChannels.get(channelKey).get();
        managedChannel.shutdown();
        try {
            managedChannel.awaitTermination(shutdownTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            managedChannel.shutdownNow();
        }
        Verify.verify(managedChannel.isShutdown());
        LOG.debug("Shut down managed channel. ChannelKey: {}", (Object)channelKey);
    }

    private boolean waitForChannelReady(ManagedChannel managedChannel, long healthCheckTimeoutMs) {
        try {
            Boolean res = CommonUtils.waitForResult("channel to be ready", () -> {
                ConnectivityState currentState = managedChannel.getState(true);
                switch (currentState) {
                    case READY: {
                        return true;
                    }
                    case TRANSIENT_FAILURE: 
                    case SHUTDOWN: {
                        return false;
                    }
                    case IDLE: 
                    case CONNECTING: {
                        return null;
                    }
                }
                return null;
            }, WaitForOptions.defaults().setTimeoutMs((int)healthCheckTimeoutMs));
            return res;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    public ManagedChannel acquireManagedChannel(ChannelKey channelKey, long healthCheckTimeoutMs, long shutdownTimeoutMs) {
        boolean shutdownExistingChannel = false;
        ManagedChannelReference managedChannelRef = null;
        try (LockResource lockShared = new LockResource(this.mLock.readLock());){
            if (this.mChannels.containsKey(channelKey)) {
                managedChannelRef = this.mChannels.get(channelKey);
                if (this.waitForChannelReady(managedChannelRef.get(), healthCheckTimeoutMs)) {
                    LOG.debug("Acquiring an existing managed channel. ChannelKey: {}. Ref-count: {}", (Object)channelKey, (Object)managedChannelRef.getRefCount());
                    ManagedChannel managedChannel = managedChannelRef.reference();
                    return managedChannel;
                }
                shutdownExistingChannel = true;
            }
        }
        var9_7 = null;
        try (LockResource lockExclusive = new LockResource(this.mLock.writeLock());){
            int existingRefCount = 0;
            if (shutdownExistingChannel && this.mChannels.containsKey(channelKey) && this.mChannels.get(channelKey) == managedChannelRef) {
                existingRefCount = managedChannelRef.getRefCount();
                LOG.debug("Shutting down an existing unhealthy managed channel. ChannelKey: {}. Existing Ref-count: {}", (Object)channelKey, (Object)existingRefCount);
                this.shutdownManagedChannel(channelKey, shutdownTimeoutMs);
                this.mChannels.remove(channelKey);
            }
            if (!this.mChannels.containsKey(channelKey)) {
                LOG.debug("Creating a new managed channel. ChannelKey: {}. Ref-count:{}", (Object)channelKey, (Object)existingRefCount);
                this.mChannels.put(channelKey, new ManagedChannelReference(this.createManagedChannel(channelKey), existingRefCount));
            }
            ManagedChannel managedChannel = this.mChannels.get(channelKey).reference();
            return managedChannel;
        }
        catch (Throwable throwable) {
            var9_7 = throwable;
            throw throwable;
        }
    }

    public void releaseManagedChannel(ChannelKey channelKey, long shutdownTimeoutMs) {
        boolean shutdownManagedChannel;
        try (LockResource lockShared = new LockResource(this.mLock.readLock());){
            Verify.verify(this.mChannels.containsKey(channelKey));
            ManagedChannelReference channelRef = this.mChannels.get(channelKey);
            channelRef.dereference();
            shutdownManagedChannel = channelRef.getRefCount() <= 0;
            LOG.debug("Released managed channel for: {}. Ref-count: {}", (Object)channelKey, (Object)channelRef.getRefCount());
        }
        if (shutdownManagedChannel) {
            var6_4 = null;
            try (LockResource lockExclusive = new LockResource(this.mLock.writeLock());){
                if (this.mChannels.containsKey(channelKey) && (channelRef = this.mChannels.get(channelKey)).getRefCount() <= 0) {
                    this.shutdownManagedChannel(channelKey, shutdownTimeoutMs);
                }
            }
            catch (Throwable throwable) {
                var6_4 = throwable;
                throw throwable;
            }
        }
    }

    private ManagedChannel createManagedChannel(ChannelKey channelKey) {
        NettyChannelBuilder channelBuilder;
        if (channelKey.mAddress instanceof InetSocketAddress) {
            InetSocketAddress inetServerAddress = (InetSocketAddress)channelKey.mAddress;
            channelBuilder = NettyChannelBuilder.forAddress(inetServerAddress.getHostName(), inetServerAddress.getPort());
        } else {
            channelBuilder = NettyChannelBuilder.forAddress(channelKey.mAddress);
        }
        if (channelKey.mKeepAliveTime.isPresent()) {
            channelBuilder.keepAliveTime((Long)((Pair)channelKey.mKeepAliveTime.get()).getFirst(), (TimeUnit)((Object)((Pair)channelKey.mKeepAliveTime.get()).getSecond()));
        }
        if (channelKey.mKeepAliveTimeout.isPresent()) {
            channelBuilder.keepAliveTimeout((Long)((Pair)channelKey.mKeepAliveTimeout.get()).getFirst(), (TimeUnit)((Object)((Pair)channelKey.mKeepAliveTimeout.get()).getSecond()));
        }
        if (channelKey.mMaxInboundMessageSize.isPresent()) {
            channelBuilder.maxInboundMessageSize((Integer)channelKey.mMaxInboundMessageSize.get());
        }
        if (channelKey.mFlowControlWindow.isPresent()) {
            channelBuilder.flowControlWindow((Integer)channelKey.mFlowControlWindow.get());
        }
        if (channelKey.mChannelType.isPresent()) {
            channelBuilder.channelType((Class)channelKey.mChannelType.get());
        }
        if (channelKey.mEventLoopGroup.isPresent()) {
            channelBuilder.eventLoopGroup((EventLoopGroup)channelKey.mEventLoopGroup.get());
        }
        channelBuilder.usePlaintext();
        return channelBuilder.build();
    }

    public static class ChannelKey {
        private SocketAddress mAddress;
        private Optional<Pair<Long, TimeUnit>> mKeepAliveTime = Optional.empty();
        private Optional<Pair<Long, TimeUnit>> mKeepAliveTimeout = Optional.empty();
        private Optional<Integer> mMaxInboundMessageSize = Optional.empty();
        private Optional<Integer> mFlowControlWindow = Optional.empty();
        private Optional<Class<? extends Channel>> mChannelType = Optional.empty();
        private Optional<EventLoopGroup> mEventLoopGroup = Optional.empty();
        private long mPoolKey = 0L;

        public static ChannelKey create(AlluxioConfiguration conf) {
            return new ChannelKey();
        }

        private ChannelKey() {
        }

        public ChannelKey setAddress(SocketAddress address) {
            this.mAddress = address;
            return this;
        }

        public ChannelKey setKeepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
            this.mKeepAliveTime = Optional.of(new Pair<Long, TimeUnit>(keepAliveTime, timeUnit));
            return this;
        }

        public ChannelKey setKeepAliveTimeout(long keepAliveTimeout, TimeUnit timeUnit) {
            this.mKeepAliveTimeout = Optional.of(new Pair<Long, TimeUnit>(keepAliveTimeout, timeUnit));
            return this;
        }

        public ChannelKey setMaxInboundMessageSize(int maxInboundMessageSize) {
            this.mMaxInboundMessageSize = Optional.of(maxInboundMessageSize);
            return this;
        }

        public ChannelKey setFlowControlWindow(int flowControlWindow) {
            this.mFlowControlWindow = Optional.of(flowControlWindow);
            return this;
        }

        public ChannelKey setChannelType(Class<? extends Channel> channelType) {
            this.mChannelType = Optional.of(channelType);
            return this;
        }

        public ChannelKey setEventLoopGroup(EventLoopGroup eventLoopGroup) {
            this.mEventLoopGroup = Optional.of(eventLoopGroup);
            return this;
        }

        public ChannelKey setPoolingStrategy(PoolingStrategy strategy) {
            switch (strategy) {
                case DEFAULT: {
                    this.mPoolKey = 0L;
                    break;
                }
                case DISABLED: {
                    this.mPoolKey = RANDOM.nextLong();
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Invalid pooling strategy %s", strategy.name()));
                }
            }
            return this;
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.mAddress).append(this.mKeepAliveTime).append(this.mKeepAliveTimeout).append(this.mMaxInboundMessageSize).append(this.mFlowControlWindow).append(this.mPoolKey).append(this.mChannelType.isPresent() ? Integer.valueOf(System.identityHashCode(this.mChannelType.get())) : null).append(this.mEventLoopGroup.isPresent() ? Integer.valueOf(System.identityHashCode(this.mEventLoopGroup.get())) : null).toHashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof ChannelKey) {
                ChannelKey otherKey = (ChannelKey)other;
                return this.mAddress.equals(otherKey.mAddress) && this.mKeepAliveTime.equals(otherKey.mKeepAliveTime) && this.mKeepAliveTimeout.equals(otherKey.mKeepAliveTimeout) && this.mFlowControlWindow.equals(otherKey.mFlowControlWindow) && this.mMaxInboundMessageSize.equals(otherKey.mMaxInboundMessageSize) && this.mChannelType.equals(otherKey.mChannelType) && this.mPoolKey == otherKey.mPoolKey && this.mEventLoopGroup.equals(otherKey.mEventLoopGroup);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("Address", this.mAddress).add("KeepAliveTime", this.mKeepAliveTime).add("KeepAliveTimeout", this.mKeepAliveTimeout).add("FlowControlWindow", this.mFlowControlWindow).add("ChannelType", this.mChannelType).add("EventLoopGroup", this.mEventLoopGroup).toString();
        }
    }

    public static enum PoolingStrategy {
        DEFAULT,
        DISABLED;

    }

    private class ManagedChannelReference {
        private ManagedChannel mChannel;
        private AtomicInteger mRefCount;

        private ManagedChannelReference(ManagedChannel channel, int refCount) {
            this.mChannel = channel;
            this.mRefCount = new AtomicInteger(refCount);
        }

        private ManagedChannel reference() {
            this.mRefCount.incrementAndGet();
            return this.mChannel;
        }

        private void dereference() {
            this.mRefCount.decrementAndGet();
        }

        private int getRefCount() {
            return this.mRefCount.get();
        }

        private ManagedChannel get() {
            return this.mChannel;
        }
    }
}

