/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.UnavailableException;
import alluxio.master.PollingMasterInquireClient;
import alluxio.master.SingleMasterInquireClient;
import alluxio.master.ZkMasterInquireClient;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.uri.Authority;
import alluxio.util.ConfigurationUtils;
import alluxio.util.network.NetworkAddressUtils;
import java.net.InetSocketAddress;
import java.util.List;

@ThreadSafe
public interface MasterInquireClient {
    public InetSocketAddress getPrimaryRpcAddress() throws UnavailableException;

    public List<InetSocketAddress> getMasterRpcAddresses() throws UnavailableException;

    public ConnectDetails getConnectDetails();

    public static class Factory {
        public static MasterInquireClient create(AlluxioConfiguration conf) {
            if (conf.getBoolean(PropertyKey.ZOOKEEPER_ENABLED)) {
                return ZkMasterInquireClient.getClient(conf.get(PropertyKey.ZOOKEEPER_ADDRESS), conf.get(PropertyKey.ZOOKEEPER_ELECTION_PATH), conf.get(PropertyKey.ZOOKEEPER_LEADER_PATH), conf.getInt(PropertyKey.ZOOKEEPER_LEADER_INQUIRY_RETRY_COUNT), conf.getBoolean(PropertyKey.ZOOKEEPER_AUTH_ENABLED));
            }
            List<InetSocketAddress> addresses = ConfigurationUtils.getMasterRpcAddresses(conf);
            if (addresses.size() > 1) {
                return new PollingMasterInquireClient(addresses, conf);
            }
            return new SingleMasterInquireClient(addresses.get(0));
        }

        public static MasterInquireClient createForJobMaster(AlluxioConfiguration conf) {
            if (conf.getBoolean(PropertyKey.ZOOKEEPER_ENABLED)) {
                return ZkMasterInquireClient.getClient(conf.get(PropertyKey.ZOOKEEPER_ADDRESS), conf.get(PropertyKey.ZOOKEEPER_JOB_ELECTION_PATH), conf.get(PropertyKey.ZOOKEEPER_JOB_LEADER_PATH), conf.getInt(PropertyKey.ZOOKEEPER_LEADER_INQUIRY_RETRY_COUNT), conf.getBoolean(PropertyKey.ZOOKEEPER_AUTH_ENABLED));
            }
            List<InetSocketAddress> addresses = ConfigurationUtils.getJobMasterRpcAddresses(conf);
            if (addresses.size() > 1) {
                return new PollingMasterInquireClient(addresses, conf);
            }
            return new SingleMasterInquireClient(addresses.get(0));
        }

        public static ConnectDetails getConnectDetails(AlluxioConfiguration conf) {
            if (conf.getBoolean(PropertyKey.ZOOKEEPER_ENABLED)) {
                return new ZkMasterInquireClient.ZkMasterConnectDetails(conf.get(PropertyKey.ZOOKEEPER_ADDRESS), conf.get(PropertyKey.ZOOKEEPER_LEADER_PATH));
            }
            if (ConfigurationUtils.getMasterRpcAddresses(conf).size() > 1) {
                return new PollingMasterInquireClient.MultiMasterConnectDetails(ConfigurationUtils.getMasterRpcAddresses(conf));
            }
            return new SingleMasterInquireClient.SingleMasterConnectDetails(NetworkAddressUtils.getConnectAddress(NetworkAddressUtils.ServiceType.MASTER_RPC, conf));
        }

        private Factory() {
        }
    }

    public static interface ConnectDetails {
        public Authority toAuthority();

        public boolean equals(Object var1);

        public int hashCode();
    }
}

