/*
 * Decompiled with CFR 0.152.
 */
package alluxio.network;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RejectingServer
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(RejectingServer.class);
    private final int mPort;
    private ServerSocket mServerSocket;

    public RejectingServer(int port) {
        super("RejectingServer-" + port);
        this.mPort = port;
    }

    @Override
    public void run() {
        try {
            this.mServerSocket = new ServerSocket(this.mPort);
            this.mServerSocket.setReuseAddress(true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        while (!Thread.interrupted()) {
            try {
                Socket s2 = this.mServerSocket.accept();
                s2.close();
            }
            catch (SocketException e) {
                return;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void stopAndJoin() {
        this.interrupt();
        if (this.mServerSocket != null) {
            try {
                this.mServerSocket.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            this.join(5000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (this.isAlive()) {
            LOG.warn("Failed to stop rejecting server thread");
        }
    }
}

