/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.exception.status.UnauthenticatedException;
import alluxio.exception.status.UnknownException;
import alluxio.grpc.ChannelAuthenticationScheme;
import alluxio.grpc.GrpcServerAddress;
import alluxio.grpc.SaslAuthenticationServiceGrpc;
import alluxio.grpc.SaslMessage;
import alluxio.security.authentication.AuthType;
import alluxio.security.authentication.AuthenticatedChannel;
import alluxio.security.authentication.ChannelIdInjector;
import alluxio.security.authentication.DefaultSaslHandshakeClientHandler;
import alluxio.security.authentication.SaslClientHandler;
import alluxio.security.authentication.SaslStreamClientDriver;
import alluxio.security.authentication.plain.SaslClientHandlerPlain;
import alluxio.shaded.client.io.grpc.CallOptions;
import alluxio.shaded.client.io.grpc.Channel;
import alluxio.shaded.client.io.grpc.ClientCall;
import alluxio.shaded.client.io.grpc.ClientInterceptors;
import alluxio.shaded.client.io.grpc.ConnectivityState;
import alluxio.shaded.client.io.grpc.ManagedChannel;
import alluxio.shaded.client.io.grpc.MethodDescriptor;
import alluxio.shaded.client.io.grpc.stub.StreamObserver;
import java.net.SocketAddress;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger(ChannelAuthenticator.class);
    private AlluxioConfiguration mConfiguration;
    protected boolean mUseSubject;
    protected Subject mParentSubject;
    protected String mUserName;
    protected String mPassword;
    protected String mImpersonationUser;
    protected AuthType mAuthType;
    protected final long mGrpcAuthTimeoutMs;
    protected UUID mChannelId;

    public ChannelAuthenticator(Subject subject, AlluxioConfiguration conf) {
        this.mUseSubject = true;
        this.mParentSubject = subject;
        this.mConfiguration = conf;
        this.mChannelId = UUID.randomUUID();
        this.mAuthType = conf.getEnum(PropertyKey.SECURITY_AUTHENTICATION_TYPE, AuthType.class);
        this.mGrpcAuthTimeoutMs = conf.getMs(PropertyKey.NETWORK_CONNECTION_AUTH_TIMEOUT);
    }

    public ChannelAuthenticator(String userName, String password, String impersonationUser, AuthType authType, long grpcAuthTimeoutMs) {
        this.mUseSubject = false;
        this.mChannelId = UUID.randomUUID();
        this.mUserName = userName;
        this.mPassword = password;
        this.mImpersonationUser = impersonationUser;
        this.mAuthType = authType;
        this.mGrpcAuthTimeoutMs = grpcAuthTimeoutMs;
    }

    public AuthenticatedChannel authenticate(GrpcServerAddress serverAddress, ManagedChannel managedChannel) throws AlluxioStatusException {
        LOG.debug("Channel authentication initiated. ChannelId:{}, AuthType:{}, Target:{}", new Object[]{this.mChannelId, this.mAuthType, managedChannel.authority()});
        return new DefaultAuthenticatedChannel(serverAddress, managedChannel);
    }

    private class DefaultAuthenticatedChannel
    extends AuthenticatedChannel {
        private final GrpcServerAddress mServerAddress;
        private final ManagedChannel mManagedChannel;
        private Channel mChannel;
        private AtomicBoolean mAuthenticated;
        private SaslStreamClientDriver mClientDriver;

        DefaultAuthenticatedChannel(GrpcServerAddress serverAddress, ManagedChannel managedChannel) throws AlluxioStatusException {
            this.mServerAddress = serverAddress;
            this.mManagedChannel = managedChannel;
            this.mAuthenticated = new AtomicBoolean(false);
            this.authenticate();
        }

        public void authenticate() throws AlluxioStatusException {
            ChannelAuthenticationScheme authScheme = this.getChannelAuthScheme(ChannelAuthenticator.this.mParentSubject, this.mServerAddress.getSocketAddress());
            try (SaslClientHandler saslClientHandler = this.createSaslClientHandler(this.mServerAddress, authScheme, ChannelAuthenticator.this.mParentSubject);){
                DefaultSaslHandshakeClientHandler handshakeClient = new DefaultSaslHandshakeClientHandler(saslClientHandler);
                this.mClientDriver = new SaslStreamClientDriver(handshakeClient, this.mAuthenticated, ChannelAuthenticator.this.mChannelId, ChannelAuthenticator.this.mGrpcAuthTimeoutMs);
                StreamObserver<SaslMessage> requestObserver = SaslAuthenticationServiceGrpc.newStub(this.mManagedChannel).authenticate(this.mClientDriver);
                this.mClientDriver.setServerObserver(requestObserver);
                this.mClientDriver.start();
                this.mManagedChannel.notifyWhenStateChanged(ConnectivityState.READY, () -> this.mAuthenticated.set(false));
                this.mChannel = ClientInterceptors.intercept((Channel)this.mManagedChannel, new ChannelIdInjector(ChannelAuthenticator.this.mChannelId));
            }
            catch (Exception exc) {
                String message = String.format("Channel authentication failed. ChannelId: %s, AuthType: %s, Target: %s, Error: %s", new Object[]{ChannelAuthenticator.this.mChannelId, ChannelAuthenticator.this.mAuthType, this.mManagedChannel.authority(), exc.toString()});
                LOG.warn(message);
                if (exc instanceof AlluxioStatusException) {
                    throw AlluxioStatusException.from(((AlluxioStatusException)exc).getStatus().withDescription(message).withCause(exc));
                }
                throw new UnknownException(message, exc);
            }
        }

        private ChannelAuthenticationScheme getChannelAuthScheme(Subject subject, SocketAddress serverAddress) throws UnauthenticatedException {
            switch (ChannelAuthenticator.this.mAuthType) {
                case NOSASL: {
                    return ChannelAuthenticationScheme.NOSASL;
                }
                case SIMPLE: {
                    return ChannelAuthenticationScheme.SIMPLE;
                }
                case CUSTOM: {
                    return ChannelAuthenticationScheme.CUSTOM;
                }
            }
            throw new UnauthenticatedException(String.format("Configured authentication type is not supported: %s", ChannelAuthenticator.this.mAuthType.getAuthName()));
        }

        private SaslClientHandler createSaslClientHandler(GrpcServerAddress serverAddress, ChannelAuthenticationScheme authScheme, Subject subject) throws UnauthenticatedException {
            switch (authScheme) {
                case SIMPLE: 
                case CUSTOM: {
                    if (ChannelAuthenticator.this.mUseSubject) {
                        return new SaslClientHandlerPlain(ChannelAuthenticator.this.mParentSubject, ChannelAuthenticator.this.mConfiguration);
                    }
                    return new SaslClientHandlerPlain(ChannelAuthenticator.this.mUserName, ChannelAuthenticator.this.mPassword, ChannelAuthenticator.this.mImpersonationUser);
                }
            }
            throw new UnauthenticatedException(String.format("Channel authentication scheme not supported: %s", authScheme.name()));
        }

        @Override
        public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
            return this.mChannel.newCall(methodDescriptor, callOptions);
        }

        @Override
        public String authority() {
            return this.mChannel.authority();
        }

        @Override
        public boolean isAuthenticated() {
            return this.mAuthenticated.get();
        }

        @Override
        public UUID getChannelId() {
            return ChannelAuthenticator.this.mChannelId;
        }

        @Override
        public void close() {
            this.mClientDriver.stop();
        }
    }
}

